/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.List;
import javax.ws.rs.core.Response;
import org.keycloak.representations.idm.ErrorRepresentation;

public class ErrorResponse {
    public static Response exists(String message) {
        return ErrorResponse.error(message, Response.Status.CONFLICT);
    }

    public static Response error(String message, Response.Status status) {
        return ErrorResponse.error(message, null, status);
    }

    public static Response error(String message, Object[] params, Response.Status status) {
        ErrorRepresentation error = new ErrorRepresentation();
        error.setErrorMessage(message);
        error.setParams(params);
        return Response.status((Response.Status)status).entity((Object)error).type("application/json").build();
    }

    public static Response errors(List<ErrorRepresentation> s, Response.Status status) {
        return ErrorResponse.errors(s, status, true);
    }

    public static Response errors(List<ErrorRepresentation> s, Response.Status status, boolean shrinkSingleError) {
        if (shrinkSingleError && s.size() == 1) {
            return Response.status((Response.Status)status).entity((Object)s.get(0)).type("application/json").build();
        }
        ErrorRepresentation error = new ErrorRepresentation();
        error.setErrors(s);
        if (!shrinkSingleError && s.size() == 1) {
            error.setErrorMessage(s.get(0).getErrorMessage());
            error.setParams(s.get(0).getParams());
            error.setField(s.get(0).getField());
        }
        return Response.status((Response.Status)status).entity((Object)error).type("application/json").build();
    }
}

