/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RoleModel;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProvider;

public class ClientRolesCondition
extends AbstractClientPolicyConditionProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(ClientRolesCondition.class);

    public ClientRolesCondition(KeycloakSession session) {
        super(session);
    }

    public Class<Configuration> getConditionConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "client-roles";
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: 
            case TOKEN_REQUEST: 
            case TOKEN_RESPONSE: 
            case SERVICE_ACCOUNT_TOKEN_REQUEST: 
            case SERVICE_ACCOUNT_TOKEN_RESPONSE: 
            case TOKEN_REFRESH: 
            case TOKEN_REFRESH_RESPONSE: 
            case TOKEN_REVOKE: 
            case TOKEN_INTROSPECT: 
            case USERINFO_REQUEST: 
            case LOGOUT_REQUEST: 
            case BACKCHANNEL_AUTHENTICATION_REQUEST: 
            case BACKCHANNEL_TOKEN_REQUEST: 
            case BACKCHANNEL_TOKEN_RESPONSE: 
            case PUSHED_AUTHORIZATION_REQUEST: 
            case REGISTERED: 
            case UPDATED: {
                if (this.isRolesMatched(this.session.getContext().getClient())) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private boolean isRolesMatched(ClientModel client) {
        if (client == null) {
            return false;
        }
        Set<String> rolesForMatching = this.getRolesForMatching();
        if (rolesForMatching == null) {
            return false;
        }
        Set<String> clientRoles = client.getRolesStream().map(RoleModel::getName).collect(Collectors.toSet());
        if (logger.isTraceEnabled()) {
            clientRoles.forEach(i -> logger.tracev("client role assigned = {0}", i));
            rolesForMatching.forEach(i -> logger.tracev("client role for matching = {0}", i));
        }
        return rolesForMatching.removeAll(clientRoles);
    }

    private Set<String> getRolesForMatching() {
        if (((Configuration)this.configuration).getRoles() == null) {
            return null;
        }
        return new HashSet<String>(((Configuration)this.configuration).getRoles());
    }

    public static class Configuration
    extends ClientPolicyConditionConfigurationRepresentation {
        protected List<String> roles;

        public List<String> getRoles() {
            return this.roles;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }
    }
}

