/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.RemoteDevState;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.vertx.core.runtime.VertxCoreRecorder;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.logging.Logger;

public class RemoteSyncHandler
implements Handler<HttpServerRequest> {
    public static final String QUARKUS_PASSWORD = "X-Quarkus-Password";
    private static final Logger log = Logger.getLogger(RemoteSyncHandler.class);
    public static final String APPLICATION_QUARKUS = "application/quarkus-live-reload";
    public static final String QUARKUS_SESSION = "X-Quarkus-Session";
    public static final String QUARKUS_ERROR = "X-Quarkus-Error";
    public static final String QUARKUS_SESSION_COUNT = "X-Quarkus-Count";
    public static final String CONNECT = "/connect";
    public static final String DEV = "/dev";
    public static final String PROBE = "/probe";
    final String password;
    final Handler<HttpServerRequest> next;
    final HotReplacementContext hotReplacementContext;
    static volatile String currentSession;
    static volatile int currentSessionCounter;
    static volatile long currentSessionTimeout;
    static volatile Throwable remoteProblem;
    static volatile boolean checkForChanges;

    public RemoteSyncHandler(String password, Handler<HttpServerRequest> next, HotReplacementContext hotReplacementContext) {
        this.password = password;
        this.next = next;
        this.hotReplacementContext = hotReplacementContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPreScan() {
        if (currentSession == null) {
            return;
        }
        Class<RemoteSyncHandler> clazz = RemoteSyncHandler.class;
        synchronized (RemoteSyncHandler.class) {
            checkForChanges = true;
            RemoteSyncHandler.class.notifyAll();
            try {
                RemoteSyncHandler.class.wait(30000L);
            }
            catch (InterruptedException e) {
                log.error((Object)"interrupted", (Throwable)e);
            }
            return;
        }
    }

    public void handle(final HttpServerRequest event) {
        String type;
        long time = System.currentTimeMillis();
        if (time > currentSessionTimeout) {
            currentSession = null;
            currentSessionCounter = 0;
        }
        if (APPLICATION_QUARKUS.equals(type = event.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE))) {
            currentSessionTimeout = time + 60000L;
            ((Vertx)VertxCoreRecorder.getVertx().get()).executeBlocking((Handler)new Handler<Promise<Object>>(){

                public void handle(Promise<Object> promise) {
                    try {
                        RemoteSyncHandler.this.handleRequest(event);
                    }
                    finally {
                        promise.complete();
                    }
                }
            }, null);
            return;
        }
        this.next.handle((Object)event);
    }

    private void handleRequest(HttpServerRequest event) {
        if (event.method().equals((Object)HttpMethod.PUT)) {
            this.handlePut(event);
        } else if (event.method().equals((Object)HttpMethod.DELETE)) {
            this.handleDelete(event);
        } else if (event.method().equals((Object)HttpMethod.POST)) {
            if (event.path().equals(DEV)) {
                this.handleDev(event);
            } else if (event.path().equals(CONNECT)) {
                this.handleConnect(event);
            } else if (event.path().equals(PROBE)) {
                event.response().end();
            } else {
                event.response().putHeader(QUARKUS_ERROR, "Unknown path " + event.path() + " make sure your remote dev URL is pointing to the context root for your Quarkus instance, and not to a sub path.").setStatusCode(404).end();
            }
        } else {
            event.response().putHeader(QUARKUS_ERROR, "Unknown method " + event.method() + " this is not a valid remote dev request").setStatusCode(405).end();
        }
    }

    private void handleDev(final HttpServerRequest event) {
        event.bodyHandler((Handler)new Handler<Buffer>(){

            public void handle(final Buffer b) {
                if (RemoteSyncHandler.this.checkSession(event, b.getBytes())) {
                    return;
                }
                ((Vertx)VertxCoreRecorder.getVertx().get()).executeBlocking((Handler)new Handler<Promise<Object>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handle(Promise<Object> promise) {
                        try {
                            Throwable problem = (Throwable)new ObjectInputStream(new ByteArrayInputStream(b.getBytes())).readObject();
                            if (problem != null || remoteProblem != null) {
                                remoteProblem = problem;
                                RemoteSyncHandler.this.hotReplacementContext.setRemoteProblem(problem);
                            }
                            Class<RemoteSyncHandler> clazz = RemoteSyncHandler.class;
                            synchronized (RemoteSyncHandler.class) {
                                RemoteSyncHandler.class.notifyAll();
                                RemoteSyncHandler.class.wait(10000L);
                                if (checkForChanges) {
                                    checkForChanges = false;
                                    event.response().setStatusCode(200);
                                } else {
                                    event.response().setStatusCode(204);
                                }
                                event.response().end();
                                // ** MonitorExit[var3_5] (shouldn't be in output)
                            }
                        }
                        catch (RejectedExecutionException e) {
                            event.connection().close();
                        }
                        catch (Exception e) {
                            log.error((Object)"Connect failed", (Throwable)e);
                            event.response().setStatusCode(500).end();
                        }
                        finally {
                            promise.complete();
                        }
                        {
                            return;
                        }
                    }
                }, null);
            }
        }).exceptionHandler((Handler)new Handler<Throwable>(){

            public void handle(Throwable t) {
                log.error((Object)"dev request failed", t);
                event.response().setStatusCode(500).end();
            }
        }).resume();
    }

    private void handleConnect(final HttpServerRequest event) {
        event.bodyHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer b) {
                try {
                    String rp = event.headers().get(RemoteSyncHandler.QUARKUS_PASSWORD);
                    String bodyHash = HashUtil.sha256((byte[])b.getBytes());
                    String compare = HashUtil.sha256((String)(bodyHash + RemoteSyncHandler.this.password));
                    if (!compare.equals(rp)) {
                        log.error((Object)"Incorrect password");
                        event.response().putHeader(RemoteSyncHandler.QUARKUS_ERROR, "Incorrect password").setStatusCode(401).end();
                        return;
                    }
                    SecureRandom r = new SecureRandom();
                    byte[] sessionId = new byte[40];
                    r.nextBytes(sessionId);
                    currentSession = Base64.getEncoder().encodeToString(sessionId);
                    currentSessionCounter = 0;
                    RemoteDevState state = (RemoteDevState)new ObjectInputStream(new ByteArrayInputStream(b.getBytes())).readObject();
                    remoteProblem = state.getAugmentProblem();
                    if (state.getAugmentProblem() != null) {
                        RemoteSyncHandler.this.hotReplacementContext.setRemoteProblem(state.getAugmentProblem());
                    }
                    Set files = RemoteSyncHandler.this.hotReplacementContext.syncState(state.getFileHashes());
                    event.response().headers().set(RemoteSyncHandler.QUARKUS_SESSION, currentSession);
                    event.response().end(String.join((CharSequence)";", files));
                }
                catch (Exception e) {
                    log.error((Object)"Connect failed", (Throwable)e);
                    event.response().setStatusCode(500).end();
                }
            }
        }).exceptionHandler((Handler)new Handler<Throwable>(){

            public void handle(Throwable t) {
                log.error((Object)"Connect failed", t);
                event.response().setStatusCode(500).end();
            }
        }).resume();
    }

    private void handlePut(final HttpServerRequest event) {
        event.bodyHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer buffer) {
                if (RemoteSyncHandler.this.checkSession(event, buffer.getBytes())) {
                    return;
                }
                try {
                    RemoteSyncHandler.this.hotReplacementContext.updateFile(event.path(), buffer.getBytes());
                }
                catch (Exception e) {
                    log.error((Object)"Failed to update file", (Throwable)e);
                }
                event.response().end();
            }
        }).exceptionHandler((Handler)new Handler<Throwable>(){

            public void handle(Throwable error) {
                log.error((Object)"Failed writing live reload data", error);
                event.response().setStatusCode(500);
                event.response().end();
            }
        }).resume();
    }

    private void handleDelete(HttpServerRequest event) {
        if (this.checkSession(event, event.path().getBytes(StandardCharsets.UTF_8))) {
            return;
        }
        this.hotReplacementContext.updateFile(event.path(), null);
        event.response().end();
    }

    private boolean checkSession(HttpServerRequest event, byte[] data) {
        String ses = event.headers().get(QUARKUS_SESSION);
        String sessionCount = event.headers().get(QUARKUS_SESSION_COUNT);
        if (sessionCount == null) {
            log.error((Object)"No session count provided");
            event.response().setStatusCode(203).end();
            return true;
        }
        int sc = Integer.parseInt(sessionCount);
        if (!Objects.equals(ses, currentSession) || sc <= currentSessionCounter) {
            log.error((Object)"Invalid session");
            event.response().setStatusCode(203).end();
            return true;
        }
        currentSessionCounter = sc;
        String dataHash = "";
        if (data != null) {
            dataHash = HashUtil.sha256((byte[])data);
        }
        String rp = event.headers().get(QUARKUS_PASSWORD);
        String compare = HashUtil.sha256((String)(dataHash + ses + sc + this.password));
        if (!compare.equals(rp)) {
            log.error((Object)"Incorrect password");
            event.response().setStatusCode(401).end();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Class<RemoteSyncHandler> clazz = RemoteSyncHandler.class;
        synchronized (RemoteSyncHandler.class) {
            RemoteSyncHandler.class.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

