/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.api.BasicCache;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.models.sessions.infinispan.InfinispanKeycloakTransaction;
import org.keycloak.models.sessions.infinispan.entities.SingleUseObjectValueEntity;

public class InfinispanSingleUseObjectProvider
implements SingleUseObjectProvider {
    public static final Logger logger = Logger.getLogger(InfinispanSingleUseObjectProvider.class);
    private final Supplier<BasicCache<String, SingleUseObjectValueEntity>> singleUseObjectCache;
    private final KeycloakSession session;
    private final InfinispanKeycloakTransaction tx;

    public InfinispanSingleUseObjectProvider(KeycloakSession session, Supplier<BasicCache<String, SingleUseObjectValueEntity>> singleUseObjectCache) {
        this.session = session;
        this.singleUseObjectCache = singleUseObjectCache;
        this.tx = new InfinispanKeycloakTransaction();
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.tx);
    }

    public void put(String key, long lifespanSeconds, Map<String, String> notes) {
        SingleUseObjectValueEntity tokenValue = new SingleUseObjectValueEntity(notes);
        try {
            BasicCache<String, SingleUseObjectValueEntity> cache = this.singleUseObjectCache.get();
            this.tx.put(cache, key, tokenValue, InfinispanUtil.toHotrodTimeMs(cache, Time.toMillis((long)lifespanSeconds)), TimeUnit.MILLISECONDS);
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when adding code %s", (Object)key);
            }
            throw re;
        }
    }

    public Map<String, String> get(String key) {
        BasicCache<String, SingleUseObjectValueEntity> cache = this.singleUseObjectCache.get();
        SingleUseObjectValueEntity singleUseObjectValueEntity = this.tx.get(cache, key);
        return singleUseObjectValueEntity != null ? singleUseObjectValueEntity.getNotes() : null;
    }

    public Map<String, String> remove(String key) {
        try {
            BasicCache<String, SingleUseObjectValueEntity> cache = this.singleUseObjectCache.get();
            SingleUseObjectValueEntity singleUseObjectValueEntity = this.tx.get(cache, key);
            if (singleUseObjectValueEntity != null) {
                this.tx.remove(cache, key);
                return singleUseObjectValueEntity.getNotes();
            }
            return null;
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when removing code %s", (Object)key);
            }
            return null;
        }
    }

    public boolean replace(String key, Map<String, String> notes) {
        BasicCache<String, SingleUseObjectValueEntity> cache = this.singleUseObjectCache.get();
        return cache.replace((Object)key, (Object)new SingleUseObjectValueEntity(notes)) != null;
    }

    public boolean putIfAbsent(String key, long lifespanInSeconds) {
        SingleUseObjectValueEntity tokenValue = new SingleUseObjectValueEntity(null);
        BasicCache<String, SingleUseObjectValueEntity> cache = this.singleUseObjectCache.get();
        try {
            long lifespanMs = InfinispanUtil.toHotrodTimeMs(cache, Time.toMillis((long)lifespanInSeconds));
            SingleUseObjectValueEntity existing = (SingleUseObjectValueEntity)cache.putIfAbsent((Object)key, (Object)tokenValue, lifespanMs, TimeUnit.MILLISECONDS);
            return existing == null;
        }
        catch (HotRodClientException re) {
            logger.debugf((Throwable)re, "Failed when adding token %s", (Object)key);
            return false;
        }
    }

    public boolean contains(String key) {
        BasicCache<String, SingleUseObjectValueEntity> cache = this.singleUseObjectCache.get();
        return cache.containsKey((Object)key);
    }

    public void close() {
    }
}

