/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient;

import com.openshift.internal.restclient.KubernetesVersion;

public class OpenShiftMajorVersion {
    private KubernetesVersion openshiftVersion;
    private KubernetesVersion kubernetesVersion;

    public OpenShiftMajorVersion(String openshiftAPIVersion, String kubernetesMasterVersion) {
        this.openshiftVersion = new KubernetesVersion(openshiftAPIVersion);
        this.kubernetesVersion = new KubernetesVersion(kubernetesMasterVersion);
    }

    public boolean isDetected() {
        return this.openshiftVersion.isDetected() || this.kubernetesVersion.isDetected();
    }

    public int get() {
        if (this.openshiftVersion.isDetected()) {
            return this.openshiftVersion.getMajor();
        }
        if (!this.kubernetesVersion.isDetected()) {
            return -1;
        }
        return this.mapKubernetesToOpenShift(this.kubernetesVersion);
    }

    private int mapKubernetesToOpenShift(KubernetesVersion kubernetesVersion) {
        if (kubernetesVersion.getMajor() < 1) {
            return 3;
        }
        if (kubernetesVersion.getMajor() == 1 && kubernetesVersion.getMinor() <= 11) {
            return 3;
        }
        return 4;
    }
}

