/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.restclient;

import com.openshift.restclient.model.IResource;
import java.util.Collection;

public interface IApiTypeMapper {
    public static final String KUBE_API = "api";
    public static final String OS_API = "oapi";
    public static final String API_GROUPS_API = "apis";
    public static final String FWD_SLASH = "/";
    public static final char DOT = '.';

    public String getPreferedVersionFor(String var1);

    public IVersionedApiResource getEndpointFor(String var1, String var2);

    public boolean isSupported(IResource var1);

    public boolean isSupported(String var1);

    public boolean isSupported(String var1, String var2);

    public IVersionedType getType(String var1, String var2);

    public static interface IVersionedType {
        public String getPrefix();

        public String getApiGroupName();

        public String getVersion();

        default public String getApiGroupNameAndVersion() {
            if (this.getApiGroupName() != null) {
                return this.getApiGroupName() + IApiTypeMapper.FWD_SLASH + this.getVersion();
            }
            return this.getVersion();
        }

        public String getKind();
    }

    public static interface IVersionedApiResource {
        public String getPrefix();

        public String getApiGroupName();

        public String getVersion();

        public String getName();

        public String getKind();

        public boolean isNamespaced();

        public boolean isSupported(String var1);
    }

    public static interface IApiGroup {
        public String getPrefix();

        public String getName();

        public Collection<String> getVersions();

        public String getPreferedVersion();

        public String pathFor(String var1);
    }
}

