/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleCheckAdapter;
import org.jboss.byteman.agent.adapter.RuleCheckMethodAdapter;
import org.jboss.byteman.objectweb.asm.ClassVisitor;
import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.MethodVisitor;

public class LineCheckAdapter
extends RuleCheckAdapter {
    private int targetLine;
    private boolean visitedLine;

    public LineCheckAdapter(ClassVisitor cv, TransformContext transformContext, int targetLine) {
        super(cv, transformContext);
        this.targetLine = targetLine;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.matchTargetMethod(access, name, desc)) {
            this.setVisited();
            return new LineCheckMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class LineCheckMethodAdapter
    extends RuleCheckMethodAdapter {
        private int access;
        private String name;
        private String descriptor;
        private String signature;
        private String[] exceptions;

        LineCheckMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor);
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.exceptions = exceptions;
            LineCheckAdapter.this.visitedLine = false;
        }

        @Override
        public void visitLineNumber(int line, Label start) {
            if (!LineCheckAdapter.this.visitedLine && LineCheckAdapter.this.targetLine <= line) {
                LineCheckAdapter.this.visitedLine = true;
                this.setTriggerPoint();
            }
            super.visitLineNumber(line, start);
        }
    }
}

