/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.credential;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SubjectCredentialManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.map.user.MapUserCredentialEntity;
import org.keycloak.models.map.user.MapUserEntity;

public class MapUserCredentialManager
implements SubjectCredentialManager {
    private final UserModel user;
    private final KeycloakSession session;
    private final RealmModel realm;
    private final MapUserEntity entity;

    public MapUserCredentialManager(KeycloakSession session, RealmModel realm, UserModel user, MapUserEntity entity) {
        this.user = user;
        this.session = session;
        this.realm = realm;
        this.entity = entity;
    }

    public boolean isValid(List<CredentialInput> inputs) {
        if (!this.isValid(this.user)) {
            return false;
        }
        LinkedList<CredentialInput> toValidate = new LinkedList<CredentialInput>(inputs);
        this.entity.credentialManager().validateCredentials(toValidate);
        MapUserCredentialManager.getCredentialProviders(this.session, CredentialInputValidator.class).forEach(validator -> this.validate(this.realm, this.user, (List<CredentialInput>)toValidate, (CredentialInputValidator)validator));
        return toValidate.isEmpty();
    }

    public boolean updateCredential(CredentialInput input) {
        return this.entity.credentialManager().updateCredential(input) || MapUserCredentialManager.getCredentialProviders(this.session, CredentialInputUpdater.class).filter(updater -> updater.supportsCredentialType(input.getType())).anyMatch(updater -> updater.updateCredential(this.realm, this.user, input));
    }

    public void updateStoredCredential(CredentialModel cred) {
        this.throwExceptionIfInvalidUser(this.user);
        this.entity.getCredential(cred.getId()).ifPresent(c -> {
            c.setCreatedDate(cred.getCreatedDate());
            c.setUserLabel(cred.getUserLabel());
            c.setType(cred.getType());
            c.setSecretData(cred.getSecretData());
            c.setCredentialData(cred.getCredentialData());
        });
    }

    public CredentialModel createStoredCredential(CredentialModel cred) {
        this.throwExceptionIfInvalidUser(this.user);
        MapUserCredentialEntity credentialEntity = MapUserCredentialEntity.fromModel(cred);
        if (this.entity.getCredential(cred.getId()).isPresent()) {
            throw new ModelDuplicateException("A CredentialModel with given id already exists");
        }
        this.entity.addCredential(credentialEntity);
        return MapUserCredentialEntity.toModel(credentialEntity);
    }

    public boolean removeStoredCredentialById(String id) {
        this.throwExceptionIfInvalidUser(this.user);
        return this.entity.removeCredential(id);
    }

    public CredentialModel getStoredCredentialById(String id) {
        return this.entity.getCredential(id).map(MapUserCredentialEntity::toModel).orElse(null);
    }

    public Stream<CredentialModel> getStoredCredentialsStream() {
        return Optional.ofNullable(this.entity.getCredentials()).orElse(Collections.emptyList()).stream().map(MapUserCredentialEntity::toModel);
    }

    public Stream<CredentialModel> getStoredCredentialsByTypeStream(String type) {
        return this.getStoredCredentialsStream().filter(credential -> Objects.equals(type, credential.getType()));
    }

    public CredentialModel getStoredCredentialByNameAndType(String name, String type) {
        return this.getStoredCredentialsStream().filter(credential -> Objects.equals(name, credential.getUserLabel())).findFirst().orElse(null);
    }

    public boolean moveStoredCredentialTo(String id, String newPreviousCredentialId) {
        this.throwExceptionIfInvalidUser(this.user);
        return this.entity.moveCredential(id, newPreviousCredentialId);
    }

    public void updateCredentialLabel(String credentialId, String userLabel) {
        this.throwExceptionIfInvalidUser(this.user);
        CredentialModel credential = this.getStoredCredentialById(credentialId);
        credential.setUserLabel(userLabel);
        this.updateStoredCredential(credential);
    }

    public void disableCredentialType(String credentialType) {
        MapUserCredentialManager.getCredentialProviders(this.session, CredentialInputUpdater.class).filter(updater -> updater.supportsCredentialType(credentialType)).forEach(updater -> updater.disableCredentialType(this.realm, this.user, credentialType));
    }

    public Stream<String> getDisableableCredentialTypesStream() {
        return Stream.concat(this.entity.credentialManager().getDisableableCredentialTypesStream(), MapUserCredentialManager.getCredentialProviders(this.session, CredentialInputUpdater.class).flatMap(updater -> updater.getDisableableCredentialTypesStream(this.realm, this.user))).distinct();
    }

    public boolean isConfiguredFor(String type) {
        return this.entity.credentialManager().isConfiguredFor(type) || MapUserCredentialManager.getCredentialProviders(this.session, CredentialInputValidator.class).anyMatch(validator -> validator.supportsCredentialType(type) && validator.isConfiguredFor(this.realm, this.user, type));
    }

    @Deprecated
    public boolean isConfiguredLocally(String type) {
        throw new IllegalArgumentException("this is not supported for map storage");
    }

    @Deprecated
    public Stream<String> getConfiguredUserStorageCredentialTypesStream() {
        return Stream.empty();
    }

    @Deprecated
    public CredentialModel createCredentialThroughProvider(CredentialModel model) {
        this.throwExceptionIfInvalidUser(this.user);
        return this.session.getKeycloakSessionFactory().getProviderFactoriesStream(CredentialProvider.class).map(f -> (CredentialProvider)this.session.getProvider(CredentialProvider.class, f.getId())).filter(provider -> Objects.equals(provider.getType(), model.getType())).map(cp -> cp.createCredential(this.realm, this.user, cp.getCredentialFromModel(model))).findFirst().orElse(null);
    }

    private boolean isValid(UserModel user) {
        Objects.requireNonNull(user);
        return user.getServiceAccountClientLink() == null;
    }

    private void validate(RealmModel realm, UserModel user, List<CredentialInput> toValidate, CredentialInputValidator validator) {
        toValidate.removeIf(input -> validator.supportsCredentialType(input.getType()) && validator.isValid(realm, user, input));
    }

    private static <T> Stream<T> getCredentialProviders(KeycloakSession session, Class<T> type) {
        return session.getKeycloakSessionFactory().getProviderFactoriesStream(CredentialProvider.class).filter(f -> Types.supports((Class)type, (Object)f, CredentialProviderFactory.class)).map(f -> session.getProvider(CredentialProvider.class, f.getId()));
    }

    private void throwExceptionIfInvalidUser(UserModel user) {
        if (!this.isValid(user)) {
            throw new RuntimeException("You can not manage credentials for this user");
        }
    }
}

