/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import biz.paluch.logging.gelf.intern.Closer;
import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.GelfSender;
import biz.paluch.logging.gelf.intern.sender.AbstractNioSender;
import biz.paluch.logging.gelf.intern.sender.BackOff;
import biz.paluch.logging.gelf.intern.sender.BackOffExecution;
import biz.paluch.logging.gelf.intern.sender.BoundedBackOff;
import biz.paluch.logging.gelf.intern.sender.ConstantBackOff;
import biz.paluch.logging.gelf.intern.sender.GelfBuffers;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;

public class GelfTCPSender
extends AbstractNioSender<SocketChannel>
implements GelfSender {
    public static final String CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String READ_TIMEOUT = "readTimeout";
    public static final String RETRIES = "deliveryAttempts";
    public static final String KEEPALIVE = "keepAlive";
    public static final String WRITE_BACKOFF_TIME = "writeBackoffTime";
    public static final String WRITE_BACKOFF_THRESHOLD = "writeBackoffThreshold";
    public static final String MAX_WRITE_BACKOFF_TIME = "maxWriteBackoffTime";
    private final int readTimeoutMs;
    private final int connectTimeoutMs;
    private final boolean keepAlive;
    private final int deliveryAttempts;
    private final int writeBackoffThreshold;
    private final BackOff backoff;
    private final Object ioLock = new Object();
    private final ThreadLocal<ByteBuffer> writeBuffers = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocateDirect(AbstractNioSender.INITIAL_BUFFER_SIZE);
        }
    };

    public GelfTCPSender(String host, int port, int connectTimeoutMs, int readTimeoutMs, ErrorReporter errorReporter) throws IOException {
        this(host, port, connectTimeoutMs, readTimeoutMs, 1, false, errorReporter);
    }

    public GelfTCPSender(String host, int port, int connectTimeoutMs, int readTimeoutMs, int deliveryAttempts, boolean keepAlive, ErrorReporter errorReporter) throws IOException {
        this(host, port, connectTimeoutMs, readTimeoutMs, deliveryAttempts, keepAlive, new BoundedBackOff(new ConstantBackOff(50L, TimeUnit.MILLISECONDS), connectTimeoutMs, TimeUnit.MILLISECONDS), 10, errorReporter);
    }

    public GelfTCPSender(String host, int port, int connectTimeoutMs, int readTimeoutMs, int deliveryAttempts, boolean keepAlive, BackOff backoff, int writeBackoffThreshold, ErrorReporter errorReporter) throws IOException {
        super(errorReporter, host, port);
        this.connectTimeoutMs = connectTimeoutMs;
        this.readTimeoutMs = readTimeoutMs;
        this.keepAlive = keepAlive;
        this.deliveryAttempts = deliveryAttempts < 1 ? Integer.MAX_VALUE : deliveryAttempts;
        this.backoff = backoff;
        this.writeBackoffThreshold = writeBackoffThreshold;
        this.setChannel(this.createSocketChannel(readTimeoutMs, keepAlive));
    }

    protected SocketChannel createSocketChannel(int readTimeoutMs, boolean keepAlive) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        socketChannel.socket().setKeepAlive(keepAlive);
        socketChannel.socket().setSoTimeout(readTimeoutMs);
        return socketChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(GelfMessage message) {
        if (this.isShutdown()) {
            return false;
        }
        Throwable exception = null;
        for (int i = 0; i < this.deliveryAttempts; ++i) {
            try {
                if (!this.isConnected()) {
                    Object object = this.ioLock;
                    synchronized (object) {
                        this.connect();
                    }
                }
                ByteBuffer buffer = INITIAL_BUFFER_SIZE == 0 ? message.toTCPBuffer() : GelfBuffers.toTCPBuffer(message, this.writeBuffers);
                try {
                    Object object = this.ioLock;
                    synchronized (object) {
                        this.write(buffer);
                    }
                }
                catch (InterruptedException e) {
                    this.reportError(e.getMessage(), new IOException("Cannot send data to " + this.getHost() + ":" + this.getPort(), e));
                    Thread.currentThread().interrupt();
                    return false;
                }
                return true;
            }
            catch (IOException e) {
                Closer.close(this.channel());
                exception = e;
                continue;
            }
        }
        if (exception != null) {
            this.reportError(exception.getMessage(), new IOException("Cannot send data to " + this.getHost() + ":" + this.getPort(), exception));
        }
        return false;
    }

    protected void write(ByteBuffer buffer) throws IOException, InterruptedException {
        int nothingWrittenTimesInRow = 0;
        BackOffExecution backoffExecution = null;
        while (buffer.hasRemaining()) {
            int written = ((SocketChannel)this.channel()).write(buffer);
            if (written < 0 || !this.isConnected()) {
                Closer.close(this.channel());
                throw new SocketException("Cannot write buffer to channel");
            }
            if (written == 0) {
                if (backoffExecution == null) {
                    backoffExecution = this.backoff.start();
                }
                if (++nothingWrittenTimesInRow <= this.writeBackoffThreshold) continue;
                long toSleep = backoffExecution.nextBackOff();
                if (toSleep == -1L) {
                    Closer.close(this.channel());
                    throw new SocketException("Cannot write buffer to channel, no progress in writing");
                }
                Thread.sleep(toSleep);
                continue;
            }
            nothingWrittenTimesInRow = 0;
        }
    }

    protected boolean connect() throws IOException {
        if (this.isConnected()) {
            return false;
        }
        Closer.close(this.channel());
        this.setChannel(this.createSocketChannel(this.readTimeoutMs, this.keepAlive));
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.getHost(), this.getPort());
        if (((SocketChannel)this.channel()).connect(inetSocketAddress)) {
            return true;
        }
        long connectTimeoutLeft = TimeUnit.MILLISECONDS.toNanos(this.connectTimeoutMs);
        long waitTimeoutMs = 10L;
        long waitTimeoutNs = TimeUnit.MILLISECONDS.toNanos(waitTimeoutMs);
        try {
            boolean connected;
            while (!(connected = ((SocketChannel)this.channel()).finishConnect())) {
                Thread.sleep(waitTimeoutMs);
                if ((connectTimeoutLeft -= waitTimeoutNs) > 0L) continue;
            }
            if (!connected) {
                throw new ConnectException("Connection timed out. Cannot connect to " + inetSocketAddress + " within " + TimeUnit.NANOSECONDS.toMillis(connectTimeoutLeft) + "ms");
            }
            return connected;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Connection interrupted", e);
        }
    }

    @Override
    protected boolean isConnected(SocketChannel channel) {
        return channel.isConnected();
    }
}

