/*
 * Decompiled with CFR 0.152.
 */
package lucee.loader.util;

import java.io.File;
import java.io.FileFilter;

public final class ExtensionFilter
implements FileFilter {
    private final String[] extensions;
    private final boolean allowDir;
    private final boolean ignoreCase;

    public ExtensionFilter(String extension) {
        this(new String[]{extension}, false, true);
    }

    public ExtensionFilter(String extension, boolean allowDir) {
        this(new String[]{extension}, allowDir, true);
    }

    public ExtensionFilter(String[] extensions) {
        this(extensions, false, true);
    }

    public ExtensionFilter(String[] extensions, boolean allowDir) {
        this(extensions, allowDir, true);
    }

    public ExtensionFilter(String[] extensions, boolean allowDir, boolean ignoreCase) {
        for (int i = 0; i < extensions.length; ++i) {
            if (!extensions[i].startsWith(".")) {
                extensions[i] = "." + extensions[i];
            }
            if (!ignoreCase) continue;
            extensions[i] = extensions[i].toLowerCase();
        }
        this.extensions = extensions;
        this.allowDir = allowDir;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public boolean accept(File res) {
        if (res.isDirectory()) {
            return this.allowDir;
        }
        if (res.exists()) {
            String name = this.ignoreCase ? res.getName().toLowerCase() : res.getName();
            for (String extension : this.extensions) {
                if (!name.endsWith(extension)) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getExtensions() {
        return this.extensions;
    }
}

