'use strict';

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MetricsAggregationBase = require('./metrics-aggregation-base');

/**
 * A single-value metrics aggregation that keeps track and returns the
 * maximum value among the numeric values extracted from the aggregated
 * documents. These values can be extracted either from specific numeric fields
 * in the documents, or be generated by a provided script.
 *
 * [Elasticsearch reference](https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-metrics-max-aggregation.html)
 *
 * Aggregation that keeps track and returns the maximum value among the
 * numeric values extracted from the aggregated documents.
 *
 * @example
 * const agg = esb.maxAggregation('max_price', 'price');
 *
 * @example
 * // Use a file script
 * const agg = esb.maxAggregation('max_price').script(
 *     esb.script('file', 'my_script').params({ field: 'price' })
 * );
 *
 * @example
 * // Value script to apply the conversion rate to every value
 * // before it is aggregated
 * const agg = esb.maxAggregation('max_price').script(
 *     esb.script('inline', '_value * params.conversion_rate').params({
 *         conversion_rate: 1.2
 *     })
 * );
 *
 * @param {string} name The name which will be used to refer to this aggregation.
 * @param {string=} field The field to aggregate on
 *
 * @extends MetricsAggregationBase
 */

var MaxAggregation = function (_MetricsAggregationBa) {
    (0, _inherits3.default)(MaxAggregation, _MetricsAggregationBa);

    // eslint-disable-next-line require-jsdoc
    function MaxAggregation(name, field) {
        (0, _classCallCheck3.default)(this, MaxAggregation);
        return (0, _possibleConstructorReturn3.default)(this, (MaxAggregation.__proto__ || Object.getPrototypeOf(MaxAggregation)).call(this, name, 'max', field));
    }

    return MaxAggregation;
}(MetricsAggregationBase);

module.exports = MaxAggregation;