/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * notEqual(ivec3(-5, -5, -5), ivec3(-5, -2, -1)) => bvec3(false, true, true)
 * notEqual(ivec3(-5, -5, -5), ivec3(0, 1, 2)) => bvec3(true, true, true)
 * notEqual(ivec3(-5, -2, -2), ivec3(5, -5, -2)) => bvec3(true, true, false)
 * notEqual(ivec3(-2, -2, -2), ivec3(-1, 0, 1)) => bvec3(true, true, true)
 * notEqual(ivec3(-2, -2, -1), ivec3(2, 5, -5)) => bvec3(true, true, true)
 * notEqual(ivec3(-1, -1, -1), ivec3(-2, -1, 0)) => bvec3(true, false, true)
 * notEqual(ivec3(-1, -1, -1), ivec3(1, 2, 5)) => bvec3(true, true, true)
 * notEqual(ivec3(0, 0, 0), ivec3(-5, -2, -1)) => bvec3(true, true, true)
 * notEqual(ivec3(0, 0, 0), ivec3(0, 1, 2)) => bvec3(false, true, true)
 * notEqual(ivec3(0, 1, 1), ivec3(5, -5, -2)) => bvec3(true, true, true)
 * notEqual(ivec3(1, 1, 1), ivec3(-1, 0, 1)) => bvec3(true, true, false)
 * notEqual(ivec3(1, 1, 2), ivec3(2, 5, -5)) => bvec3(true, true, true)
 * notEqual(ivec3(2, 2, 2), ivec3(-2, -1, 0)) => bvec3(true, true, true)
 * notEqual(ivec3(2, 2, 2), ivec3(1, 2, 5)) => bvec3(true, false, true)
 * notEqual(ivec3(5, 5, 5), ivec3(-5, -2, -1)) => bvec3(true, true, true)
 * notEqual(ivec3(5, 5, 5), ivec3(0, 1, 2)) => bvec3(true, true, true)
 * notEqual(ivec3(5, -5, -5), ivec3(5, -5, -2)) => bvec3(false, false, true)
 */
#version 120

void main()
{
  float[all(equal(notEqual(ivec3(-5, -5, -5), ivec3(-5, -2, -1)), bvec3(false, true, true))) ? 1 : -1] array0;
  float[all(equal(notEqual(ivec3(-5, -5, -5), ivec3(0, 1, 2)), bvec3(true, true, true))) ? 1 : -1] array1;
  float[all(equal(notEqual(ivec3(-5, -2, -2), ivec3(5, -5, -2)), bvec3(true, true, false))) ? 1 : -1] array2;
  float[all(equal(notEqual(ivec3(-2, -2, -2), ivec3(-1, 0, 1)), bvec3(true, true, true))) ? 1 : -1] array3;
  float[all(equal(notEqual(ivec3(-2, -2, -1), ivec3(2, 5, -5)), bvec3(true, true, true))) ? 1 : -1] array4;
  float[all(equal(notEqual(ivec3(-1, -1, -1), ivec3(-2, -1, 0)), bvec3(true, false, true))) ? 1 : -1] array5;
  float[all(equal(notEqual(ivec3(-1, -1, -1), ivec3(1, 2, 5)), bvec3(true, true, true))) ? 1 : -1] array6;
  float[all(equal(notEqual(ivec3(0, 0, 0), ivec3(-5, -2, -1)), bvec3(true, true, true))) ? 1 : -1] array7;
  float[all(equal(notEqual(ivec3(0, 0, 0), ivec3(0, 1, 2)), bvec3(false, true, true))) ? 1 : -1] array8;
  float[all(equal(notEqual(ivec3(0, 1, 1), ivec3(5, -5, -2)), bvec3(true, true, true))) ? 1 : -1] array9;
  float[all(equal(notEqual(ivec3(1, 1, 1), ivec3(-1, 0, 1)), bvec3(true, true, false))) ? 1 : -1] array10;
  float[all(equal(notEqual(ivec3(1, 1, 2), ivec3(2, 5, -5)), bvec3(true, true, true))) ? 1 : -1] array11;
  float[all(equal(notEqual(ivec3(2, 2, 2), ivec3(-2, -1, 0)), bvec3(true, true, true))) ? 1 : -1] array12;
  float[all(equal(notEqual(ivec3(2, 2, 2), ivec3(1, 2, 5)), bvec3(true, false, true))) ? 1 : -1] array13;
  float[all(equal(notEqual(ivec3(5, 5, 5), ivec3(-5, -2, -1)), bvec3(true, true, true))) ? 1 : -1] array14;
  float[all(equal(notEqual(ivec3(5, 5, 5), ivec3(0, 1, 2)), bvec3(true, true, true))) ? 1 : -1] array15;
  float[all(equal(notEqual(ivec3(5, -5, -5), ivec3(5, -5, -2)), bvec3(false, false, true))) ? 1 : -1] array16;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length());
}
