/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords;

import java.util.Map;
import org.apache.hadoop.shaded.com.google.gson.JsonObject;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesRequest;
import org.apache.hadoop.yarn.util.Records;

public abstract class NodePublishVolumeRequest {
    public static NodePublishVolumeRequest newInstance(String volumeId, boolean readOnly, String targetPath, String stagingPath, ValidateVolumeCapabilitiesRequest.VolumeCapability capability, Map<String, String> publishContext, Map<String, String> secrets) {
        NodePublishVolumeRequest request = Records.newRecord(NodePublishVolumeRequest.class);
        request.setVolumeId(volumeId);
        request.setReadonly(readOnly);
        request.setTargetPath(targetPath);
        request.setStagingPath(stagingPath);
        request.setVolumeCapability(capability);
        request.setPublishContext(publishContext);
        request.setSecrets(secrets);
        return request;
    }

    public abstract void setVolumeId(String var1);

    public abstract String getVolumeId();

    public abstract void setReadonly(boolean var1);

    public abstract boolean getReadOnly();

    public abstract void setTargetPath(String var1);

    public abstract String getTargetPath();

    public abstract void setStagingPath(String var1);

    public abstract String getStagingPath();

    public abstract void setVolumeCapability(ValidateVolumeCapabilitiesRequest.VolumeCapability var1);

    public abstract ValidateVolumeCapabilitiesRequest.VolumeCapability getVolumeCapability();

    public abstract void setPublishContext(Map<String, String> var1);

    public abstract Map<String, String> getPublishContext();

    public abstract void setSecrets(Map<String, String> var1);

    public abstract Map<String, String> getSecrets();

    public String toString() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("VolumeId", this.getVolumeId());
        jsonObject.addProperty("ReadOnly", Boolean.valueOf(this.getReadOnly()));
        jsonObject.addProperty("TargetPath", this.getTargetPath());
        jsonObject.addProperty("StagingPath", this.getStagingPath());
        if (this.getVolumeCapability() != null) {
            JsonObject jsonCap = new JsonObject();
            jsonCap.addProperty("AccessMode", this.getVolumeCapability().getAccessMode().name());
            jsonCap.addProperty("VolumeType", this.getVolumeCapability().getVolumeType().name());
            jsonObject.addProperty("VolumeCapability", jsonCap.toString());
        }
        return jsonObject.toString();
    }
}

