/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.exporter;

import java.util.Optional;

public class SolrScrapeConfiguration {
    private final ConnectionType type;
    private final String zookeeperConnectionString;
    private final String solrHost;

    private SolrScrapeConfiguration(ConnectionType type, String zookeeperConnectionString, String solrHost) {
        this.type = type;
        this.zookeeperConnectionString = zookeeperConnectionString;
        this.solrHost = solrHost;
    }

    public ConnectionType getType() {
        return this.type;
    }

    public Optional<String> getZookeeperConnectionString() {
        return Optional.ofNullable(this.zookeeperConnectionString);
    }

    public Optional<String> getSolrHost() {
        return Optional.ofNullable(this.solrHost);
    }

    public static SolrScrapeConfiguration solrCloud(String zookeeperConnectionString) {
        return new SolrScrapeConfiguration(ConnectionType.CLOUD, zookeeperConnectionString, null);
    }

    public static SolrScrapeConfiguration standalone(String solrHost) {
        return new SolrScrapeConfiguration(ConnectionType.STANDALONE, null, solrHost);
    }

    public String toString() {
        if (this.type == ConnectionType.CLOUD) {
            return "Solr Cloud ZK: " + this.zookeeperConnectionString;
        }
        if (this.type == ConnectionType.STANDALONE) {
            return "Solr Node: " + this.solrHost;
        }
        return "None";
    }

    public static enum ConnectionType {
        CLOUD,
        STANDALONE;

    }
}

