/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.request.beans.CreateConfigPayload;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.common.params.DefaultSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.configsets.CreateConfigSetAPI;
import org.apache.solr.handler.configsets.DeleteConfigSetAPI;
import org.apache.solr.handler.configsets.ListConfigSetsAPI;
import org.apache.solr.handler.configsets.UploadConfigSetAPI;
import org.apache.solr.handler.configsets.UploadConfigSetFileAPI;
import org.apache.solr.request.DelegatingSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSetsHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    public static final Boolean DISABLE_CREATE_AUTH_CHECKS = Boolean.getBoolean("solr.disableConfigSetsCreateAuthChecks");
    public static final String DEFAULT_CONFIGSET_NAME = "_default";
    public static final String AUTOCREATED_CONFIGSET_SUFFIX = ".AUTOCREATED";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final CoreContainer coreContainer;
    public static long CONFIG_SET_TIMEOUT = 300000L;

    public ConfigSetsHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    public static String getSuffixedNameForAutoGeneratedConfigSet(String configName) {
        return configName + AUTOCREATED_CONFIGSET_SUFFIX;
    }

    public static boolean isAutoGeneratedConfigSet(String configName) {
        return configName != null && configName.endsWith(AUTOCREATED_CONFIGSET_SUFFIX);
    }

    @Override
    public void handleRequestBody(final SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        this.checkErrors();
        RequiredSolrParams requiredSolrParams = req.getParams().required();
        String actionStr = requiredSolrParams.get("action");
        ConfigSetParams.ConfigSetAction action = ConfigSetParams.ConfigSetAction.get((String)actionStr);
        if (action == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + actionStr);
        }
        switch (action) {
            case DELETE: {
                DeleteConfigSetAPI deleteConfigSetAPI = new DeleteConfigSetAPI(this.coreContainer);
                DelegatingSolrQueryRequest v2DeleteReq = new DelegatingSolrQueryRequest(req){

                    @Override
                    public Map<String, String> getPathTemplateValues() {
                        return Map.of("name", req.getParams().required().get("name"));
                    }
                };
                deleteConfigSetAPI.deleteConfigSet(v2DeleteReq, rsp);
                break;
            }
            case UPLOAD: {
                DelegatingSolrQueryRequest v2UploadReq = new DelegatingSolrQueryRequest(req){

                    @Override
                    public Map<String, String> getPathTemplateValues() {
                        HashMap templateValsByName = Maps.newHashMap();
                        templateValsByName.put("name", req.getParams().required().get("name"));
                        if (!req.getParams().get("filePath", "").isEmpty()) {
                            templateValsByName.put("*", req.getParams().get("filePath"));
                        }
                        return templateValsByName;
                    }

                    @Override
                    public SolrParams getParams() {
                        ModifiableSolrParams v1Defaults = new ModifiableSolrParams();
                        v1Defaults.add("overwrite", new String[]{"false"});
                        v1Defaults.add("cleanup", new String[]{"false"});
                        return new DefaultSolrParams(super.getParams(), (SolrParams)v1Defaults);
                    }
                };
                if (req.getParams().get("filePath", "").isEmpty()) {
                    new UploadConfigSetAPI(this.coreContainer).uploadConfigSet(v2UploadReq, rsp);
                    break;
                }
                new UploadConfigSetFileAPI(this.coreContainer).updateConfigSetFile(v2UploadReq, rsp);
                break;
            }
            case LIST: {
                new ListConfigSetsAPI(this.coreContainer).listConfigSet(req, rsp);
                break;
            }
            case CREATE: {
                String newConfigSetName = req.getParams().get("name");
                if (newConfigSetName == null || newConfigSetName.length() == 0) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet name not specified");
                }
                CreateConfigPayload createPayload = new CreateConfigPayload();
                createPayload.name = newConfigSetName;
                if (req.getParams().get("baseConfigSet") != null) {
                    createPayload.baseConfigSet = req.getParams().get("baseConfigSet");
                }
                createPayload.properties = new HashMap();
                req.getParams().stream().filter(entry -> ((String)entry.getKey()).startsWith("configSetProp.")).forEach(entry -> {
                    String newKey = ((String)entry.getKey()).substring("configSetProp.".length());
                    Object value = ((String[])entry.getValue()).length == 1 ? ((String[])entry.getValue())[0] : entry.getValue();
                    createPayload.properties.put(newKey, value);
                });
                CreateConfigSetAPI createConfigSetAPI = new CreateConfigSetAPI(this.coreContainer);
                createConfigSetAPI.create(new PayloadObj<CreateConfigPayload>("create", null, createPayload, req, rsp));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected ConfigSetAction detected: " + action);
            }
        }
        rsp.setHttpCaching(false);
    }

    protected void checkErrors() {
        if (this.coreContainer == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        if (!this.coreContainer.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr instance is not running in SolrCloud mode.");
        }
    }

    @Override
    public String getDescription() {
        return "Manage SolrCloud ConfigSets";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        String a = ctx.getParams().get("action");
        if (a != null) {
            ConfigSetParams.ConfigSetAction action = ConfigSetParams.ConfigSetAction.get((String)a);
            if (action == ConfigSetParams.ConfigSetAction.CREATE || action == ConfigSetParams.ConfigSetAction.DELETE || action == ConfigSetParams.ConfigSetAction.UPLOAD) {
                return PermissionNameProvider.Name.CONFIG_EDIT_PERM;
            }
            if (action == ConfigSetParams.ConfigSetAction.LIST) {
                return PermissionNameProvider.Name.CONFIG_READ_PERM;
            }
        }
        return null;
    }
}

