/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URL;
import java.security.spec.InvalidKeySpecException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.CryptoKeys;

public class PublicKeyHandler
extends RequestHandlerBase {
    public static final String PATH = "/admin/info/key";
    final CryptoKeys.RSAKeyPair keyPair;

    @VisibleForTesting
    public PublicKeyHandler() {
        this.keyPair = new CryptoKeys.RSAKeyPair();
    }

    public PublicKeyHandler(CloudConfig config) throws IOException, InvalidKeySpecException {
        this.keyPair = this.createKeyPair(config);
    }

    private CryptoKeys.RSAKeyPair createKeyPair(CloudConfig config) throws IOException, InvalidKeySpecException {
        if (config == null) {
            return new CryptoKeys.RSAKeyPair();
        }
        String publicKey = config.getPkiHandlerPublicKeyPath();
        String privateKey = config.getPkiHandlerPrivateKeyPath();
        if (StringUtils.isEmpty((String)publicKey) && StringUtils.isEmpty((String)privateKey)) {
            return new CryptoKeys.RSAKeyPair();
        }
        return new CryptoKeys.RSAKeyPair(new URL(privateKey), new URL(publicKey));
    }

    public String getPublicKey() {
        return this.keyPair.getPublicKeyStr();
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        rsp.add("key", this.keyPair.getPublicKeyStr());
    }

    @Override
    public String getDescription() {
        return "Return the public key of this server";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.ALL;
    }
}

