/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.solr.cluster.api.SimpleMap;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.util.PropertiesUtil;
import org.apache.solr.common.util.WrappedSimpleMap;

public class DataConfigNode
implements ConfigNode {
    public final String name;
    public final SimpleMap<String> attributes;
    public final SimpleMap<List<ConfigNode>> kids;
    public final String textData;
    public static final SimpleMap<List<ConfigNode>> EMPTY = new WrappedSimpleMap(Collections.emptyMap());

    public DataConfigNode(ConfigNode root) {
        LinkedHashMap kids = new LinkedHashMap();
        this.name = root.name();
        this.attributes = this.wrap((SimpleMap<String>)root.attributes());
        this.textData = root.txt();
        root.forEachChild(it -> {
            List nodes = kids.computeIfAbsent(it.name(), k -> new ArrayList());
            nodes.add(new DataConfigNode((ConfigNode)it));
            return Boolean.TRUE;
        });
        for (Map.Entry entry : kids.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.setValue(List.copyOf((Collection)entry.getValue()));
        }
        this.kids = kids.isEmpty() ? EMPTY : new WrappedSimpleMap(Map.copyOf(kids));
    }

    public String subtituteVal(String s) {
        return PropertiesUtil.substitute((String)s, (Function)((Function)SUBSTITUTES.get()));
    }

    private SimpleMap<String> wrap(final SimpleMap<String> delegate) {
        if (delegate.size() == 0) {
            return delegate;
        }
        return new SimpleMap<String>(){

            public String get(String key) {
                return DataConfigNode.this.subtituteVal((String)delegate.get(key));
            }

            public void forEachEntry(BiConsumer<String, ? super String> fun) {
                delegate.forEachEntry((k, v) -> fun.accept((String)k, DataConfigNode.this.subtituteVal((String)v)));
            }

            public int size() {
                return delegate.size();
            }
        };
    }

    public String name() {
        return this.name;
    }

    public String txt() {
        return this.subtituteVal(this.textData);
    }

    public SimpleMap<String> attributes() {
        return this.attributes;
    }

    public ConfigNode child(String name) {
        List val = (List)this.kids.get(name);
        return val == null || val.isEmpty() ? null : (ConfigNode)val.get(0);
    }

    public List<ConfigNode> getAll(String name) {
        return (List)this.kids.get(name, Collections.emptyList());
    }

    public List<ConfigNode> getAll(Predicate<ConfigNode> test, Set<String> matchNames) {
        ArrayList<ConfigNode> result = new ArrayList<ConfigNode>();
        for (String s : matchNames) {
            List vals = (List)this.kids.get(s);
            if (vals == null) continue;
            vals.forEach(it -> {
                if (test == null || test.test((ConfigNode)it)) {
                    result.add((ConfigNode)it);
                }
            });
        }
        return result;
    }

    public void forEachChild(Function<ConfigNode, Boolean> fun) {
        this.kids.forEachEntry((s, configNodes) -> {
            if (configNodes != null) {
                configNodes.forEach(fun::apply);
            }
        });
    }
}

