/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.fop.render.afp.modca.AbstractAFPObject;
import org.apache.fop.render.afp.modca.ImageContent;

public class ImageSegment
extends AbstractAFPObject {
    private static final String DEFAULT_NAME = "IS01";
    private String _name;
    private byte[] _nameBytes;
    private ImageContent _imageContent = null;

    public ImageSegment() {
        this(DEFAULT_NAME);
    }

    public ImageSegment(String name) {
        if (name.length() != 4) {
            String msg = "Image segment name must be 4 characters long " + name;
            log.error((Object)("Constructor:: " + msg));
            throw new IllegalArgumentException(msg);
        }
        this._name = name;
        try {
            this._nameBytes = name.getBytes("Cp1146");
        }
        catch (UnsupportedEncodingException usee) {
            this._nameBytes = name.getBytes();
            log.warn((Object)("Constructor:: UnsupportedEncodingException translating the name " + name));
        }
    }

    public void setImageSize(int hresol, int vresol, int hsize, int vsize) {
        if (this._imageContent == null) {
            this._imageContent = new ImageContent();
        }
        this._imageContent.setImageSize(hresol, vresol, hsize, vsize);
    }

    public void setImageEncoding(byte encoding) {
        if (this._imageContent == null) {
            this._imageContent = new ImageContent();
        }
        this._imageContent.setImageEncoding(encoding);
    }

    public void setImageCompression(byte compression) {
        if (this._imageContent == null) {
            this._imageContent = new ImageContent();
        }
        this._imageContent.setImageCompression(compression);
    }

    public void setImageIDESize(byte size) {
        if (this._imageContent == null) {
            this._imageContent = new ImageContent();
        }
        this._imageContent.setImageIDESize(size);
    }

    public void setImageIDEColorModel(byte colorModel) {
        if (this._imageContent == null) {
            this._imageContent = new ImageContent();
        }
        this._imageContent.setImageIDEColorModel(colorModel);
    }

    public void setImageData(byte[] data) {
        if (this._imageContent == null) {
            this._imageContent = new ImageContent();
        }
        this._imageContent.setImageData(data);
    }

    public void writeDataStream(OutputStream os) throws IOException {
        this.writeStart(os);
        if (this._imageContent != null) {
            this._imageContent.writeDataStream(os);
        }
        this.writeEnd(os);
    }

    private void writeStart(OutputStream os) throws IOException {
        byte[] data = new byte[]{112, 4, 0, 0, 0, 0};
        for (int i = 0; i < this._nameBytes.length; ++i) {
            data[2 + i] = this._nameBytes[i];
        }
        os.write(data);
    }

    private void writeEnd(OutputStream os) throws IOException {
        byte[] data = new byte[]{113, 0};
        os.write(data);
    }
}

