// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"log"
	"reflect"
	"regexp"
	"strings"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/validation"
)

func resourceDialogflowCXPage() *schema.Resource {
	return &schema.Resource{
		Create: resourceDialogflowCXPageCreate,
		Read:   resourceDialogflowCXPageRead,
		Update: resourceDialogflowCXPageUpdate,
		Delete: resourceDialogflowCXPageDelete,

		Importer: &schema.ResourceImporter{
			State: resourceDialogflowCXPageImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(40 * time.Minute),
			Update: schema.DefaultTimeout(40 * time.Minute),
			Delete: schema.DefaultTimeout(20 * time.Minute),
		},

		Schema: map[string]*schema.Schema{
			"display_name": {
				Type:         schema.TypeString,
				Required:     true,
				ValidateFunc: validation.StringLenBetween(0, 64),
				Description:  `The human-readable name of the page, unique within the agent.`,
			},
			"entry_fulfillment": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `The fulfillment to call when the session is entering the page.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"messages": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `The list of rich message responses to present to the user.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"text": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `The text response message.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"text": {
													Type:        schema.TypeList,
													Optional:    true,
													Description: `A collection of text responses.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
												},
												"allow_playback_interruption": {
													Type:        schema.TypeBool,
													Computed:    true,
													Description: `Whether the playback of this message can be interrupted by the end user's speech and the client can then starts the next Dialogflow request.`,
												},
											},
										},
									},
								},
							},
						},
						"return_partial_responses": {
							Type:        schema.TypeBool,
							Optional:    true,
							Description: `Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.`,
						},
						"tag": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.`,
						},
						"webhook": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.`,
						},
					},
				},
			},
			"event_handlers": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Handlers associated with the page to handle events such as webhook errors, no match or no input.`,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"event": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `The name of the event to handle.`,
						},
						"target_flow": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The target flow to transition to.
Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.`,
						},
						"target_page": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The target page to transition to.
Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.`,
						},
						"trigger_fulfillment": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `The fulfillment to call when the event occurs. Handling webhook errors with a fulfillment enabled with webhook could cause infinite loop. It is invalid to specify such fulfillment for a handler handling webhooks.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"messages": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `The list of rich message responses to present to the user.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"text": {
													Type:        schema.TypeList,
													Optional:    true,
													Description: `The text response message.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"text": {
																Type:        schema.TypeList,
																Optional:    true,
																Description: `A collection of text responses.`,
																Elem: &schema.Schema{
																	Type: schema.TypeString,
																},
															},
															"allow_playback_interruption": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `Whether the playback of this message can be interrupted by the end user's speech and the client can then starts the next Dialogflow request.`,
															},
														},
													},
												},
											},
										},
									},
									"return_partial_responses": {
										Type:        schema.TypeBool,
										Optional:    true,
										Description: `Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.`,
									},
									"tag": {
										Type:        schema.TypeString,
										Optional:    true,
										Description: `The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.`,
									},
									"webhook": {
										Type:        schema.TypeString,
										Optional:    true,
										Description: `The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.`,
									},
								},
							},
						},
						"name": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `The unique identifier of this event handler.`,
						},
					},
				},
			},
			"form": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `The form associated with the page, used for collecting parameters relevant to the page.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"parameters": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Parameters to collect from the user.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"display_name": {
										Type:        schema.TypeString,
										Optional:    true,
										Description: `The human-readable name of the parameter, unique within the form.`,
									},
									"entity_type": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `The entity type of the parameter.
Format: projects/-/locations/-/agents/-/entityTypes/<System Entity Type ID> for system entity types (for example, projects/-/locations/-/agents/-/entityTypes/sys.date), or projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/entityTypes/<Entity Type ID> for developer entity types.`,
									},
									"fill_behavior": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Defines fill behavior for the parameter.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"initial_prompt_fulfillment": {
													Type:        schema.TypeList,
													Optional:    true,
													Description: `The fulfillment to provide the initial prompt that the agent can present to the user in order to fill the parameter.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"messages": {
																Type:        schema.TypeList,
																Optional:    true,
																Description: `The list of rich message responses to present to the user.`,
																Elem: &schema.Resource{
																	Schema: map[string]*schema.Schema{
																		"text": {
																			Type:        schema.TypeList,
																			Optional:    true,
																			Description: `The text response message.`,
																			MaxItems:    1,
																			Elem: &schema.Resource{
																				Schema: map[string]*schema.Schema{
																					"text": {
																						Type:        schema.TypeList,
																						Optional:    true,
																						Description: `A collection of text responses.`,
																						Elem: &schema.Schema{
																							Type: schema.TypeString,
																						},
																					},
																					"allow_playback_interruption": {
																						Type:        schema.TypeBool,
																						Computed:    true,
																						Description: `Whether the playback of this message can be interrupted by the end user's speech and the client can then starts the next Dialogflow request.`,
																					},
																				},
																			},
																		},
																	},
																},
															},
															"return_partial_responses": {
																Type:        schema.TypeBool,
																Optional:    true,
																Description: `Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.`,
															},
															"tag": {
																Type:        schema.TypeString,
																Optional:    true,
																Description: `The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.`,
															},
															"webhook": {
																Type:        schema.TypeString,
																Optional:    true,
																Description: `The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.`,
															},
														},
													},
												},
											},
										},
									},
									"is_list": {
										Type:        schema.TypeBool,
										Optional:    true,
										Description: `Indicates whether the parameter represents a list of values.`,
									},
									"redact": {
										Type:     schema.TypeBool,
										Optional: true,
										Description: `Indicates whether the parameter content should be redacted in log.
If redaction is enabled, the parameter content will be replaced by parameter name during logging. Note: the parameter content is subject to redaction if either parameter level redaction or entity type level redaction is enabled.`,
									},
									"required": {
										Type:     schema.TypeBool,
										Optional: true,
										Description: `Indicates whether the parameter is required. Optional parameters will not trigger prompts; however, they are filled if the user specifies them.
Required parameters must be filled before form filling concludes.`,
									},
								},
							},
						},
					},
				},
			},
			"language_code": {
				Type:     schema.TypeString,
				Optional: true,
				ForceNew: true,
				Description: `The language of the following fields in page:

Page.entry_fulfillment.messages
Page.entry_fulfillment.conditional_cases
Page.event_handlers.trigger_fulfillment.messages
Page.event_handlers.trigger_fulfillment.conditional_cases
Page.form.parameters.fill_behavior.initial_prompt_fulfillment.messages
Page.form.parameters.fill_behavior.initial_prompt_fulfillment.conditional_cases
Page.form.parameters.fill_behavior.reprompt_event_handlers.messages
Page.form.parameters.fill_behavior.reprompt_event_handlers.conditional_cases
Page.transition_routes.trigger_fulfillment.messages
Page.transition_routes.trigger_fulfillment.conditional_cases
If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.`,
			},
			"parent": {
				Type:     schema.TypeString,
				Optional: true,
				ForceNew: true,
				Description: `The flow to create a page for.
Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.`,
			},
			"transition_route_groups": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `Ordered list of TransitionRouteGroups associated with the page. Transition route groups must be unique within a page.
If multiple transition routes within a page scope refer to the same intent, then the precedence order is: page's transition route -> page's transition route group -> flow's transition routes.
If multiple transition route groups within a page contain the same intent, then the first group in the ordered list takes precedence.
Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.`,
				Elem: &schema.Schema{
					Type: schema.TypeString,
				},
			},
			"transition_routes": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `A list of transitions for the transition rules of this page. They route the conversation to another page in the same flow, or another flow.
When we are in a certain page, the TransitionRoutes are evalauted in the following order:
TransitionRoutes defined in the page with intent specified.
TransitionRoutes defined in the transition route groups with intent specified.
TransitionRoutes defined in flow with intent specified.
TransitionRoutes defined in the transition route groups with intent specified.
TransitionRoutes defined in the page with only condition specified.
TransitionRoutes defined in the transition route groups with only condition specified.`,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"condition": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The condition to evaluate against form parameters or session parameters.
At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.`,
						},
						"intent": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The unique identifier of an Intent.
Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/intents/<Intent ID>. Indicates that the transition can only happen when the given intent is matched. At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.`,
						},
						"target_flow": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The target flow to transition to.
Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.`,
						},
						"target_page": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The target page to transition to.
Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.`,
						},
						"trigger_fulfillment": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `The fulfillment to call when the event occurs. Handling webhook errors with a fulfillment enabled with webhook could cause infinite loop. It is invalid to specify such fulfillment for a handler handling webhooks.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"messages": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `The list of rich message responses to present to the user.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"text": {
													Type:        schema.TypeList,
													Optional:    true,
													Description: `The text response message.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"text": {
																Type:        schema.TypeList,
																Optional:    true,
																Description: `A collection of text responses.`,
																Elem: &schema.Schema{
																	Type: schema.TypeString,
																},
															},
															"allow_playback_interruption": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `Whether the playback of this message can be interrupted by the end user's speech and the client can then starts the next Dialogflow request.`,
															},
														},
													},
												},
											},
										},
									},
									"return_partial_responses": {
										Type:        schema.TypeBool,
										Optional:    true,
										Description: `Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.`,
									},
									"tag": {
										Type:        schema.TypeString,
										Optional:    true,
										Description: `The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.`,
									},
									"webhook": {
										Type:        schema.TypeString,
										Optional:    true,
										Description: `The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.`,
									},
								},
							},
						},
						"name": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `The unique identifier of this transition route.`,
						},
					},
				},
			},
			"name": {
				Type:     schema.TypeString,
				Computed: true,
				Description: `The unique identifier of the page.
Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.`,
			},
		},
		UseJSONNumber: true,
	}
}

func resourceDialogflowCXPageCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	obj := make(map[string]interface{})
	displayNameProp, err := expandDialogflowCXPageDisplayName(d.Get("display_name"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("display_name"); !isEmptyValue(reflect.ValueOf(displayNameProp)) && (ok || !reflect.DeepEqual(v, displayNameProp)) {
		obj["displayName"] = displayNameProp
	}
	entryFulfillmentProp, err := expandDialogflowCXPageEntryFulfillment(d.Get("entry_fulfillment"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("entry_fulfillment"); !isEmptyValue(reflect.ValueOf(entryFulfillmentProp)) && (ok || !reflect.DeepEqual(v, entryFulfillmentProp)) {
		obj["entryFulfillment"] = entryFulfillmentProp
	}
	formProp, err := expandDialogflowCXPageForm(d.Get("form"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("form"); !isEmptyValue(reflect.ValueOf(formProp)) && (ok || !reflect.DeepEqual(v, formProp)) {
		obj["form"] = formProp
	}
	transitionRouteGroupsProp, err := expandDialogflowCXPageTransitionRouteGroups(d.Get("transition_route_groups"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("transition_route_groups"); !isEmptyValue(reflect.ValueOf(transitionRouteGroupsProp)) && (ok || !reflect.DeepEqual(v, transitionRouteGroupsProp)) {
		obj["transitionRouteGroups"] = transitionRouteGroupsProp
	}
	transitionRoutesProp, err := expandDialogflowCXPageTransitionRoutes(d.Get("transition_routes"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("transition_routes"); !isEmptyValue(reflect.ValueOf(transitionRoutesProp)) && (ok || !reflect.DeepEqual(v, transitionRoutesProp)) {
		obj["transitionRoutes"] = transitionRoutesProp
	}
	eventHandlersProp, err := expandDialogflowCXPageEventHandlers(d.Get("event_handlers"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("event_handlers"); !isEmptyValue(reflect.ValueOf(eventHandlersProp)) && (ok || !reflect.DeepEqual(v, eventHandlersProp)) {
		obj["eventHandlers"] = eventHandlersProp
	}
	languageCodeProp, err := expandDialogflowCXPageLanguageCode(d.Get("language_code"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("language_code"); !isEmptyValue(reflect.ValueOf(languageCodeProp)) && (ok || !reflect.DeepEqual(v, languageCodeProp)) {
		obj["languageCode"] = languageCodeProp
	}

	url, err := replaceVars(d, config, "{{DialogflowCXBasePath}}{{parent}}/pages")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new Page: %#v", obj)
	billingProject := ""

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	// extract location from the parent
	location := ""

	if parts := regexp.MustCompile(`locations\/([^\/]*)\/`).FindStringSubmatch(d.Get("parent").(string)); parts != nil {
		location = parts[1]
	} else {
		return fmt.Errorf(
			"Saw %s when the parent is expected to contains location %s",
			d.Get("parent"),
			"projects/{{project}}/locations/{{location}}/...",
		)
	}

	url = strings.Replace(url, "-dialogflow", fmt.Sprintf("%s-dialogflow", location), 1)
	res, err := sendRequestWithTimeout(config, "POST", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating Page: %s", err)
	}
	if err := d.Set("name", flattenDialogflowCXPageName(res["name"], d, config)); err != nil {
		return fmt.Errorf(`Error setting computed identity field "name": %s`, err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "{{parent}}/pages/{{name}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	log.Printf("[DEBUG] Finished creating Page %q: %#v", d.Id(), res)

	return resourceDialogflowCXPageRead(d, meta)
}

func resourceDialogflowCXPageRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{DialogflowCXBasePath}}{{parent}}/pages/{{name}}")
	if err != nil {
		return err
	}

	billingProject := ""

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	// extract location from the parent
	location := ""

	if parts := regexp.MustCompile(`locations\/([^\/]*)\/`).FindStringSubmatch(d.Get("parent").(string)); parts != nil {
		location = parts[1]
	} else {
		return fmt.Errorf(
			"Saw %s when the parent is expected to contains location %s",
			d.Get("parent"),
			"projects/{{project}}/locations/{{location}}/...",
		)
	}

	url = strings.Replace(url, "-dialogflow", fmt.Sprintf("%s-dialogflow", location), 1)
	res, err := sendRequest(config, "GET", billingProject, url, userAgent, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("DialogflowCXPage %q", d.Id()))
	}

	if err := d.Set("name", flattenDialogflowCXPageName(res["name"], d, config)); err != nil {
		return fmt.Errorf("Error reading Page: %s", err)
	}
	if err := d.Set("display_name", flattenDialogflowCXPageDisplayName(res["displayName"], d, config)); err != nil {
		return fmt.Errorf("Error reading Page: %s", err)
	}
	if err := d.Set("entry_fulfillment", flattenDialogflowCXPageEntryFulfillment(res["entryFulfillment"], d, config)); err != nil {
		return fmt.Errorf("Error reading Page: %s", err)
	}
	if err := d.Set("form", flattenDialogflowCXPageForm(res["form"], d, config)); err != nil {
		return fmt.Errorf("Error reading Page: %s", err)
	}
	if err := d.Set("transition_route_groups", flattenDialogflowCXPageTransitionRouteGroups(res["transitionRouteGroups"], d, config)); err != nil {
		return fmt.Errorf("Error reading Page: %s", err)
	}
	if err := d.Set("transition_routes", flattenDialogflowCXPageTransitionRoutes(res["transitionRoutes"], d, config)); err != nil {
		return fmt.Errorf("Error reading Page: %s", err)
	}
	if err := d.Set("event_handlers", flattenDialogflowCXPageEventHandlers(res["eventHandlers"], d, config)); err != nil {
		return fmt.Errorf("Error reading Page: %s", err)
	}
	if err := d.Set("language_code", flattenDialogflowCXPageLanguageCode(res["languageCode"], d, config)); err != nil {
		return fmt.Errorf("Error reading Page: %s", err)
	}

	return nil
}

func resourceDialogflowCXPageUpdate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	obj := make(map[string]interface{})
	displayNameProp, err := expandDialogflowCXPageDisplayName(d.Get("display_name"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("display_name"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, displayNameProp)) {
		obj["displayName"] = displayNameProp
	}
	entryFulfillmentProp, err := expandDialogflowCXPageEntryFulfillment(d.Get("entry_fulfillment"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("entry_fulfillment"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, entryFulfillmentProp)) {
		obj["entryFulfillment"] = entryFulfillmentProp
	}
	formProp, err := expandDialogflowCXPageForm(d.Get("form"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("form"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, formProp)) {
		obj["form"] = formProp
	}
	transitionRouteGroupsProp, err := expandDialogflowCXPageTransitionRouteGroups(d.Get("transition_route_groups"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("transition_route_groups"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, transitionRouteGroupsProp)) {
		obj["transitionRouteGroups"] = transitionRouteGroupsProp
	}
	transitionRoutesProp, err := expandDialogflowCXPageTransitionRoutes(d.Get("transition_routes"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("transition_routes"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, transitionRoutesProp)) {
		obj["transitionRoutes"] = transitionRoutesProp
	}
	eventHandlersProp, err := expandDialogflowCXPageEventHandlers(d.Get("event_handlers"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("event_handlers"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, eventHandlersProp)) {
		obj["eventHandlers"] = eventHandlersProp
	}

	url, err := replaceVars(d, config, "{{DialogflowCXBasePath}}{{parent}}/pages/{{name}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Updating Page %q: %#v", d.Id(), obj)
	updateMask := []string{}

	if d.HasChange("display_name") {
		updateMask = append(updateMask, "displayName")
	}

	if d.HasChange("entry_fulfillment") {
		updateMask = append(updateMask, "entryFulfillment")
	}

	if d.HasChange("form") {
		updateMask = append(updateMask, "form")
	}

	if d.HasChange("transition_route_groups") {
		updateMask = append(updateMask, "transitionRouteGroups")
	}

	if d.HasChange("transition_routes") {
		updateMask = append(updateMask, "transitionRoutes")
	}

	if d.HasChange("event_handlers") {
		updateMask = append(updateMask, "eventHandlers")
	}
	// updateMask is a URL parameter but not present in the schema, so replaceVars
	// won't set it
	url, err = addQueryParams(url, map[string]string{"updateMask": strings.Join(updateMask, ",")})
	if err != nil {
		return err
	}

	// extract location from the parent
	location := ""

	if parts := regexp.MustCompile(`locations\/([^\/]*)\/`).FindStringSubmatch(d.Get("parent").(string)); parts != nil {
		location = parts[1]
	} else {
		return fmt.Errorf(
			"Saw %s when the parent is expected to contains location %s",
			d.Get("parent"),
			"projects/{{project}}/locations/{{location}}/...",
		)
	}

	url = strings.Replace(url, "-dialogflow", fmt.Sprintf("%s-dialogflow", location), 1)

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "PATCH", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return fmt.Errorf("Error updating Page %q: %s", d.Id(), err)
	} else {
		log.Printf("[DEBUG] Finished updating Page %q: %#v", d.Id(), res)
	}

	return resourceDialogflowCXPageRead(d, meta)
}

func resourceDialogflowCXPageDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	url, err := replaceVars(d, config, "{{DialogflowCXBasePath}}{{parent}}/pages/{{name}}")
	if err != nil {
		return err
	}

	var obj map[string]interface{}

	// extract location from the parent
	location := ""

	if parts := regexp.MustCompile(`locations\/([^\/]*)\/`).FindStringSubmatch(d.Get("parent").(string)); parts != nil {
		location = parts[1]
	} else {
		return fmt.Errorf(
			"Saw %s when the parent is expected to contains location %s",
			d.Get("parent"),
			"projects/{{project}}/locations/{{location}}/...",
		)
	}

	url = strings.Replace(url, "-dialogflow", fmt.Sprintf("%s-dialogflow", location), 1)
	log.Printf("[DEBUG] Deleting Page %q", d.Id())

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "DELETE", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutDelete))
	if err != nil {
		return handleNotFoundError(err, d, "Page")
	}

	log.Printf("[DEBUG] Finished deleting Page %q: %#v", d.Id(), res)
	return nil
}

func resourceDialogflowCXPageImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {
	config := meta.(*Config)

	// current import_formats can't import fields with forward slashes in their value and parent contains slashes
	if err := parseImportId([]string{
		"(?P<parent>.+)/pages/(?P<name>[^/]+)",
		"(?P<parent>.+)/(?P<name>[^/]+)",
	}, d, config); err != nil {
		return nil, err
	}

	// Replace import id for the resource id
	id, err := replaceVars(d, config, "{{parent}}/pages/{{name}}")
	if err != nil {
		return nil, fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	return []*schema.ResourceData{d}, nil
}

func flattenDialogflowCXPageName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	return NameFromSelfLinkStateFunc(v)
}

func flattenDialogflowCXPageDisplayName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageEntryFulfillment(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["messages"] =
		flattenDialogflowCXPageEntryFulfillmentMessages(original["messages"], d, config)
	transformed["webhook"] =
		flattenDialogflowCXPageEntryFulfillmentWebhook(original["webhook"], d, config)
	transformed["return_partial_responses"] =
		flattenDialogflowCXPageEntryFulfillmentReturnPartialResponses(original["returnPartialResponses"], d, config)
	transformed["tag"] =
		flattenDialogflowCXPageEntryFulfillmentTag(original["tag"], d, config)
	return []interface{}{transformed}
}
func flattenDialogflowCXPageEntryFulfillmentMessages(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"text": flattenDialogflowCXPageEntryFulfillmentMessagesText(original["text"], d, config),
		})
	}
	return transformed
}
func flattenDialogflowCXPageEntryFulfillmentMessagesText(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["text"] =
		flattenDialogflowCXPageEntryFulfillmentMessagesTextText(original["text"], d, config)
	transformed["allow_playback_interruption"] =
		flattenDialogflowCXPageEntryFulfillmentMessagesTextAllowPlaybackInterruption(original["allowPlaybackInterruption"], d, config)
	return []interface{}{transformed}
}
func flattenDialogflowCXPageEntryFulfillmentMessagesTextText(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageEntryFulfillmentMessagesTextAllowPlaybackInterruption(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageEntryFulfillmentWebhook(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageEntryFulfillmentReturnPartialResponses(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageEntryFulfillmentTag(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageForm(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["parameters"] =
		flattenDialogflowCXPageFormParameters(original["parameters"], d, config)
	return []interface{}{transformed}
}
func flattenDialogflowCXPageFormParameters(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"display_name":  flattenDialogflowCXPageFormParametersDisplayName(original["displayName"], d, config),
			"required":      flattenDialogflowCXPageFormParametersRequired(original["required"], d, config),
			"entity_type":   flattenDialogflowCXPageFormParametersEntityType(original["entityType"], d, config),
			"is_list":       flattenDialogflowCXPageFormParametersIsList(original["isList"], d, config),
			"fill_behavior": flattenDialogflowCXPageFormParametersFillBehavior(original["fillBehavior"], d, config),
			"redact":        flattenDialogflowCXPageFormParametersRedact(original["redact"], d, config),
		})
	}
	return transformed
}
func flattenDialogflowCXPageFormParametersDisplayName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageFormParametersRequired(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageFormParametersEntityType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageFormParametersIsList(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageFormParametersFillBehavior(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["initial_prompt_fulfillment"] =
		flattenDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillment(original["initialPromptFulfillment"], d, config)
	return []interface{}{transformed}
}
func flattenDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillment(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["messages"] =
		flattenDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentMessages(original["messages"], d, config)
	transformed["webhook"] =
		flattenDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentWebhook(original["webhook"], d, config)
	transformed["return_partial_responses"] =
		flattenDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentReturnPartialResponses(original["returnPartialResponses"], d, config)
	transformed["tag"] =
		flattenDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentTag(original["tag"], d, config)
	return []interface{}{transformed}
}
func flattenDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentMessages(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"text": flattenDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText(original["text"], d, config),
		})
	}
	return transformed
}
func flattenDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["text"] =
		flattenDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextText(original["text"], d, config)
	transformed["allow_playback_interruption"] =
		flattenDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextAllowPlaybackInterruption(original["allowPlaybackInterruption"], d, config)
	return []interface{}{transformed}
}
func flattenDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextText(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextAllowPlaybackInterruption(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentWebhook(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentReturnPartialResponses(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentTag(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageFormParametersRedact(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageTransitionRouteGroups(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageTransitionRoutes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"name":                flattenDialogflowCXPageTransitionRoutesName(original["name"], d, config),
			"intent":              flattenDialogflowCXPageTransitionRoutesIntent(original["intent"], d, config),
			"condition":           flattenDialogflowCXPageTransitionRoutesCondition(original["condition"], d, config),
			"trigger_fulfillment": flattenDialogflowCXPageTransitionRoutesTriggerFulfillment(original["triggerFulfillment"], d, config),
			"target_page":         flattenDialogflowCXPageTransitionRoutesTargetPage(original["targetPage"], d, config),
			"target_flow":         flattenDialogflowCXPageTransitionRoutesTargetFlow(original["targetFlow"], d, config),
		})
	}
	return transformed
}
func flattenDialogflowCXPageTransitionRoutesName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageTransitionRoutesIntent(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageTransitionRoutesCondition(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageTransitionRoutesTriggerFulfillment(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["messages"] =
		flattenDialogflowCXPageTransitionRoutesTriggerFulfillmentMessages(original["messages"], d, config)
	transformed["webhook"] =
		flattenDialogflowCXPageTransitionRoutesTriggerFulfillmentWebhook(original["webhook"], d, config)
	transformed["return_partial_responses"] =
		flattenDialogflowCXPageTransitionRoutesTriggerFulfillmentReturnPartialResponses(original["returnPartialResponses"], d, config)
	transformed["tag"] =
		flattenDialogflowCXPageTransitionRoutesTriggerFulfillmentTag(original["tag"], d, config)
	return []interface{}{transformed}
}
func flattenDialogflowCXPageTransitionRoutesTriggerFulfillmentMessages(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"text": flattenDialogflowCXPageTransitionRoutesTriggerFulfillmentMessagesText(original["text"], d, config),
		})
	}
	return transformed
}
func flattenDialogflowCXPageTransitionRoutesTriggerFulfillmentMessagesText(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["text"] =
		flattenDialogflowCXPageTransitionRoutesTriggerFulfillmentMessagesTextText(original["text"], d, config)
	transformed["allow_playback_interruption"] =
		flattenDialogflowCXPageTransitionRoutesTriggerFulfillmentMessagesTextAllowPlaybackInterruption(original["allowPlaybackInterruption"], d, config)
	return []interface{}{transformed}
}
func flattenDialogflowCXPageTransitionRoutesTriggerFulfillmentMessagesTextText(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageTransitionRoutesTriggerFulfillmentMessagesTextAllowPlaybackInterruption(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageTransitionRoutesTriggerFulfillmentWebhook(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageTransitionRoutesTriggerFulfillmentReturnPartialResponses(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageTransitionRoutesTriggerFulfillmentTag(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageTransitionRoutesTargetPage(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageTransitionRoutesTargetFlow(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageEventHandlers(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"name":                flattenDialogflowCXPageEventHandlersName(original["name"], d, config),
			"event":               flattenDialogflowCXPageEventHandlersEvent(original["event"], d, config),
			"trigger_fulfillment": flattenDialogflowCXPageEventHandlersTriggerFulfillment(original["triggerFulfillment"], d, config),
			"target_page":         flattenDialogflowCXPageEventHandlersTargetPage(original["targetPage"], d, config),
			"target_flow":         flattenDialogflowCXPageEventHandlersTargetFlow(original["targetFlow"], d, config),
		})
	}
	return transformed
}
func flattenDialogflowCXPageEventHandlersName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageEventHandlersEvent(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageEventHandlersTriggerFulfillment(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["messages"] =
		flattenDialogflowCXPageEventHandlersTriggerFulfillmentMessages(original["messages"], d, config)
	transformed["webhook"] =
		flattenDialogflowCXPageEventHandlersTriggerFulfillmentWebhook(original["webhook"], d, config)
	transformed["return_partial_responses"] =
		flattenDialogflowCXPageEventHandlersTriggerFulfillmentReturnPartialResponses(original["returnPartialResponses"], d, config)
	transformed["tag"] =
		flattenDialogflowCXPageEventHandlersTriggerFulfillmentTag(original["tag"], d, config)
	return []interface{}{transformed}
}
func flattenDialogflowCXPageEventHandlersTriggerFulfillmentMessages(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"text": flattenDialogflowCXPageEventHandlersTriggerFulfillmentMessagesText(original["text"], d, config),
		})
	}
	return transformed
}
func flattenDialogflowCXPageEventHandlersTriggerFulfillmentMessagesText(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["text"] =
		flattenDialogflowCXPageEventHandlersTriggerFulfillmentMessagesTextText(original["text"], d, config)
	transformed["allow_playback_interruption"] =
		flattenDialogflowCXPageEventHandlersTriggerFulfillmentMessagesTextAllowPlaybackInterruption(original["allowPlaybackInterruption"], d, config)
	return []interface{}{transformed}
}
func flattenDialogflowCXPageEventHandlersTriggerFulfillmentMessagesTextText(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageEventHandlersTriggerFulfillmentMessagesTextAllowPlaybackInterruption(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageEventHandlersTriggerFulfillmentWebhook(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageEventHandlersTriggerFulfillmentReturnPartialResponses(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageEventHandlersTriggerFulfillmentTag(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageEventHandlersTargetPage(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageEventHandlersTargetFlow(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDialogflowCXPageLanguageCode(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func expandDialogflowCXPageDisplayName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageEntryFulfillment(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedMessages, err := expandDialogflowCXPageEntryFulfillmentMessages(original["messages"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMessages); val.IsValid() && !isEmptyValue(val) {
		transformed["messages"] = transformedMessages
	}

	transformedWebhook, err := expandDialogflowCXPageEntryFulfillmentWebhook(original["webhook"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedWebhook); val.IsValid() && !isEmptyValue(val) {
		transformed["webhook"] = transformedWebhook
	}

	transformedReturnPartialResponses, err := expandDialogflowCXPageEntryFulfillmentReturnPartialResponses(original["return_partial_responses"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedReturnPartialResponses); val.IsValid() && !isEmptyValue(val) {
		transformed["returnPartialResponses"] = transformedReturnPartialResponses
	}

	transformedTag, err := expandDialogflowCXPageEntryFulfillmentTag(original["tag"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTag); val.IsValid() && !isEmptyValue(val) {
		transformed["tag"] = transformedTag
	}

	return transformed, nil
}

func expandDialogflowCXPageEntryFulfillmentMessages(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedText, err := expandDialogflowCXPageEntryFulfillmentMessagesText(original["text"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedText); val.IsValid() && !isEmptyValue(val) {
			transformed["text"] = transformedText
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandDialogflowCXPageEntryFulfillmentMessagesText(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedText, err := expandDialogflowCXPageEntryFulfillmentMessagesTextText(original["text"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedText); val.IsValid() && !isEmptyValue(val) {
		transformed["text"] = transformedText
	}

	transformedAllowPlaybackInterruption, err := expandDialogflowCXPageEntryFulfillmentMessagesTextAllowPlaybackInterruption(original["allow_playback_interruption"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowPlaybackInterruption); val.IsValid() && !isEmptyValue(val) {
		transformed["allowPlaybackInterruption"] = transformedAllowPlaybackInterruption
	}

	return transformed, nil
}

func expandDialogflowCXPageEntryFulfillmentMessagesTextText(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageEntryFulfillmentMessagesTextAllowPlaybackInterruption(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageEntryFulfillmentWebhook(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageEntryFulfillmentReturnPartialResponses(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageEntryFulfillmentTag(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageForm(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedParameters, err := expandDialogflowCXPageFormParameters(original["parameters"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedParameters); val.IsValid() && !isEmptyValue(val) {
		transformed["parameters"] = transformedParameters
	}

	return transformed, nil
}

func expandDialogflowCXPageFormParameters(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedDisplayName, err := expandDialogflowCXPageFormParametersDisplayName(original["display_name"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedDisplayName); val.IsValid() && !isEmptyValue(val) {
			transformed["displayName"] = transformedDisplayName
		}

		transformedRequired, err := expandDialogflowCXPageFormParametersRequired(original["required"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedRequired); val.IsValid() && !isEmptyValue(val) {
			transformed["required"] = transformedRequired
		}

		transformedEntityType, err := expandDialogflowCXPageFormParametersEntityType(original["entity_type"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedEntityType); val.IsValid() && !isEmptyValue(val) {
			transformed["entityType"] = transformedEntityType
		}

		transformedIsList, err := expandDialogflowCXPageFormParametersIsList(original["is_list"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedIsList); val.IsValid() && !isEmptyValue(val) {
			transformed["isList"] = transformedIsList
		}

		transformedFillBehavior, err := expandDialogflowCXPageFormParametersFillBehavior(original["fill_behavior"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedFillBehavior); val.IsValid() && !isEmptyValue(val) {
			transformed["fillBehavior"] = transformedFillBehavior
		}

		transformedRedact, err := expandDialogflowCXPageFormParametersRedact(original["redact"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedRedact); val.IsValid() && !isEmptyValue(val) {
			transformed["redact"] = transformedRedact
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandDialogflowCXPageFormParametersDisplayName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageFormParametersRequired(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageFormParametersEntityType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageFormParametersIsList(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageFormParametersFillBehavior(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedInitialPromptFulfillment, err := expandDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillment(original["initial_prompt_fulfillment"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInitialPromptFulfillment); val.IsValid() && !isEmptyValue(val) {
		transformed["initialPromptFulfillment"] = transformedInitialPromptFulfillment
	}

	return transformed, nil
}

func expandDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillment(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedMessages, err := expandDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentMessages(original["messages"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMessages); val.IsValid() && !isEmptyValue(val) {
		transformed["messages"] = transformedMessages
	}

	transformedWebhook, err := expandDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentWebhook(original["webhook"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedWebhook); val.IsValid() && !isEmptyValue(val) {
		transformed["webhook"] = transformedWebhook
	}

	transformedReturnPartialResponses, err := expandDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentReturnPartialResponses(original["return_partial_responses"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedReturnPartialResponses); val.IsValid() && !isEmptyValue(val) {
		transformed["returnPartialResponses"] = transformedReturnPartialResponses
	}

	transformedTag, err := expandDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentTag(original["tag"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTag); val.IsValid() && !isEmptyValue(val) {
		transformed["tag"] = transformedTag
	}

	return transformed, nil
}

func expandDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentMessages(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedText, err := expandDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText(original["text"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedText); val.IsValid() && !isEmptyValue(val) {
			transformed["text"] = transformedText
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedText, err := expandDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextText(original["text"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedText); val.IsValid() && !isEmptyValue(val) {
		transformed["text"] = transformedText
	}

	transformedAllowPlaybackInterruption, err := expandDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextAllowPlaybackInterruption(original["allow_playback_interruption"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowPlaybackInterruption); val.IsValid() && !isEmptyValue(val) {
		transformed["allowPlaybackInterruption"] = transformedAllowPlaybackInterruption
	}

	return transformed, nil
}

func expandDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextText(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextAllowPlaybackInterruption(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentWebhook(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentReturnPartialResponses(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageFormParametersFillBehaviorInitialPromptFulfillmentTag(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageFormParametersRedact(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageTransitionRouteGroups(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageTransitionRoutes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedName, err := expandDialogflowCXPageTransitionRoutesName(original["name"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedName); val.IsValid() && !isEmptyValue(val) {
			transformed["name"] = transformedName
		}

		transformedIntent, err := expandDialogflowCXPageTransitionRoutesIntent(original["intent"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedIntent); val.IsValid() && !isEmptyValue(val) {
			transformed["intent"] = transformedIntent
		}

		transformedCondition, err := expandDialogflowCXPageTransitionRoutesCondition(original["condition"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedCondition); val.IsValid() && !isEmptyValue(val) {
			transformed["condition"] = transformedCondition
		}

		transformedTriggerFulfillment, err := expandDialogflowCXPageTransitionRoutesTriggerFulfillment(original["trigger_fulfillment"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedTriggerFulfillment); val.IsValid() && !isEmptyValue(val) {
			transformed["triggerFulfillment"] = transformedTriggerFulfillment
		}

		transformedTargetPage, err := expandDialogflowCXPageTransitionRoutesTargetPage(original["target_page"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedTargetPage); val.IsValid() && !isEmptyValue(val) {
			transformed["targetPage"] = transformedTargetPage
		}

		transformedTargetFlow, err := expandDialogflowCXPageTransitionRoutesTargetFlow(original["target_flow"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedTargetFlow); val.IsValid() && !isEmptyValue(val) {
			transformed["targetFlow"] = transformedTargetFlow
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandDialogflowCXPageTransitionRoutesName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageTransitionRoutesIntent(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageTransitionRoutesCondition(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageTransitionRoutesTriggerFulfillment(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedMessages, err := expandDialogflowCXPageTransitionRoutesTriggerFulfillmentMessages(original["messages"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMessages); val.IsValid() && !isEmptyValue(val) {
		transformed["messages"] = transformedMessages
	}

	transformedWebhook, err := expandDialogflowCXPageTransitionRoutesTriggerFulfillmentWebhook(original["webhook"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedWebhook); val.IsValid() && !isEmptyValue(val) {
		transformed["webhook"] = transformedWebhook
	}

	transformedReturnPartialResponses, err := expandDialogflowCXPageTransitionRoutesTriggerFulfillmentReturnPartialResponses(original["return_partial_responses"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedReturnPartialResponses); val.IsValid() && !isEmptyValue(val) {
		transformed["returnPartialResponses"] = transformedReturnPartialResponses
	}

	transformedTag, err := expandDialogflowCXPageTransitionRoutesTriggerFulfillmentTag(original["tag"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTag); val.IsValid() && !isEmptyValue(val) {
		transformed["tag"] = transformedTag
	}

	return transformed, nil
}

func expandDialogflowCXPageTransitionRoutesTriggerFulfillmentMessages(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedText, err := expandDialogflowCXPageTransitionRoutesTriggerFulfillmentMessagesText(original["text"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedText); val.IsValid() && !isEmptyValue(val) {
			transformed["text"] = transformedText
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandDialogflowCXPageTransitionRoutesTriggerFulfillmentMessagesText(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedText, err := expandDialogflowCXPageTransitionRoutesTriggerFulfillmentMessagesTextText(original["text"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedText); val.IsValid() && !isEmptyValue(val) {
		transformed["text"] = transformedText
	}

	transformedAllowPlaybackInterruption, err := expandDialogflowCXPageTransitionRoutesTriggerFulfillmentMessagesTextAllowPlaybackInterruption(original["allow_playback_interruption"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowPlaybackInterruption); val.IsValid() && !isEmptyValue(val) {
		transformed["allowPlaybackInterruption"] = transformedAllowPlaybackInterruption
	}

	return transformed, nil
}

func expandDialogflowCXPageTransitionRoutesTriggerFulfillmentMessagesTextText(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageTransitionRoutesTriggerFulfillmentMessagesTextAllowPlaybackInterruption(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageTransitionRoutesTriggerFulfillmentWebhook(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageTransitionRoutesTriggerFulfillmentReturnPartialResponses(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageTransitionRoutesTriggerFulfillmentTag(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageTransitionRoutesTargetPage(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageTransitionRoutesTargetFlow(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageEventHandlers(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedName, err := expandDialogflowCXPageEventHandlersName(original["name"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedName); val.IsValid() && !isEmptyValue(val) {
			transformed["name"] = transformedName
		}

		transformedEvent, err := expandDialogflowCXPageEventHandlersEvent(original["event"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedEvent); val.IsValid() && !isEmptyValue(val) {
			transformed["event"] = transformedEvent
		}

		transformedTriggerFulfillment, err := expandDialogflowCXPageEventHandlersTriggerFulfillment(original["trigger_fulfillment"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedTriggerFulfillment); val.IsValid() && !isEmptyValue(val) {
			transformed["triggerFulfillment"] = transformedTriggerFulfillment
		}

		transformedTargetPage, err := expandDialogflowCXPageEventHandlersTargetPage(original["target_page"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedTargetPage); val.IsValid() && !isEmptyValue(val) {
			transformed["targetPage"] = transformedTargetPage
		}

		transformedTargetFlow, err := expandDialogflowCXPageEventHandlersTargetFlow(original["target_flow"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedTargetFlow); val.IsValid() && !isEmptyValue(val) {
			transformed["targetFlow"] = transformedTargetFlow
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandDialogflowCXPageEventHandlersName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageEventHandlersEvent(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageEventHandlersTriggerFulfillment(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedMessages, err := expandDialogflowCXPageEventHandlersTriggerFulfillmentMessages(original["messages"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMessages); val.IsValid() && !isEmptyValue(val) {
		transformed["messages"] = transformedMessages
	}

	transformedWebhook, err := expandDialogflowCXPageEventHandlersTriggerFulfillmentWebhook(original["webhook"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedWebhook); val.IsValid() && !isEmptyValue(val) {
		transformed["webhook"] = transformedWebhook
	}

	transformedReturnPartialResponses, err := expandDialogflowCXPageEventHandlersTriggerFulfillmentReturnPartialResponses(original["return_partial_responses"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedReturnPartialResponses); val.IsValid() && !isEmptyValue(val) {
		transformed["returnPartialResponses"] = transformedReturnPartialResponses
	}

	transformedTag, err := expandDialogflowCXPageEventHandlersTriggerFulfillmentTag(original["tag"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTag); val.IsValid() && !isEmptyValue(val) {
		transformed["tag"] = transformedTag
	}

	return transformed, nil
}

func expandDialogflowCXPageEventHandlersTriggerFulfillmentMessages(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedText, err := expandDialogflowCXPageEventHandlersTriggerFulfillmentMessagesText(original["text"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedText); val.IsValid() && !isEmptyValue(val) {
			transformed["text"] = transformedText
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandDialogflowCXPageEventHandlersTriggerFulfillmentMessagesText(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedText, err := expandDialogflowCXPageEventHandlersTriggerFulfillmentMessagesTextText(original["text"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedText); val.IsValid() && !isEmptyValue(val) {
		transformed["text"] = transformedText
	}

	transformedAllowPlaybackInterruption, err := expandDialogflowCXPageEventHandlersTriggerFulfillmentMessagesTextAllowPlaybackInterruption(original["allow_playback_interruption"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowPlaybackInterruption); val.IsValid() && !isEmptyValue(val) {
		transformed["allowPlaybackInterruption"] = transformedAllowPlaybackInterruption
	}

	return transformed, nil
}

func expandDialogflowCXPageEventHandlersTriggerFulfillmentMessagesTextText(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageEventHandlersTriggerFulfillmentMessagesTextAllowPlaybackInterruption(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageEventHandlersTriggerFulfillmentWebhook(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageEventHandlersTriggerFulfillmentReturnPartialResponses(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageEventHandlersTriggerFulfillmentTag(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageEventHandlersTargetPage(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageEventHandlersTargetFlow(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDialogflowCXPageLanguageCode(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}
