#ifndef _DMAP_CC_H
#define _DMAP_CC_H

#include <glib-object.h>

G_BEGIN_DECLS

typedef enum {
	DMAP_CC_INVALID = 0,
	DMAP_RAW,		/* The RAW type does not use a content code.
				 * Instead of:
				 * CCCC BYTECOUNT DATA
				 * RAW sends:
				 * DATA
				 */
	DMAP_CC_MDCL,
	DMAP_CC_MSTT,
	DMAP_CC_MIID,
	DMAP_CC_MINM,
	DMAP_CC_MIKD,
	DMAP_CC_MPER,
	DMAP_CC_MCON,
	DMAP_CC_MCTI,
	DMAP_CC_MPCO,
	DMAP_CC_MSTS,
	DMAP_CC_MIMC,
	DMAP_CC_MCTC,
	DMAP_CC_MRCO,
	DMAP_CC_MTCO,
	DMAP_CC_MLCL,
	DMAP_CC_MLIT,
	DMAP_CC_MBCL,
	DMAP_CC_MSRV,
	DMAP_CC_MSAU,
	DMAP_CC_MSLR,
	DMAP_CC_MPRO,
	DMAP_CC_MSAL,
	DMAP_CC_MSUP,
	DMAP_CC_MSPI,
	DMAP_CC_MSEX,
	DMAP_CC_MSBR,
	DMAP_CC_MSQY,
	DMAP_CC_MSIX,
	DMAP_CC_MSRS,
	DMAP_CC_MSTM,
	DMAP_CC_MSDC,
	DMAP_CC_MCCR,
	DMAP_CC_MCNM,
	DMAP_CC_MCNA,
	DMAP_CC_MCTY,
	DMAP_CC_MLOG,
	DMAP_CC_MLID,
	DMAP_CC_MUPD,
	DMAP_CC_MUSR,
	DMAP_CC_MUTY,
	DMAP_CC_MUDL,
	DMAP_CC_MSMA,
	DMAP_CC_FQUESCH,

	DMAP_CC_APRO,
	DMAP_CC_AVDB,
	DMAP_CC_ABRO,
	DMAP_CC_ABAL,
	DMAP_CC_ABAR,
	DMAP_CC_ABCP,
	DMAP_CC_ABGN,
	DMAP_CC_ADBS,
	DMAP_CC_ASAL,
	DMAP_CC_ASAI,
	DMAP_CC_ASAA,
	DMAP_CC_ASAR,
	DMAP_CC_ASBT,
	DMAP_CC_ASBR,
	DMAP_CC_ASCM,
	DMAP_CC_ASCO,
	DMAP_CC_ASDA,
	DMAP_CC_ASDM,
	DMAP_CC_ASDC,
	DMAP_CC_ASDN,
	DMAP_CC_ASDB,
	DMAP_CC_ASEQ,
	DMAP_CC_ASFM,
	DMAP_CC_ASGN,
	DMAP_CC_ASDT,
	DMAP_CC_ASRV,
	DMAP_CC_ASSR,
	DMAP_CC_ASSZ,
	DMAP_CC_ASST,
	DMAP_CC_ASSP,
	DMAP_CC_ASTM,
	DMAP_CC_ASTC,
	DMAP_CC_ASTN,
	DMAP_CC_ASUR,
	DMAP_CC_ASYR,
	DMAP_CC_ASDK,
	DMAP_CC_ASUL,
	DMAP_CC_ASSU,
	DMAP_CC_ASSA,
	DMAP_CC_APLY,
	DMAP_CC_ABPL,
	DMAP_CC_APSO,
	DMAP_CC_PRSV,
	DMAP_CC_ARIF,
	DMAP_CC_MSAS,
	DMAP_CC_AGRP,
	DMAP_CC_AGAL,
	DMAP_CC_ASCP,
	DMAP_CC_PPRO,
	DMAP_CC_PASP,
	DMAP_CC_PFDT,
	DMAP_CC_PICD,
	DMAP_CC_PIMF,
	DMAP_CC_PFMT,
	DMAP_CC_PIFS,
	DMAP_CC_PLSZ,
	DMAP_CC_PHGT,
	DMAP_CC_PWTH,
	DMAP_CC_PRAT,
	DMAP_CC_PCMT,
	DMAP_CC_PRET,

	/* iTunes 6.02+ */
	DMAP_CC_AESV,
	DMAP_CC_AEHV,

	DMAP_CC_AESP,
	DMAP_CC_AEPP,
	DMAP_CC_AEPS,
	DMAP_CC_AESG,
	DMAP_CC_AEMK,
	DMAP_CC_AEFP,

	/* DACP */
	DMAP_CC_CMPA,
	DMAP_CC_CMNM,
	DMAP_CC_CMTY,
	DMAP_CC_CMPG,

	DMAP_CC_CACI,
	DMAP_CC_CAPS,
	DMAP_CC_CASH,
	DMAP_CC_CARP,
	DMAP_CC_CAAS,
	DMAP_CC_CAAR,
	DMAP_CC_CAIA,
	DMAP_CC_CANP,
	DMAP_CC_CANN,
	DMAP_CC_CANA,
	DMAP_CC_CANL,
	DMAP_CC_CANG,
	DMAP_CC_CANT,
	DMAP_CC_CASP,
	DMAP_CC_CASS,
	DMAP_CC_CAST,
	DMAP_CC_CASU,
	DMAP_CC_CASG,
	DMAP_CC_CACR,

	DMAP_CC_CMCP,
	DMAP_CC_CMGT,
	DMAP_CC_CMIK,
	DMAP_CC_CMSP,
	DMAP_CC_CMST,
	DMAP_CC_CMSV,
	DMAP_CC_CMSR,
	DMAP_CC_CMMK,
	DMAP_CC_CMVO,

	DMAP_CC_CMPR,
	DMAP_CC_CAPR,
	DMAP_CC_AEFR,
	DMAP_CC_CAOV,
	DMAP_CC_CMRL,
	DMAP_CC_CAHP,
	DMAP_CC_CAIV,
	DMAP_CC_CAVC
} DmapContentCode;

#endif
