/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.ParameterList;
import javax.mail.internet.ParseException;

public class ContentType {
    private String primaryType;
    private String subType;
    private ParameterList list;

    public ContentType() {
    }

    public ContentType(String string, String string2, ParameterList parameterList) {
        this.primaryType = string;
        this.subType = string2;
        this.list = parameterList;
    }

    public ContentType(String string) throws ParseException {
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string, "()<>@,;:\\\"\t []/?=");
        HeaderTokenizer.Token token = headerTokenizer.next();
        if (token.getType() != -1) {
            throw new ParseException();
        }
        this.primaryType = token.getValue();
        token = headerTokenizer.next();
        if ((char)token.getType() != '/') {
            throw new ParseException();
        }
        token = headerTokenizer.next();
        if (token.getType() != -1) {
            throw new ParseException();
        }
        this.subType = token.getValue();
        String string2 = headerTokenizer.getRemainder();
        if (string2 != null) {
            this.list = new ParameterList(string2);
        }
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getBaseType() {
        return String.valueOf(this.primaryType) + '/' + this.subType;
    }

    public String getParameter(String string) {
        if (this.list == null) {
            return null;
        }
        return this.list.get(string);
    }

    public ParameterList getParameterList() {
        return this.list;
    }

    public void setPrimaryType(String string) {
        this.primaryType = string;
    }

    public void setSubType(String string) {
        this.subType = string;
    }

    public void setParameter(String string, String string2) {
        if (this.list == null) {
            this.list = new ParameterList();
        }
        this.list.set(string, string2);
    }

    public void setParameterList(ParameterList parameterList) {
        this.list = parameterList;
    }

    public String toString() {
        if (this.primaryType == null || this.subType == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.primaryType).append('/').append(this.subType);
        if (this.list != null) {
            stringBuffer.append(this.list.toString(stringBuffer.length() + 14));
        }
        return stringBuffer.toString();
    }

    public boolean match(ContentType contentType) {
        if (!this.primaryType.equalsIgnoreCase(contentType.getPrimaryType())) {
            return false;
        }
        String string = contentType.getSubType();
        if (this.subType.charAt(0) == '*' || string.charAt(0) == '*') {
            return true;
        }
        return this.subType.equalsIgnoreCase(string);
    }

    public boolean match(String string) {
        try {
            return this.match(new ContentType(string));
        }
        catch (ParseException parseException) {
            return false;
        }
    }
}

