"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiPageSideBar", {
  enumerable: true,
  get: function get() {
    return _page_side_bar.EuiPageSideBar;
  }
});
exports.OuiPageSideBar = exports.PADDING_SIZES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../../common");

var _page_side_bar = require("../../../eui_components/page/page_side_bar/page_side_bar");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var paddingSizeToClassNameMap = {
  none: null,
  s: 'ouiPageSideBar--paddingSmall',
  m: 'ouiPageSideBar--paddingMedium',
  l: 'ouiPageSideBar--paddingLarge'
};
var PADDING_SIZES = (0, _common.keysOf)(paddingSizeToClassNameMap);
exports.PADDING_SIZES = PADDING_SIZES;

var OuiPageSideBar = function OuiPageSideBar(_ref) {
  var children = _ref.children,
      className = _ref.className,
      sticky = _ref.sticky,
      _ref$paddingSize = _ref.paddingSize,
      paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "sticky", "paddingSize"]);
  var classes = (0, _classnames.default)('ouiPageSideBar', paddingSizeToClassNameMap[paddingSize], {
    'ouiPageSideBar--sticky': sticky
  }, className);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest), children);
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiPageSideBar = OuiPageSideBar;
OuiPageSideBar.propTypes = {
  /**
     * Adds `position: sticky` and affords for any fixed position headers
     */
  sticky: _propTypes.default.bool,

  /**
     * Adds padding around the children
     */
  paddingSize: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};