"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _configSchema = require("@osd/config-schema");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function _default(services, router) {
  const {
    destinationsService
  } = services;
  router.get({
    path: '/api/alerting/destinations',
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.maybe(_configSchema.schema.number()),
        size: _configSchema.schema.maybe(_configSchema.schema.number()),
        search: _configSchema.schema.maybe(_configSchema.schema.string()),
        sortField: _configSchema.schema.maybe(_configSchema.schema.string()),
        sortDirection: _configSchema.schema.maybe(_configSchema.schema.string()),
        type: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, destinationsService.getDestinations);
  router.get({
    path: '/api/alerting/destinations/{destinationId}',
    validate: {
      params: _configSchema.schema.object({
        destinationId: _configSchema.schema.string()
      })
    }
  }, destinationsService.getDestination);
  router.post({
    path: '/api/alerting/destinations',
    validate: {
      body: _configSchema.schema.any()
    }
  }, destinationsService.createDestination);
  router.put({
    path: '/api/alerting/destinations/{destinationId}',
    validate: {
      params: _configSchema.schema.object({
        destinationId: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ifSeqNo: _configSchema.schema.string(),
        ifPrimaryTerm: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, destinationsService.updateDestination);
  router.delete({
    path: '/api/alerting/destinations/{destinationId}',
    validate: {
      params: _configSchema.schema.object({
        destinationId: _configSchema.schema.string()
      })
    }
  }, destinationsService.deleteDestination);
  router.get({
    path: '/api/alerting/destinations/email_accounts',
    validate: {
      query: _configSchema.schema.object({
        search: _configSchema.schema.maybe(_configSchema.schema.string()),
        size: _configSchema.schema.number()
      })
    }
  }, destinationsService.getEmailAccounts);
  router.post({
    path: '/api/alerting/destinations/email_accounts',
    validate: {
      body: _configSchema.schema.any()
    }
  }, destinationsService.createEmailAccount);
  router.get({
    path: '/api/alerting/destinations/email_accounts/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, destinationsService.getEmailAccount);
  router.put({
    path: '/api/alerting/destinations/email_accounts/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ifSeqNo: _configSchema.schema.number(),
        ifPrimaryTerm: _configSchema.schema.number()
      }),
      body: _configSchema.schema.any()
    }
  }, destinationsService.updateEmailAccount);
  router.delete({
    path: '/api/alerting/destinations/email_accounts/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, destinationsService.deleteEmailAccount);
  router.get({
    path: '/api/alerting/destinations/email_groups',
    validate: {
      query: _configSchema.schema.object({
        search: _configSchema.schema.maybe(_configSchema.schema.string()),
        size: _configSchema.schema.number()
      })
    }
  }, destinationsService.getEmailGroups);
  router.post({
    path: '/api/alerting/destinations/email_groups',
    validate: {
      body: _configSchema.schema.any()
    }
  }, destinationsService.createEmailGroup);
  router.get({
    path: '/api/alerting/destinations/email_groups/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, destinationsService.getEmailGroup);
  router.put({
    path: '/api/alerting/destinations/email_groups/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ifSeqNo: _configSchema.schema.number(),
        ifPrimaryTerm: _configSchema.schema.number()
      }),
      body: _configSchema.schema.any()
    }
  }, destinationsService.updateEmailGroup);
  router.delete({
    path: '/api/alerting/destinations/email_groups/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, destinationsService.deleteEmailGroup);
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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