"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _configSchema = require("@osd/config-schema");

var _constants = require("../../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function _default(services, router) {
  const {
    managedIndexService
  } = services;
  router.get({
    path: _constants.NODE_API.MANAGED_INDICES,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        terms: _configSchema.schema.maybe(_configSchema.schema.any()),
        indices: _configSchema.schema.maybe(_configSchema.schema.any()),
        dataStreams: _configSchema.schema.maybe(_configSchema.schema.any()),
        showDataStreams: _configSchema.schema.boolean()
      })
    }
  }, managedIndexService.getManagedIndices);
  router.get({
    path: `${_constants.NODE_API.MANAGED_INDICES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, managedIndexService.getManagedIndex);
  router.post({
    path: _constants.NODE_API.RETRY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, managedIndexService.retryManagedIndexPolicy);
  router.post({
    path: _constants.NODE_API.CHANGE_POLICY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, managedIndexService.changePolicy);
  router.post({
    path: _constants.NODE_API.REMOVE_POLICY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, managedIndexService.removePolicy);
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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