"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiSettingsService = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
let uiSettings;
let notifications;
const uiSettingsService = {
  init: (client, notificationsStart) => {
    uiSettings = client;
    notifications = notificationsStart;
  },
  get: (key, defaultOverride) => {
    var _uiSettings;

    return ((_uiSettings = uiSettings) === null || _uiSettings === void 0 ? void 0 : _uiSettings.get(key, defaultOverride)) || '';
  },
  set: (key, value) => {
    var _uiSettings2;

    return ((_uiSettings2 = uiSettings) === null || _uiSettings2 === void 0 ? void 0 : _uiSettings2.set(key, value)) || Promise.reject("uiSettings client not initialized.");
  },
  addToast: toast => {
    return notifications.toasts.add(toast);
  }
};
exports.uiSettingsService = uiSettingsService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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