import * as React from "react";
import { AbstractPureComponent2 } from "../../common";
import { Props } from "../../common/props";
export declare type TextProps = ITextProps;
/** @deprecated use TextProps */
export interface ITextProps extends Props {
    /**
     * Indicates that this component should be truncated with an ellipsis if it overflows its container.
     * The `title` attribute will also be added when content overflows to show the full text of the children on hover.
     *
     * @default false
     */
    ellipsize?: boolean;
    /**
     * HTML tag name to use for rendered element.
     *
     * @default "div"
     */
    tagName?: keyof JSX.IntrinsicElements;
    /**
     * HTML title of the element
     */
    title?: string;
}
export interface ITextState {
    textContent: string;
    isContentOverflowing: boolean;
}
export declare class Text extends AbstractPureComponent2<TextProps & Omit<React.HTMLAttributes<HTMLElement>, "title">, ITextState> {
    static displayName: string;
    static defaultProps: Partial<TextProps>;
    state: ITextState;
    private textRef;
    componentDidMount(): void;
    componentDidUpdate(): void;
    render(): React.DOMElement<{
        className: string;
        ref: (ref: HTMLElement | null) => HTMLElement | null;
        title: string | undefined;
        hidden?: boolean | undefined;
        dir?: string | undefined;
        slot?: string | undefined;
        style?: React.CSSProperties | undefined;
        color?: string | undefined;
        translate?: "yes" | "no" | undefined;
        prefix?: string | undefined;
        property?: string | undefined;
        defaultChecked?: boolean | undefined;
        defaultValue?: string | number | readonly string[] | undefined;
        suppressContentEditableWarning?: boolean | undefined;
        suppressHydrationWarning?: boolean | undefined;
        accessKey?: string | undefined;
        contentEditable?: boolean | "inherit" | "false" | "true" | undefined;
        contextMenu?: string | undefined;
        draggable?: boolean | "false" | "true" | undefined;
        id?: string | undefined;
        lang?: string | undefined;
        placeholder?: string | undefined;
        spellCheck?: boolean | "false" | "true" | undefined;
        tabIndex?: number | undefined;
        radioGroup?: string | undefined;
        role?: string | undefined;
        about?: string | undefined;
        datatype?: string | undefined;
        inlist?: any;
        resource?: string | undefined;
        typeof?: string | undefined;
        vocab?: string | undefined;
        autoCapitalize?: string | undefined;
        autoCorrect?: string | undefined;
        autoSave?: string | undefined;
        itemProp?: string | undefined;
        itemScope?: boolean | undefined;
        itemType?: string | undefined;
        itemID?: string | undefined;
        itemRef?: string | undefined;
        results?: number | undefined;
        security?: string | undefined;
        unselectable?: "on" | "off" | undefined;
        inputMode?: "search" | "none" | "text" | "decimal" | "numeric" | "tel" | "url" | "email" | undefined;
        is?: string | undefined;
        'aria-activedescendant'?: string | undefined;
        'aria-atomic'?: boolean | "false" | "true" | undefined;
        'aria-autocomplete'?: "both" | "none" | "inline" | "list" | undefined;
        'aria-busy'?: boolean | "false" | "true" | undefined;
        'aria-checked'?: boolean | "mixed" | "false" | "true" | undefined;
        'aria-colcount'?: number | undefined;
        'aria-colindex'?: number | undefined;
        'aria-colspan'?: number | undefined;
        'aria-controls'?: string | undefined;
        'aria-current'?: boolean | "time" | "page" | "false" | "true" | "step" | "location" | "date" | undefined;
        'aria-describedby'?: string | undefined;
        'aria-details'?: string | undefined;
        'aria-disabled'?: boolean | "false" | "true" | undefined;
        'aria-dropeffect'?: "link" | "none" | "copy" | "move" | "execute" | "popup" | undefined;
        'aria-errormessage'?: string | undefined;
        'aria-expanded'?: boolean | "false" | "true" | undefined;
        'aria-flowto'?: string | undefined;
        'aria-grabbed'?: boolean | "false" | "true" | undefined;
        'aria-haspopup'?: boolean | "dialog" | "menu" | "listbox" | "grid" | "false" | "true" | "tree" | undefined;
        'aria-hidden'?: boolean | "false" | "true" | undefined;
        'aria-invalid'?: boolean | "false" | "true" | "grammar" | "spelling" | undefined;
        'aria-keyshortcuts'?: string | undefined;
        'aria-label'?: string | undefined;
        'aria-labelledby'?: string | undefined;
        'aria-level'?: number | undefined;
        'aria-live'?: "off" | "assertive" | "polite" | undefined;
        'aria-modal'?: boolean | "false" | "true" | undefined;
        'aria-multiline'?: boolean | "false" | "true" | undefined;
        'aria-multiselectable'?: boolean | "false" | "true" | undefined;
        'aria-orientation'?: "horizontal" | "vertical" | undefined;
        'aria-owns'?: string | undefined;
        'aria-placeholder'?: string | undefined;
        'aria-posinset'?: number | undefined;
        'aria-pressed'?: boolean | "mixed" | "false" | "true" | undefined;
        'aria-readonly'?: boolean | "false" | "true" | undefined;
        'aria-relevant'?: "all" | "text" | "additions" | "additions removals" | "additions text" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
        'aria-required'?: boolean | "false" | "true" | undefined;
        'aria-roledescription'?: string | undefined;
        'aria-rowcount'?: number | undefined;
        'aria-rowindex'?: number | undefined;
        'aria-rowspan'?: number | undefined;
        'aria-selected'?: boolean | "false" | "true" | undefined;
        'aria-setsize'?: number | undefined;
        'aria-sort'?: "none" | "other" | "ascending" | "descending" | undefined;
        'aria-valuemax'?: number | undefined;
        'aria-valuemin'?: number | undefined;
        'aria-valuenow'?: number | undefined;
        'aria-valuetext'?: string | undefined;
        dangerouslySetInnerHTML?: {
            __html: string;
        } | undefined;
        onCopy?: ((event: React.ClipboardEvent<HTMLElement>) => void) | undefined;
        onCopyCapture?: ((event: React.ClipboardEvent<HTMLElement>) => void) | undefined;
        onCut?: ((event: React.ClipboardEvent<HTMLElement>) => void) | undefined;
        onCutCapture?: ((event: React.ClipboardEvent<HTMLElement>) => void) | undefined;
        onPaste?: ((event: React.ClipboardEvent<HTMLElement>) => void) | undefined;
        onPasteCapture?: ((event: React.ClipboardEvent<HTMLElement>) => void) | undefined;
        onCompositionEnd?: ((event: React.CompositionEvent<HTMLElement>) => void) | undefined;
        onCompositionEndCapture?: ((event: React.CompositionEvent<HTMLElement>) => void) | undefined;
        onCompositionStart?: ((event: React.CompositionEvent<HTMLElement>) => void) | undefined;
        onCompositionStartCapture?: ((event: React.CompositionEvent<HTMLElement>) => void) | undefined;
        onCompositionUpdate?: ((event: React.CompositionEvent<HTMLElement>) => void) | undefined;
        onCompositionUpdateCapture?: ((event: React.CompositionEvent<HTMLElement>) => void) | undefined;
        onFocus?: ((event: React.FocusEvent<HTMLElement>) => void) | undefined;
        onFocusCapture?: ((event: React.FocusEvent<HTMLElement>) => void) | undefined;
        onBlur?: ((event: React.FocusEvent<HTMLElement>) => void) | undefined;
        onBlurCapture?: ((event: React.FocusEvent<HTMLElement>) => void) | undefined;
        onChange?: ((event: React.FormEvent<HTMLElement>) => void) | undefined;
        onChangeCapture?: ((event: React.FormEvent<HTMLElement>) => void) | undefined;
        onBeforeInput?: ((event: React.FormEvent<HTMLElement>) => void) | undefined;
        onBeforeInputCapture?: ((event: React.FormEvent<HTMLElement>) => void) | undefined;
        onInput?: ((event: React.FormEvent<HTMLElement>) => void) | undefined;
        onInputCapture?: ((event: React.FormEvent<HTMLElement>) => void) | undefined;
        onReset?: ((event: React.FormEvent<HTMLElement>) => void) | undefined;
        onResetCapture?: ((event: React.FormEvent<HTMLElement>) => void) | undefined;
        onSubmit?: ((event: React.FormEvent<HTMLElement>) => void) | undefined;
        onSubmitCapture?: ((event: React.FormEvent<HTMLElement>) => void) | undefined;
        onInvalid?: ((event: React.FormEvent<HTMLElement>) => void) | undefined;
        onInvalidCapture?: ((event: React.FormEvent<HTMLElement>) => void) | undefined;
        onLoad?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onLoadCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onError?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onErrorCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onKeyDown?: ((event: React.KeyboardEvent<HTMLElement>) => void) | undefined;
        onKeyDownCapture?: ((event: React.KeyboardEvent<HTMLElement>) => void) | undefined;
        onKeyPress?: ((event: React.KeyboardEvent<HTMLElement>) => void) | undefined;
        onKeyPressCapture?: ((event: React.KeyboardEvent<HTMLElement>) => void) | undefined;
        onKeyUp?: ((event: React.KeyboardEvent<HTMLElement>) => void) | undefined;
        onKeyUpCapture?: ((event: React.KeyboardEvent<HTMLElement>) => void) | undefined;
        onAbort?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onAbortCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onCanPlay?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onCanPlayCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onCanPlayThrough?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onCanPlayThroughCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onDurationChange?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onDurationChangeCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onEmptied?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onEmptiedCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onEncrypted?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onEncryptedCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onEnded?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onEndedCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onLoadedData?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onLoadedDataCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onLoadedMetadata?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onLoadedMetadataCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onLoadStart?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onLoadStartCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onPause?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onPauseCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onPlay?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onPlayCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onPlaying?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onPlayingCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onProgress?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onProgressCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onRateChange?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onRateChangeCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onSeeked?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onSeekedCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onSeeking?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onSeekingCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onStalled?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onStalledCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onSuspend?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onSuspendCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onTimeUpdate?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onTimeUpdateCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onVolumeChange?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onVolumeChangeCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onWaiting?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onWaitingCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onAuxClick?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onAuxClickCapture?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onClick?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onClickCapture?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onContextMenu?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onContextMenuCapture?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onDoubleClick?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onDoubleClickCapture?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onDrag?: ((event: React.DragEvent<HTMLElement>) => void) | undefined;
        onDragCapture?: ((event: React.DragEvent<HTMLElement>) => void) | undefined;
        onDragEnd?: ((event: React.DragEvent<HTMLElement>) => void) | undefined;
        onDragEndCapture?: ((event: React.DragEvent<HTMLElement>) => void) | undefined;
        onDragEnter?: ((event: React.DragEvent<HTMLElement>) => void) | undefined;
        onDragEnterCapture?: ((event: React.DragEvent<HTMLElement>) => void) | undefined;
        onDragExit?: ((event: React.DragEvent<HTMLElement>) => void) | undefined;
        onDragExitCapture?: ((event: React.DragEvent<HTMLElement>) => void) | undefined;
        onDragLeave?: ((event: React.DragEvent<HTMLElement>) => void) | undefined;
        onDragLeaveCapture?: ((event: React.DragEvent<HTMLElement>) => void) | undefined;
        onDragOver?: ((event: React.DragEvent<HTMLElement>) => void) | undefined;
        onDragOverCapture?: ((event: React.DragEvent<HTMLElement>) => void) | undefined;
        onDragStart?: ((event: React.DragEvent<HTMLElement>) => void) | undefined;
        onDragStartCapture?: ((event: React.DragEvent<HTMLElement>) => void) | undefined;
        onDrop?: ((event: React.DragEvent<HTMLElement>) => void) | undefined;
        onDropCapture?: ((event: React.DragEvent<HTMLElement>) => void) | undefined;
        onMouseDown?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onMouseDownCapture?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onMouseEnter?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onMouseLeave?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onMouseMove?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onMouseMoveCapture?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onMouseOut?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onMouseOutCapture?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onMouseOver?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onMouseOverCapture?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onMouseUp?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onMouseUpCapture?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void) | undefined;
        onSelect?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onSelectCapture?: ((event: React.SyntheticEvent<HTMLElement, Event>) => void) | undefined;
        onTouchCancel?: ((event: React.TouchEvent<HTMLElement>) => void) | undefined;
        onTouchCancelCapture?: ((event: React.TouchEvent<HTMLElement>) => void) | undefined;
        onTouchEnd?: ((event: React.TouchEvent<HTMLElement>) => void) | undefined;
        onTouchEndCapture?: ((event: React.TouchEvent<HTMLElement>) => void) | undefined;
        onTouchMove?: ((event: React.TouchEvent<HTMLElement>) => void) | undefined;
        onTouchMoveCapture?: ((event: React.TouchEvent<HTMLElement>) => void) | undefined;
        onTouchStart?: ((event: React.TouchEvent<HTMLElement>) => void) | undefined;
        onTouchStartCapture?: ((event: React.TouchEvent<HTMLElement>) => void) | undefined;
        onPointerDown?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onPointerDownCapture?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onPointerMove?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onPointerMoveCapture?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onPointerUp?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onPointerUpCapture?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onPointerCancel?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onPointerCancelCapture?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onPointerEnter?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onPointerEnterCapture?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onPointerLeave?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onPointerLeaveCapture?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onPointerOver?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onPointerOverCapture?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onPointerOut?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onPointerOutCapture?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onGotPointerCapture?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onGotPointerCaptureCapture?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onLostPointerCapture?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onLostPointerCaptureCapture?: ((event: React.PointerEvent<HTMLElement>) => void) | undefined;
        onScroll?: ((event: React.UIEvent<HTMLElement, UIEvent>) => void) | undefined;
        onScrollCapture?: ((event: React.UIEvent<HTMLElement, UIEvent>) => void) | undefined;
        onWheel?: ((event: React.WheelEvent<HTMLElement>) => void) | undefined;
        onWheelCapture?: ((event: React.WheelEvent<HTMLElement>) => void) | undefined;
        onAnimationStart?: ((event: React.AnimationEvent<HTMLElement>) => void) | undefined;
        onAnimationStartCapture?: ((event: React.AnimationEvent<HTMLElement>) => void) | undefined;
        onAnimationEnd?: ((event: React.AnimationEvent<HTMLElement>) => void) | undefined;
        onAnimationEndCapture?: ((event: React.AnimationEvent<HTMLElement>) => void) | undefined;
        onAnimationIteration?: ((event: React.AnimationEvent<HTMLElement>) => void) | undefined;
        onAnimationIterationCapture?: ((event: React.AnimationEvent<HTMLElement>) => void) | undefined;
        onTransitionEnd?: ((event: React.TransitionEvent<HTMLElement>) => void) | undefined;
        onTransitionEndCapture?: ((event: React.TransitionEvent<HTMLElement>) => void) | undefined;
    }, HTMLElement>;
    private update;
}
