"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requestor = void 0;

var _wreck = _interopRequireDefault(require("@hapi/wreck"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const requestor = async function (requestType, url, wreckOptions) {
  const promise = _wreck.default.request(requestType, url, wreckOptions);

  const res = await promise;
  const body = await _wreck.default.read(res, wreckOptions);
  return body;
};

exports.requestor = requestor;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndyZWNrX3JlcXVlc3RzLnRzIl0sIm5hbWVzIjpbInJlcXVlc3RvciIsInJlcXVlc3RUeXBlIiwidXJsIiwid3JlY2tPcHRpb25zIiwicHJvbWlzZSIsIldyZWNrIiwicmVxdWVzdCIsInJlcyIsImJvZHkiLCJyZWFkIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBS0E7Ozs7QUFMQTtBQUNBO0FBQ0E7QUFDQTtBQUtPLE1BQU1BLFNBQVMsR0FBRyxnQkFDdkJDLFdBRHVCLEVBRXZCQyxHQUZ1QixFQUd2QkMsWUFIdUIsRUFJdkI7QUFDQSxRQUFNQyxPQUFPLEdBQUdDLGVBQU1DLE9BQU4sQ0FBY0wsV0FBZCxFQUEyQkMsR0FBM0IsRUFBZ0NDLFlBQWhDLENBQWhCOztBQUNBLFFBQU1JLEdBQUcsR0FBRyxNQUFNSCxPQUFsQjtBQUNBLFFBQU1JLElBQUksR0FBRyxNQUFNSCxlQUFNSSxJQUFOLENBQVdGLEdBQVgsRUFBZ0JKLFlBQWhCLENBQW5CO0FBQ0EsU0FBT0ssSUFBUDtBQUNELENBVE0iLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCBXcmVjayBmcm9tICdAaGFwaS93cmVjayc7XG5pbXBvcnQgeyBvcHRpb25zVHlwZSB9IGZyb20gXCIuLi8uLi8uLi8uLi9jb21tb24vdHlwZXMvbm90ZWJvb2tzXCI7XG5cbmV4cG9ydCBjb25zdCByZXF1ZXN0b3IgPSBhc3luYyBmdW5jdGlvbiAoXG4gIHJlcXVlc3RUeXBlOiBzdHJpbmcsXG4gIHVybDogc3RyaW5nLFxuICB3cmVja09wdGlvbnM6IG9wdGlvbnNUeXBlXG4pIHtcbiAgY29uc3QgcHJvbWlzZSA9IFdyZWNrLnJlcXVlc3QocmVxdWVzdFR5cGUsIHVybCwgd3JlY2tPcHRpb25zKTtcbiAgY29uc3QgcmVzID0gYXdhaXQgcHJvbWlzZTtcbiAgY29uc3QgYm9keSA9IGF3YWl0IFdyZWNrLnJlYWQocmVzLCB3cmVja09wdGlvbnMpO1xuICByZXR1cm4gYm9keTtcbn07XG4iXX0=