"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = sqlPlugin;

var _constants = require("../../services/utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function sqlPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.sql = components.clientAction.namespaceFactory();
  const sql = Client.prototype.sql.prototype;
  sql.translateSQL = ca({
    url: {
      fmt: `${_constants.SQL_TRANSLATE_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.translatePPL = ca({
    url: {
      fmt: `${_constants.PPL_TRANSLATE_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.sqlQuery = ca({
    url: {
      fmt: `${_constants.SQL_QUERY_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  }); //default: jdbc

  sql.pplQuery = ca({
    url: {
      fmt: `${_constants.PPL_QUERY_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  }); //default: jdbc

  sql.sqlJson = ca({
    url: {
      fmt: `${_constants.SQL_QUERY_ROUTE}?${_constants.FORMAT_JSON}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.pplJson = ca({
    url: {
      fmt: `${_constants.PPL_QUERY_ROUTE}?${_constants.FORMAT_JSON}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.sqlCsv = ca({
    url: {
      fmt: `${_constants.SQL_QUERY_ROUTE}?${_constants.FORMAT_CSV}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.pplCsv = ca({
    url: {
      fmt: `${_constants.PPL_QUERY_ROUTE}?${_constants.FORMAT_CSV}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.sqlText = ca({
    url: {
      fmt: `${_constants.SQL_QUERY_ROUTE}?${_constants.FORMAT_TEXT}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.pplText = ca({
    url: {
      fmt: `${_constants.PPL_QUERY_ROUTE}?${_constants.FORMAT_TEXT}`
    },
    needBody: true,
    method: 'POST'
  });
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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