"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _constants = require("../utils/constants");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class AlertService {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);

    _defineProperty(this, "getAlerts", async (_context, request, response) => {
      try {
        const {
          detectorType,
          detector_id
        } = request.query;
        let params;

        if (detector_id) {
          params = {
            detector_id
          };
        } else if (detectorType) {
          params = {
            detectorType
          };
        } else {
          throw Error(`Invalid request params: detectorId or detectorType must be specified`);
        }

        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const getAlertsResponse = await callWithRequest(_constants.CLIENT_ALERTS_METHODS.GET_ALERTS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getAlertsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - AlertService - getAlerts:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "acknowledgeAlerts", async (_context, request, response) => {
      try {
        const {
          detector_id
        } = request.params;
        const {
          alerts
        } = request.body;
        const body = {
          alerts: alerts
        };
        const params = {
          body,
          detector_id
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const acknowledgeAlertsResponse = await callWithRequest(_constants.CLIENT_ALERTS_METHODS.ACKNOWLEDGE_ALERTS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: acknowledgeAlertsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - AlertService - acknowledgeAlerts:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    this.osDriver = osDriver;
  }
  /**
   * Calls backend GET Alerts API.
   */


}

exports.default = AlertService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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