"use strict";

require("jest-canvas-mock");

require("@testing-library/jest-dom/extend-expect");

var _react = require("@testing-library/react");

var _enzyme = _interopRequireDefault(require("enzyme"));

var _enzymeAdapterReact = _interopRequireDefault(require("enzyme-adapter-react-16"));

var _useContext = require("./mocks/useContext.mock");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
_enzyme.default.configure({
  adapter: new _enzymeAdapterReact.default()
});

(0, _react.configure)({
  testIdAttribute: 'data-test-subj'
});
jest.mock('@elastic/eui/lib/eui_components/form/form_row/make_id', () => () => 'some_make_id');
jest.mock('@elastic/eui/lib/services/accessibility/html_id_generator', () => ({
  htmlIdGenerator: () => {
    return () => 'some_html_id';
  }
})); // @ts-ignore

window.Worker = function () {
  this.postMessage = () => {}; // @ts-ignore


  this.terminate = () => {};
}; // @ts-ignore


window.URL = {
  createObjectURL: () => {
    return '';
  }
}; // https://github.com/elastic/eui/issues/2530

jest.mock('@elastic/eui/lib/eui_components/icon', () => ({
  EuiIcon: () => 'EuiIconMock',
  __esModule: true,
  IconPropType: require('@elastic/eui/lib/eui_components/icon/icon').IconPropType,
  ICON_TYPES: require('@elastic/eui/lib/eui_components/icon/icon').TYPES,
  ICON_SIZES: require('@elastic/eui/lib/eui_components/icon/icon').SIZES,
  ICON_COLORS: require('@elastic/eui/lib/eui_components/icon/icon').COLORS
}));
/**
 * Moment timezones are not working from jest so here we mock
 * moment.tz.names function
 *
 * Also, format function is mocked to return always the same value so that we can correctly test
 * functions that call this
 */

jest.mock('moment', () => {
  const moment = jest.requireActual('moment'); // Set moment tz mock

  if (!moment.tz) moment.tz = {};

  moment.tz.names = () => ['Pacific/Tahiti'];

  const momentInstance = moment();
  momentInstance.format = jest.fn().mockReturnValue('2023-01-25T10:05');

  function fakeMoment() {
    return momentInstance;
  }

  Object.assign(fakeMoment, moment);
  return fakeMoment;
});
/**
 * Mocks rules view model actor as it is instantiated in the component classes
 * Mocked here so that is applied to all tests
 */

jest.mock('../public/pages/Rules/models/RulesViewModelActor.ts', () => {
  const rulesViewModelActor = jest.requireActual('../public/pages/Rules/models/RulesViewModelActor.ts');
  const rulesViewModelActorMock = { ...rulesViewModelActor,
    getRules: () => Promise.resolve({
      ok: true,
      response: {
        hits: {
          hits: []
        }
      }
    })
  };
  return rulesViewModelActorMock;
});
/**
 * React useContext is mocked to return the mocked services
 * so that this works in all tests
 */

jest.mock('react', () => {
  const ActualReact = jest.requireActual('react');
  return { ...ActualReact,
    useContext: () => _useContext.contextServicesMock
  };
});
/**
 * Mocks the vega view renderer
 */

jest.mock('vega/build-es5/vega.js', () => {
  const vega = jest.requireActual('vega/build-es5/vega.js');
  return { ...vega,
    View: jest.fn().mockReturnValue({
      tooltip: jest.fn(),
      runAsync: jest.fn().mockReturnValue(new Promise(jest.fn()))
    })
  };
});
jest.setTimeout(10000); // in milliseconds
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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