/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.ArchitectSessionContext;
import ca.sqlpower.architect.ArchitectSessionContextImpl;
import ca.sqlpower.architect.CoreUserSettings;
import ca.sqlpower.architect.enterprise.ArchitectClientSideSession;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionContext;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionImpl;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.WelcomeScreen;
import ca.sqlpower.enterprise.AbstractNetworkConflictResolver;
import ca.sqlpower.enterprise.client.ProjectLocation;
import ca.sqlpower.enterprise.client.SPServerInfo;
import ca.sqlpower.enterprise.client.SPServerInfoManager;
import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.SwingUIUserPrompterFactory;
import ca.sqlpower.swingui.dbtree.SQLObjectSelection;
import ca.sqlpower.swingui.event.SessionLifecycleEvent;
import ca.sqlpower.swingui.event.SessionLifecycleListener;
import ca.sqlpower.util.UserPrompterFactory;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.springframework.security.AccessDeniedException;

public class ArchitectSwingSessionContextImpl
implements ArchitectSwingSessionContext,
ClipboardOwner {
    private static final Logger logger = Logger.getLogger(ArchitectSwingSessionContextImpl.class);
    private static final boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private final List<ArchitectFrame> frames = new ArrayList<ArchitectFrame>();
    private final Transferable dummyTransferable = new DummyTransferable();
    CoreUserSettings userSettings;
    private ArchitectSessionContext delegateContext;
    private final Clipboard clipboard = new Clipboard("Internal clipboard");
    private SessionLifecycleListener<ArchitectSession> sessionLifecycleListener = new SessionLifecycleListener<ArchitectSession>(){

        public void sessionClosing(SessionLifecycleEvent<ArchitectSession> e) {
            ArchitectSwingSessionContextImpl.this.getSessions().remove(e.getSource());
            boolean closeSecuritySessions = true;
            for (ArchitectSession architectSession : ArchitectSwingSessionContextImpl.this.getSessions()) {
                if (!architectSession.isEnterpriseSession()) continue;
                closeSecuritySessions = false;
            }
            if (closeSecuritySessions) {
                for (ArchitectClientSideSession architectClientSideSession : ArchitectClientSideSession.getSecuritySessions().values()) {
                    architectClientSideSession.close();
                }
                ArchitectClientSideSession.getSecuritySessions().clear();
            }
            if (ArchitectSwingSessionContextImpl.this.getSessions().isEmpty() && ArchitectSwingSessionContextImpl.this.exitAfterAllSessionsClosed) {
                for (ArchitectFrame architectFrame : ArchitectSwingSessionContextImpl.this.frames) {
                    try {
                        architectFrame.saveSettings();
                    }
                    catch (SQLObjectException ex) {
                        logger.error((Object)"Exception occurred while saving settings", (Throwable)ex);
                    }
                }
                System.exit(0);
            }
        }

        public void sessionOpening(SessionLifecycleEvent<ArchitectSession> e) {
        }
    };
    private SessionLifecycleListener<ArchitectFrame> windowLifecycleListener = null;
    private SessionLifecycleListener<ArchitectSwingSession> externalLifecycleListener = null;
    private boolean exitAfterAllSessionsClosed = false;

    public ArchitectSwingSessionContextImpl() throws SQLObjectException, BackingStoreException {
        this(new ArchitectSessionContextImpl());
    }

    public ArchitectSwingSessionContextImpl(String plIniPath, boolean checkPath) throws SQLObjectException, BackingStoreException {
        this(new ArchitectSessionContextImpl(plIniPath, checkPath));
    }

    public ArchitectSwingSessionContextImpl(DataSourceCollection<JDBCDataSource> dsCollection) throws SQLObjectException, BackingStoreException {
        this(new ArchitectSessionContextImpl(dsCollection));
    }

    private ArchitectSwingSessionContextImpl(ArchitectSessionContextImpl delegate) throws SQLObjectException, BackingStoreException {
        this.delegateContext = delegate;
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        this.userSettings = new CoreUserSettings(this.getPrefs());
        logger.debug((Object)("current motion threshold is: " + System.getProperty("awt.dnd.drag.threshold")));
        System.setProperty("awt.dnd.drag.threshold", "10");
        logger.debug((Object)("new motion threshold is: " + System.getProperty("awt.dnd.drag.threshold")));
        SPSUtils.setMasterIcon((ImageIcon)new ImageIcon(ASUtils.getFrameIconImage()));
        this.clipboard.setContents(this.dummyTransferable, this);
    }

    @Override
    public ArchitectSwingSession createSession(InputStream in) throws SQLObjectException, IOException {
        ArchitectSwingSession session = this.createSessionImpl(Messages.getString("ArchitectSwingSessionContextImpl.projectLoadingDialogTitle"));
        try {
            session.getProjectLoader().load(in, session.getDataSources());
            return session;
        }
        catch (SQLObjectException ex) {
            try {
                session.close();
            }
            catch (Exception e) {
                logger.error((Object)"Session cleanup failed after botched read. Eating this secondary exception:", (Throwable)e);
            }
            throw ex;
        }
        catch (IOException ex) {
            try {
                session.close();
            }
            catch (Exception e) {
                logger.error((Object)"Session cleanup failed after botched read. Eating this secondary exception:", (Throwable)e);
            }
            throw ex;
        }
        catch (Exception ex) {
            try {
                session.close();
            }
            catch (Exception e) {
                logger.error((Object)"Session cleanup failed after botched read. Eating this secondary exception:", (Throwable)e);
            }
            throw new RuntimeException(ex);
        }
    }

    @Override
    public ArchitectSwingSession createSession() throws SQLObjectException {
        return this.createSessionImpl(Messages.getString("ArchitectSwingSessionContextImpl.defaultNewProjectName"));
    }

    public ArchitectSwingSession createServerSession(ProjectLocation projectLocation, boolean autoStartUpdater) throws SQLObjectException {
        ArchitectClientSideSession clientSession = new ArchitectClientSideSession((ArchitectSessionContext)this, projectLocation.getName(), projectLocation);
        final ArchitectSwingSessionImpl swingSession = new ArchitectSwingSessionImpl((ArchitectSwingSessionContext)this, clientSession);
        clientSession.getUpdater().setUserPrompterFactory((UserPrompterFactory)new SwingUIUserPrompterFactory.NonModalSwingUIUserPrompterFactory((JFrame)swingSession.getArchitectFrame()));
        clientSession.getUpdater().addListener(new AbstractNetworkConflictResolver.UpdateListener(){
            boolean loading = true;

            public void preUpdatePerformed(AbstractNetworkConflictResolver resolver) {
                if (this.loading) {
                    swingSession.getUndoManager().setLoading(true);
                }
            }

            public boolean updatePerformed(AbstractNetworkConflictResolver resolver) {
                if (this.loading) {
                    swingSession.getUndoManager().setLoading(false);
                    this.loading = false;
                }
                return false;
            }

            public boolean updateException(AbstractNetworkConflictResolver resolver, Throwable t) {
                if (this.loading) {
                    swingSession.getUndoManager().setLoading(false);
                    this.loading = false;
                }
                return false;
            }

            public void workspaceDeleted() {
                int response = JOptionPane.showConfirmDialog(swingSession.getArchitectFrame(), "This project has been deleted from the server. \nWould you like to save it to a file before it closes?", "Workspace deleted...", 0);
                if (response == 0) {
                    swingSession.saveOrSaveAs(true, false);
                }
                ArchitectSwingSessionContextImpl.this.exitAfterAllSessionsClosed = false;
                swingSession.close();
                ArchitectSwingSessionContextImpl.this.exitAfterAllSessionsClosed = true;
                if (ArchitectSwingSessionContextImpl.this.getSessions().size() == 0) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ArchitectSwingSessionContextImpl.this.createSession();
                                }
                                catch (Exception e) {
                                    throw new RuntimeException("Error occurred when trying to open new project", e);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error occurred when trying to open new project", e);
                    }
                }
            }
        });
        if (autoStartUpdater) {
            clientSession.startUpdaterThread();
        }
        this.getSessions().add(swingSession);
        swingSession.addSessionLifecycleListener(this.sessionLifecycleListener);
        if (this.externalLifecycleListener != null) {
            this.externalLifecycleListener.sessionOpening(new SessionLifecycleEvent((Object)swingSession));
        }
        return swingSession;
    }

    public ArchitectClientSideSession createSecuritySession(final SPServerInfo serverInfo) {
        ArchitectClientSideSession session = null;
        if (ArchitectClientSideSession.getSecuritySessions().get(serverInfo.getServerAddress()) == null) {
            ProjectLocation securityLocation = new ProjectLocation("system", "system", serverInfo);
            try {
                final ArchitectClientSideSession newSecuritySession = new ArchitectClientSideSession((ArchitectSessionContext)this, serverInfo.getServerAddress(), securityLocation);
                newSecuritySession.getUpdater().addListener(new AbstractNetworkConflictResolver.UpdateListener(){

                    public boolean updatePerformed(AbstractNetworkConflictResolver resolver) {
                        return false;
                    }

                    public boolean updateException(AbstractNetworkConflictResolver resolver, Throwable t) {
                        if (t instanceof AccessDeniedException) {
                            return false;
                        }
                        newSecuritySession.close();
                        ArchitectClientSideSession.getSecuritySessions().remove(serverInfo.getServerAddress());
                        String errorMessage = "Error accessing security session.";
                        logger.error((Object)"Error accessing security session.", t);
                        SPSUtils.showExceptionDialogNoReport((Component)((Component)ArchitectSwingSessionContextImpl.this.frames.get(0)), (String)"Error accessing security session.", (Throwable)t);
                        return true;
                    }

                    public void preUpdatePerformed(AbstractNetworkConflictResolver resolver) {
                    }

                    public void workspaceDeleted() {
                    }
                });
                newSecuritySession.startUpdaterThread();
                ArchitectClientSideSession.getSecuritySessions().put(serverInfo.getServerAddress(), newSecuritySession);
                session = newSecuritySession;
            }
            catch (AccessDeniedException e) {
                throw e;
            }
            catch (SQLObjectException e) {
                throw new RuntimeException("Unable to create security session!!!", e);
            }
        } else {
            session = ArchitectClientSideSession.getSecuritySessions().get(serverInfo.getServerAddress());
        }
        return session;
    }

    private ArchitectSwingSession createSessionImpl(String projectName) throws SQLObjectException {
        logger.debug((Object)("About to create a new session for project \"" + projectName + "\""));
        ArchitectSwingSessionImpl session = new ArchitectSwingSessionImpl((ArchitectSwingSessionContext)this, projectName);
        this.getSessions().add(session);
        session.addSessionLifecycleListener(this.sessionLifecycleListener);
        if (this.externalLifecycleListener != null) {
            this.externalLifecycleListener.sessionOpening(new SessionLifecycleEvent((Object)session));
        }
        return session;
    }

    @Override
    public void registerFrame(final ArchitectFrame frame) {
        this.frames.add(frame);
        if (this.frames.size() == 1) {
            frame.addWindowListener(new WindowListener(){

                @Override
                public void windowActivated(WindowEvent e) {
                    ArchitectSwingSessionContextImpl.this.showWelcomeScreen(frame);
                    frame.removeWindowListener(this);
                }

                @Override
                public void windowClosed(WindowEvent e) {
                }

                @Override
                public void windowClosing(WindowEvent e) {
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                }

                @Override
                public void windowIconified(WindowEvent e) {
                }

                @Override
                public void windowOpened(WindowEvent e) {
                }
            });
        }
        if (this.windowLifecycleListener != null) {
            this.windowLifecycleListener.sessionOpening(new SessionLifecycleEvent((Object)frame));
        }
        frame.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                if (ArchitectSwingSessionContextImpl.this.windowLifecycleListener != null) {
                    ArchitectSwingSessionContextImpl.this.frames.remove(frame);
                    ArchitectSwingSessionContextImpl.this.windowLifecycleListener.sessionClosing(new SessionLifecycleEvent((Object)frame));
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
    }

    public void setExternalLifecycleListener(SessionLifecycleListener<ArchitectSwingSession> externalLifecycleListener) {
        this.externalLifecycleListener = externalLifecycleListener;
    }

    public void setWindowLifecycleListener(SessionLifecycleListener<ArchitectFrame> l) {
        this.windowLifecycleListener = l;
    }

    @Override
    public boolean isMacOSX() {
        return MAC_OS_X;
    }

    @Override
    public Preferences getPrefs() {
        return this.delegateContext.getPrefs();
    }

    @Override
    public CoreUserSettings getUserSettings() {
        return this.userSettings;
    }

    @Override
    public Collection<ArchitectSession> getSessions() {
        return this.delegateContext.getSessions();
    }

    private void showWelcomeScreen(Component dialogOwner) {
        if (this.getUserSettings().getSwingSettings().getBoolean("SwingUserSettings.SHOW_WELCOMESCREEN", true)) {
            WelcomeScreen ws = new WelcomeScreen(this);
            ws.showWelcomeDialog(dialogOwner);
        }
    }

    @Override
    public void closeAll() {
        ArrayList<ArchitectSession> doomedSessions = new ArrayList<ArchitectSession>(this.getSessions());
        for (ArchitectSession s : doomedSessions) {
            if (s instanceof ArchitectSwingSession) {
                ((ArchitectSwingSession)s).close();
                continue;
            }
            s.close();
        }
    }

    @Override
    public boolean getExitAfterAllSessionsClosed() {
        return this.exitAfterAllSessionsClosed;
    }

    @Override
    public void setExitAfterAllSessionsClosed(boolean allowExit) {
        this.exitAfterAllSessionsClosed = allowExit;
    }

    @Override
    public List<JDBCDataSource> getConnections() {
        return this.delegateContext.getConnections();
    }

    @Override
    public DataSourceCollection<JDBCDataSource> getPlDotIni() {
        return this.delegateContext.getPlDotIni();
    }

    @Override
    public String getPlDotIniPath() {
        return this.delegateContext.getPlDotIniPath();
    }

    @Override
    public void setPlDotIniPath(String plDotIniPath) {
        this.delegateContext.setPlDotIniPath(plDotIniPath);
    }

    @Override
    public Transferable getClipboardContents() {
        logger.debug((Object)("local clipboard contents are " + this.clipboard.getContents(null)));
        if (this.clipboard.getContents(null) != this.dummyTransferable) {
            logger.debug((Object)"Getting clipboard contents from local clipboard");
            return this.clipboard.getContents(null);
        }
        logger.debug((Object)"Getting clipboard contents from system");
        return Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
    }

    @Override
    public void setClipboardContents(Transferable t) {
        this.clipboard.setContents(t, this);
        logger.debug((Object)"Setting local clipboard contents");
        if (t instanceof SQLObjectSelection) {
            ((SQLObjectSelection)t).setLocal(false);
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(t, this);
        logger.debug((Object)("toolkit pasting to system clipboard " + Toolkit.getDefaultToolkit().getSystemClipboard()));
        if (t instanceof SQLObjectSelection) {
            ((SQLObjectSelection)t).setLocal(true);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.clipboard.setContents(this.dummyTransferable, this);
        logger.debug((Object)"Context lost clipboard ownership");
    }

    @Override
    public SPServerInfoManager getServerManager() {
        return this.delegateContext.getServerManager();
    }

    private class DummyTransferable
    implements Transferable {
        private DummyTransferable() {
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return null;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return false;
        }
    }
}

