/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.object.AbstractPoolingSPListener;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.sqlobject.SQLObject;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SQLObjectComboBoxModel
implements ComboBoxModel {
    private final SQLObject parent;
    private final Class<? extends SQLObject> childType;
    private SQLObject selectedItem;
    private final List<ListDataListener> listDataListeners = new ArrayList<ListDataListener>();
    private SPListener childEventHandler = new AbstractPoolingSPListener(){

        public void childAddedImpl(SPChildEvent e) {
            SQLObjectComboBoxModel.this.fireListDataEvent(1, e.getIndex(), e.getIndex());
        }

        public void childRemovedImpl(SPChildEvent e) {
            int changedIndex = e.getIndex();
            if (SQLObjectComboBoxModel.this.selectedItem == e.getChild()) {
                SQLObjectComboBoxModel.this.setSelectedItem(null);
            }
            SQLObjectComboBoxModel.this.fireListDataEvent(2, changedIndex, changedIndex);
        }
    };

    public SQLObjectComboBoxModel(SQLObject parent, Class<? extends SQLObject> childType) {
        this.parent = parent;
        this.childType = childType;
        if (!parent.allowsChildren()) {
            throw new IllegalArgumentException("That parent object doesn't allow children");
        }
        parent.addSPListener(this.childEventHandler);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedItem = (SQLObject)anItem;
    }

    @Override
    public Object getElementAt(int index) {
        if (index < 0 || index > this.parent.getChildren(this.childType).size()) {
            return null;
        }
        return this.parent.getChildren(this.childType).get(index);
    }

    @Override
    public int getSize() {
        return this.parent.getChildren(this.childType).size();
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listDataListeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listDataListeners.remove(l);
    }

    private void fireListDataEvent(int type, int index0, int index1) {
        ListDataEvent e = new ListDataEvent(this, type, index0, index1);
        for (int i = this.listDataListeners.size() - 1; i >= 0; --i) {
            this.listDataListeners.get(i).contentsChanged(e);
        }
    }
}

