/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.PlayPenCoordinate;
import ca.sqlpower.architect.swingui.olap.BasicDimensionPaneUI;
import ca.sqlpower.architect.swingui.olap.DimensionEditPanel;
import ca.sqlpower.architect.swingui.olap.HierarchyEditPanel;
import ca.sqlpower.architect.swingui.olap.LevelEditPanel;
import ca.sqlpower.architect.swingui.olap.OLAPPane;
import ca.sqlpower.architect.swingui.olap.PaneSection;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.util.TransactionEvent;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class DimensionPane
extends OLAPPane<MondrianModel.Dimension, OLAPObject> {
    private static final Logger logger = Logger.getLogger(DimensionPane.class);
    public static final List<Class<? extends SPObject>> allowedChildTypes = PlayPenComponent.allowedChildTypes;
    private final HierarchyWatcher hierarchyWatcher = new HierarchyWatcher();

    public DimensionPane(DimensionPane copyMe, PlayPenContentPane parent) {
        super(copyMe, parent);
        this.updateUI();
    }

    @Constructor
    public DimensionPane(@ConstructorParameter(propertyName="model") MondrianModel.Dimension m, @ConstructorParameter(propertyName="parent") PlayPenContentPane parent) {
        super(m.getName(), parent);
        this.model = m;
        for (MondrianModel.Hierarchy h : ((MondrianModel.Dimension)((Object)this.model)).getHierarchies()) {
            this.sections.add(new HierarchySection(h));
        }
        ((MondrianModel.Dimension)((Object)this.model)).addSPListener(this.hierarchyWatcher);
        this.setRounded(true);
        this.updateUI();
    }

    @Override
    protected List<OLAPObject> getItems() {
        ArrayList<OLAPObject> oos = new ArrayList<OLAPObject>();
        for (MondrianModel.Hierarchy h : ((MondrianModel.Dimension)((Object)this.model)).getHierarchies()) {
            oos.add(h);
            oos.addAll(h.getLevels());
        }
        return oos;
    }

    public void updateUI() {
        BasicDimensionPaneUI ui = BasicDimensionPaneUI.createUI(this);
        ui.installUI(this);
        this.setUI(ui);
    }

    public String toString() {
        return "DimensionPane: " + this.model;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DataEntryPanel createEditDialog(PlayPenCoordinate<MondrianModel.Dimension, OLAPObject> coord) throws SQLObjectException {
        void var2_6;
        if (coord.getIndex() == -1) {
            DimensionEditPanel dimensionEditPanel = new DimensionEditPanel((MondrianModel.Dimension)((Object)this.model));
            return var2_6;
        } else if (coord.getIndex() == -3) {
            if (!(coord.getSection() instanceof HierarchySection)) throw new IllegalArgumentException("Edit dialog for type " + coord.getSection().getClass() + " cannot be created!");
            HierarchyEditPanel hierarchyEditPanel = new HierarchyEditPanel(((HierarchySection)coord.getSection()).getHierarchy());
            return var2_6;
        } else {
            if (coord.getIndex() <= -1) return var2_6;
            if (!(coord.getItem() instanceof MondrianModel.Level)) throw new IllegalArgumentException("Edit dialog for type " + ((Object)((Object)coord.getItem())).getClass() + " cannot be created!");
            LevelEditPanel levelEditPanel = new LevelEditPanel((MondrianModel.Level)coord.getItem());
        }
        return var2_6;
    }

    @Override
    protected List<OLAPObject> filterDroppableItems(List<OLAPObject> items) {
        ArrayList<OLAPObject> filtered = new ArrayList<OLAPObject>();
        for (OLAPObject item : items) {
            if (item instanceof MondrianModel.Level) {
                filtered.add((MondrianModel.Level)item);
                continue;
            }
            if (!(item instanceof MondrianModel.Hierarchy)) continue;
            filtered.add((MondrianModel.Hierarchy)item);
        }
        return filtered;
    }

    public HierarchySection findSection(MondrianModel.Hierarchy hierarchy) {
        for (PaneSection hs : this.sections) {
            if (!(hs instanceof HierarchySection) || ((HierarchySection)hs).getHierarchy() != hierarchy) continue;
            return (HierarchySection)hs;
        }
        return null;
    }

    @NonBound
    public List<MondrianModel.Level> getSelectedLevels() {
        ArrayList<MondrianModel.Level> selectedItems = new ArrayList<MondrianModel.Level>();
        for (int i = 0; i < this.getItems().size(); ++i) {
            if (!this.isItemSelected(i) || !(this.getItems().get(i) instanceof MondrianModel.Level)) continue;
            selectedItems.add((MondrianModel.Level)this.getItems().get(i));
        }
        return selectedItems;
    }

    @Override
    @NonBound
    protected List<OLAPObject> getItemsFromCoordinates(List<PlayPenCoordinate<? extends OLAPObject, ? extends OLAPObject>> coords) {
        ArrayList<OLAPObject> items = new ArrayList<OLAPObject>();
        for (PlayPenCoordinate<? extends OLAPObject, ? extends OLAPObject> coord : coords) {
            if (coord.getIndex() == -3) {
                if (coord.getSection() instanceof HierarchySection) {
                    items.add(((HierarchySection)coord.getSection()).getHierarchy());
                    continue;
                }
                JOptionPane.showMessageDialog(null, coord.getSection() + " is not a Hierarchy Section.", "Error", 0);
                continue;
            }
            if (coord.getIndex() < 0) continue;
            if (coord.getItem() == null) {
                throw new NullPointerException("Found a coordinate with nonnegative item index but null item: " + coord);
            }
            items.add(coord.getItem());
        }
        return items;
    }

    @Override
    protected void transferInvalidIndexItem(OLAPObject item, PaneSection<OLAPObject> insertSection) {
        try {
            item.getParent().removeChild((SPObject)item);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (item instanceof MondrianModel.Level) {
            if (insertSection == null || this.sections.isEmpty()) {
                MondrianModel.Hierarchy hier = new MondrianModel.Hierarchy();
                hier.setHasAll(true);
                ((MondrianModel.Dimension)((Object)this.getModel())).addChild((SPObject)hier);
                insertSection = (PaneSection)this.sections.get(0);
            }
            insertSection.addItem((OLAPObject)item);
        } else {
            ((MondrianModel.Dimension)((Object)this.getModel())).addChild((SPObject)item);
        }
    }

    @Override
    public void pasteData(Transferable t) {
    }

    public class HierarchySection
    implements PaneSection<MondrianModel.Level> {
        private final MondrianModel.Hierarchy hierarchy;

        HierarchySection(MondrianModel.Hierarchy hierarchy) {
            this.hierarchy = hierarchy;
        }

        @Override
        public List<MondrianModel.Level> getItems() {
            return this.hierarchy.getLevels();
        }

        @Override
        public String getTitle() {
            if (this.hierarchy.getName() != null) {
                return this.hierarchy.getName();
            }
            if (this.hierarchy.getParent() == null) {
                return "(Unnamed Hierarchy with no parent dimension)";
            }
            return this.hierarchy.getParent().getName();
        }

        public MondrianModel.Hierarchy getHierarchy() {
            return this.hierarchy;
        }

        @Override
        public Class<MondrianModel.Level> getItemType() {
            return MondrianModel.Level.class;
        }

        @Override
        public void addItem(int idx, MondrianModel.Level item) {
            this.hierarchy.addLevel(idx, item);
        }

        @Override
        public void addItem(MondrianModel.Level item) {
            this.addItem(this.getItems().size(), item);
        }
    }

    private class HierarchyWatcher
    implements SPListener {
        private HierarchyWatcher() {
        }

        public void childAdded(SPChildEvent e) {
            MondrianModel.Hierarchy hierarchy = (MondrianModel.Hierarchy)e.getChild();
            DimensionPane.this.sections.add(e.getIndex(), new HierarchySection(hierarchy));
            DimensionPane.this.revalidate();
        }

        public void childRemoved(SPChildEvent e) {
            DimensionPane.this.sections.remove(e.getIndex());
            DimensionPane.this.revalidate();
        }

        public void propertyChanged(PropertyChangeEvent evt) {
        }

        public void transactionEnded(TransactionEvent e) {
        }

        public void transactionRollback(TransactionEvent e) {
        }

        public void transactionStarted(TransactionEvent e) {
        }
    }
}

