/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap.action;

import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import ca.sqlpower.architect.swingui.olap.OLAPPane;
import ca.sqlpower.swingui.CursorManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public abstract class CreateUsageAction<P1 extends OLAPPane<?, ?>, P2 extends OLAPPane<?, ?>>
extends AbstractArchitectAction
implements ActionListener,
SelectionListener,
PlayPen.CancelableListener {
    private static final Logger logger = Logger.getLogger(CreateUsageAction.class);
    private CursorManager cursorManager;
    private final Class<P1> pane1Class;
    private final Class<P2> pane2Class;
    private P1 pane1;
    private P2 pane2;
    protected boolean active;

    public CreateUsageAction(ArchitectSwingSession session, PlayPen pp, Class<P1> pane1Class, Class<P2> pane2Class, String name, Icon icon) {
        super(session, pp, "New " + name + "...", "Create a new " + name, icon);
        this.pane1Class = pane1Class;
        this.pane2Class = pane2Class;
        this.cursorManager = this.getPlaypen().getCursorManager();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.active) {
            logger.debug((Object)">>>>>> Adding to selectable listeners, preparing to start the creation.");
            this.getPlaypen().fireCancel();
            this.getPlaypen().selectNone();
            this.getPlaypen().addSelectionListener(this);
            this.getPlaypen().addCancelableListener(this);
            this.cursorManager.placeModeStarted();
            this.pane1 = null;
            this.pane2 = null;
            this.active = true;
        }
    }

    @Override
    public void itemDeselected(SelectionEvent e) {
        logger.debug((Object)">>>>>> Item deselected (ignoring).");
    }

    @Override
    public void itemSelected(SelectionEvent e) {
        logger.debug((Object)">>>>>> Item selected.");
        Selectable s = e.getSelectableSource();
        if (!s.isSelected()) {
            return;
        }
        if (this.pane1Class.isAssignableFrom(s.getClass()) && this.pane1 == null) {
            logger.debug((Object)">>>>>> First selection");
            this.pane1 = (OLAPPane)this.pane1Class.cast(s);
        } else if (this.pane2Class.isAssignableFrom(s.getClass()) && this.pane2 == null) {
            logger.debug((Object)">>>>>> Second selection");
            this.pane2 = (OLAPPane)this.pane2Class.cast(s);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The user clicked on an irrelevant component: " + s));
                logger.debug((Object)">>>>>> Wrong component selected, supposed to discard all data.");
            }
            this.reset();
        }
        if (this.pane2 != null && this.pane1 != null) {
            PlayPenContentPane cp = this.getPlaypen().getContentPane();
            try {
                cp.begin("Creating usage");
                this.createUsage(this.pane1, this.pane2);
                cp.commit();
            }
            catch (Throwable ex) {
                cp.rollback("Exception occurred while creating usage: " + ex.toString());
                throw new RuntimeException(ex);
            }
            finally {
                this.reset();
            }
        }
    }

    protected abstract void createUsage(P1 var1, P2 var2);

    @Override
    public void cancel() {
        this.reset();
    }

    private void reset() {
        logger.debug((Object)">>>>>> Resetting");
        this.pane1 = null;
        this.pane2 = null;
        this.cursorManager.placeModeFinished();
        this.active = false;
        this.getPlaypen().removeSelectionListener(this);
        this.getPlaypen().removeCancelableListener(this);
    }
}

