/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.query;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLDatabaseMapping;
import ca.sqlpower.swingui.SwingWorkerRegistry;
import ca.sqlpower.swingui.query.SQLQueryUIComponents;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class QueryFrame
extends JFrame {
    private static Logger logger = Logger.getLogger(QueryFrame.class);
    private final DBTree dbTree;
    private JComponent queryPanel;

    public QueryFrame(ArchitectSwingSession session, String title) {
        this(session, title, null, null);
    }

    public QueryFrame(ArchitectSwingSession session, String title, SQLDatabase db, String initialSQL) {
        super(title);
        this.setIconImage(ASUtils.getFrameIconImage());
        this.setDefaultCloseOperation(0);
        this.setSize(900, 650);
        this.dbTree = new DBTree(session);
        TreeModel model = session.getDBTree().getModel();
        this.dbTree.setModel(model);
        this.queryPanel = SQLQueryUIComponents.createQueryPanel((SwingWorkerRegistry)session, session.getDataSources(), (SQLDatabaseMapping)session, (Window)this, (SQLDatabase)db, (String)initialSQL);
        this.queryPanel.setMinimumSize(new Dimension(100, 100));
        this.buildUI(session);
    }

    private void buildUI(ArchitectSwingSession session) {
        JSplitPane querySplitPane = new JSplitPane(1);
        querySplitPane.add((Component)new JScrollPane(this.dbTree), "left");
        querySplitPane.add((Component)this.queryPanel, "right");
        querySplitPane.setDividerLocation(130);
        this.setLayout(new BorderLayout());
        this.add((Component)querySplitPane, "Center");
    }
}

