/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.DBConnectionSpec;
import ca.sqlpower.sql.SqlTypeConverter;
import ca.sqlpower.sql.XMLFileDBCSSource;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class DataMover {
    private static final Logger logger = Logger.getLogger(DataMover.class);
    protected boolean debug = false;
    protected String lastSqlString;
    protected Connection srcCon;
    protected Connection dstCon;
    protected boolean creatingDestinationTable;
    protected boolean truncatingDestinationTable;

    public DataMover(Connection dest, Connection source) throws SQLException {
        this.srcCon = source;
        this.dstCon = dest;
    }

    public void copyTable(String tableName) throws SQLException {
        String destTable = tableName.substring(tableName.lastIndexOf(46) + 1);
        this.copyTable(destTable, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyTable(String destTableName, String sourceTableName) throws SQLException {
        Statement srcStmt = null;
        Statement tmpStmt = null;
        Statement dstStmt = null;
        ResultSet srcRS = null;
        ResultSetMetaData srcRSMD = null;
        long startTime = System.currentTimeMillis();
        int numRows = 0;
        try {
            srcStmt = this.srcCon.createStatement();
            this.lastSqlString = "select * from " + sourceTableName;
            srcRS = srcStmt.executeQuery(this.lastSqlString);
            srcRSMD = srcRS.getMetaData();
            if (this.debug) {
                logger.debug((Object)this.summarizeResultSetMetaData(srcRSMD));
            }
            this.dstCon.setAutoCommit(false);
            if (this.creatingDestinationTable) {
                try {
                    tmpStmt = this.dstCon.createStatement();
                    this.lastSqlString = "SELECT 1 FROM " + destTableName;
                    tmpStmt.executeQuery(this.lastSqlString);
                }
                catch (SQLException e) {
                    this.createDestinationTable(srcRSMD, destTableName);
                    this.dstCon.commit();
                    logger.debug((Object)("Created destination table " + destTableName));
                }
                finally {
                    tmpStmt.close();
                    tmpStmt = null;
                }
            }
            if (this.truncatingDestinationTable) {
                tmpStmt = this.dstCon.createStatement();
                this.lastSqlString = "DELETE FROM " + destTableName;
                int count = tmpStmt.executeUpdate(this.lastSqlString);
                logger.debug((Object)("Deleted " + count + " rows from destination table"));
                tmpStmt.close();
                tmpStmt = null;
            }
            this.lastSqlString = this.generateInsertStatement(srcRSMD, destTableName);
            dstStmt = this.dstCon.prepareStatement(this.lastSqlString);
            int numberOfColumns = srcRSMD.getColumnCount();
            while (srcRS.next()) {
                if (this.debug) {
                    logger.debug((Object)("Row " + numRows));
                }
                for (int col = 1; col <= numberOfColumns; ++col) {
                    if (this.debug) {
                        logger.debug((Object)(srcRS.getMetaData().getColumnName(col) + ":" + srcRS.getObject(col) + "(type=" + srcRSMD.getColumnType(col) + ")" + srcRS.getObject(col)));
                    }
                    Object object = null;
                    if (srcRS.getObject(col) != null) {
                        object = srcRS.getObject(col).getClass() == BigDecimal.class ? Double.valueOf(((BigDecimal)srcRS.getObject(col)).doubleValue()) : srcRS.getObject(col);
                    }
                    dstStmt.setObject(col, object, srcRSMD.getColumnType(col));
                }
                dstStmt.executeUpdate();
                ++numRows;
            }
            this.dstCon.commit();
            logger.debug((Object)"Committed transaction");
        }
        catch (SQLException e) {
            try {
                this.dstCon.rollback();
            }
            catch (Exception e2) {
                logger.error((Object)"Roll back on error failed", (Throwable)e2);
            }
            throw new RuntimeException("Prepared insert statement failed at row " + numRows + ":\n" + this.lastSqlString, e);
        }
        finally {
            if (srcRS != null) {
                srcRS.close();
            }
            if (srcStmt != null) {
                srcStmt.close();
            }
            if (dstStmt != null) {
                dstStmt.close();
            }
            if (tmpStmt != null) {
                tmpStmt.close();
            }
        }
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        logger.debug((Object)(numRows + " rows copied in " + elapsedTime + " ms. (" + (double)numRows / (double)elapsedTime * 1000.0 + " rows/sec)"));
        return numRows;
    }

    protected String summarizeResultSetMetaData(ResultSetMetaData rsmd) throws SQLException {
        StringBuffer summary = new StringBuffer(200);
        int numberOfColumns = rsmd.getColumnCount();
        summary.append("Table ").append(rsmd.getTableName(1)).append("\n");
        for (int col = 1; col <= numberOfColumns; ++col) {
            summary.append("Column ").append(col).append(": ");
            summary.append(rsmd.getColumnName(col));
            summary.append(" JDBC datatype ").append(rsmd.getColumnType(col));
            summary.append(" (").append(rsmd.getColumnClassName(col)).append(")");
            summary.append(rsmd.isNullable(col) == 1 ? "" : " NOT NULL");
            summary.append("\n");
        }
        return summary.toString();
    }

    protected String generateInsertStatement(ResultSetMetaData rsmd, String destTable) throws SQLException {
        int col;
        StringBuffer sql = new StringBuffer(200);
        int numberOfColumns = rsmd.getColumnCount();
        sql.append("INSERT INTO ").append(destTable).append(" (");
        for (col = 1; col <= numberOfColumns; ++col) {
            sql.append(rsmd.getColumnName(col));
            if (col == numberOfColumns) continue;
            sql.append(", ");
        }
        sql.append(") VALUES (");
        for (col = 1; col <= numberOfColumns; ++col) {
            sql.append("?");
            if (col == numberOfColumns) continue;
            sql.append(", ");
        }
        sql.append(")");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDestinationTable(ResultSetMetaData rsmd, String destTable) throws SQLException {
        SqlTypeConverter tc = SqlTypeConverter.getInstance(this.dstCon);
        StringBuffer sql = new StringBuffer(200);
        int numberOfColumns = rsmd.getColumnCount();
        sql.append("CREATE TABLE ").append(destTable).append(" (\n");
        for (int col = 1; col <= numberOfColumns; ++col) {
            sql.append(rsmd.getColumnName(col));
            sql.append(" ").append(tc.convertType(rsmd.getColumnType(col), rsmd.getPrecision(col), rsmd.getScale(col)));
            sql.append(rsmd.isNullable(col) == 1 ? " NULL" : " NOT NULL");
            if (col == numberOfColumns) continue;
            sql.append(",\n");
        }
        sql.append(")");
        Statement stmt = null;
        try {
            stmt = this.dstCon.createStatement();
            this.lastSqlString = sql.toString();
            stmt.executeUpdate(this.lastSqlString);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public String getLastSqlString() {
        return this.lastSqlString;
    }

    private void setLastSqlString(String argLastSqlString) {
        throw new UnsupportedOperationException();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean argDebug) {
        this.debug = argDebug;
    }

    private Connection getSrcCon() {
        return this.srcCon;
    }

    private void setSrcCon(Connection argSrcCon) {
        this.srcCon = argSrcCon;
    }

    private Connection getDstCon() {
        return this.dstCon;
    }

    private void setDstCon(Connection argDstCon) {
        this.dstCon = argDstCon;
    }

    public boolean isCreatingDestinationTable() {
        return this.creatingDestinationTable;
    }

    public void setCreatingDestinationTable(boolean argCreatingDestinationTable) {
        this.creatingDestinationTable = argCreatingDestinationTable;
    }

    public boolean isTruncatingDestinationTable() {
        return this.truncatingDestinationTable;
    }

    public void setTruncatingDestinationTable(boolean argTruncatingDestinationTable) {
        this.truncatingDestinationTable = argTruncatingDestinationTable;
    }

    public static void main(String[] args) throws Exception {
        block5: {
            DataMover mover = null;
            try {
                String dbxml = "databases.xml";
                if (args.length != 3) {
                    System.out.println("Usage: java ca.sqlpower.sql.DataMover source-database-name\n        source-table-name dest-database-name");
                    return;
                }
                String srcName = args[0];
                String srcTableName = args[1];
                String dstName = args[2];
                XMLFileDBCSSource xmlSource = new XMLFileDBCSSource(dbxml);
                List dbcsList = xmlSource.getDBCSList();
                DBConnectionSpec srcDbcs = DBConnectionSpec.searchListForName(dbcsList, srcName);
                if (srcDbcs == null) {
                    System.err.println("No database definition '" + srcName + "' in " + dbxml + ".");
                    return;
                }
                DBConnectionSpec dstDbcs = DBConnectionSpec.searchListForName(dbcsList, dstName);
                if (dstDbcs == null) {
                    System.err.println("No database definition '" + dstName + "' in " + dbxml + ".");
                    return;
                }
                String srcDbclass = srcDbcs.getDriverClass();
                String srcDburl = srcDbcs.getUrl();
                String srcDbuser = srcDbcs.getUser();
                String srcDbpass = srcDbcs.getPass();
                String dstDbclass = dstDbcs.getDriverClass();
                String dstDburl = dstDbcs.getUrl();
                String dstDbuser = dstDbcs.getUser();
                String dstDbpass = dstDbcs.getPass();
                Class.forName(srcDbclass, true, DataMover.class.getClassLoader()).newInstance();
                Class.forName(dstDbclass, true, DataMover.class.getClassLoader()).newInstance();
                Connection srcCon = DriverManager.getConnection(srcDburl, srcDbuser, srcDbpass);
                Connection dstCon = DriverManager.getConnection(dstDburl, dstDbuser, dstDbpass);
                mover = new DataMover(dstCon, srcCon);
                mover.setCreatingDestinationTable(true);
                mover.setTruncatingDestinationTable(true);
                mover.copyTable(srcTableName);
                srcCon.close();
                dstCon.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (mover == null) break block5;
                System.out.println("Offending SQL Statement:\n" + mover.getLastSqlString());
            }
        }
    }
}

