/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql.jdbcwrapper;

import ca.sqlpower.sql.CachedRowSet;
import ca.sqlpower.sql.RowFilter;
import ca.sqlpower.sql.SQL;
import ca.sqlpower.sql.jdbcwrapper.CacheKey;
import ca.sqlpower.sql.jdbcwrapper.ConnectionDecorator;
import ca.sqlpower.sql.jdbcwrapper.DatabaseMetaDataDecorator;
import ca.sqlpower.sql.jdbcwrapper.IndexedCachedRowSet;
import ca.sqlpower.sql.jdbcwrapper.MetaDataCache;
import ca.sqlpower.sql.jdbcwrapper.OracleResultSetDecorator;
import ca.sqlpower.sql.jdbcwrapper.OracleStatementDecorator;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class OracleDatabaseMetaDataDecorator
extends DatabaseMetaDataDecorator {
    private static final Logger logger = Logger.getLogger(OracleDatabaseMetaDataDecorator.class);
    private boolean hidingRecycleBinTables = true;
    private boolean hidingSYSIOTOVERTables = true;
    private static final int DREADED_ORACLE_ERROR_CODE_1722 = 1722;
    private static final String ORACLE_1722_MESSAGE = "Encountered Oracle error ORA-1722. This normally means that you are using the Oracle 10 driver with Oracle 8. Please check your driver settings.";
    private static final int DREADED_ORACLE_ERROR_CODE_1031 = 1031;
    private static final String ORACLE_1031_MESSAGE = "Encountered Oracle error ORA-1031. This normally means that you are accessing Indices without having the 'analyze any' permission.";
    private static final MetaDataCache<CacheKey, CachedRowSet> importedAndExportedKeysCache = new MetaDataCache();
    private static final MetaDataCache<CacheKey, IndexedCachedRowSet> columnsCache = new MetaDataCache();

    public OracleDatabaseMetaDataDecorator(DatabaseMetaData delegate, ConnectionDecorator connectionDecorator) {
        super(delegate, connectionDecorator);
        logger.debug((Object)"Created new OracleDatabaseMetaDataDecorator");
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        try {
            return this.wrap(super.getTypeInfo());
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1722) {
                SQLException newE = new SQLException(ORACLE_1722_MESSAGE);
                newE.setNextException(e);
                throw newE;
            }
            throw e;
        }
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getConnection().createStatement();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT NULL AS table_cat,\n");
            sql.append("       i.owner AS table_schem,\n");
            sql.append("       i.table_name,\n");
            sql.append("       DECODE(i.uniqueness, 'UNIQUE', 0, 1) AS non_unique,\n");
            sql.append("       NULL AS index_qualifier,\n");
            sql.append("       i.index_name,\n");
            sql.append("       1 AS type,\n");
            sql.append("       c.column_position AS ordinal_position,\n");
            sql.append("       c.column_name,\n");
            sql.append("       NULL AS asc_or_desc,\n");
            sql.append("       i.distinct_keys AS cardinality,\n");
            sql.append("       i.leaf_blocks AS pages,\n");
            sql.append("       NULL AS filter_condition\n");
            sql.append("FROM all_indexes i, all_ind_columns c\n");
            sql.append("WHERE i.table_name = ").append(SQL.quote(table)).append("\n");
            sql.append("  AND i.owner = ").append(SQL.quote(schema)).append("\n");
            sql.append("  AND i.index_name = c.index_name\n");
            sql.append("  AND i.table_owner = c.table_owner\n");
            sql.append("  AND i.table_name = c.table_name\n");
            sql.append("  AND i.owner = c.index_owner\n");
            sql.append("ORDER BY non_unique, type, index_name, ordinal_position");
            rs = stmt.executeQuery(sql.toString());
            CachedRowSet crs = new CachedRowSet();
            crs.populate(rs, null, "SPG_INDEX_TYPE");
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            Map<Object, Object> indexTypes = new HashMap();
            indexTypes = this.getIndexType(table);
            while (crs.next()) {
                crs.updateShort(7, (short)Short.valueOf(crs.getString(7)));
                if (crs.getLong(4) == 0L) {
                    crs.updateBoolean(4, false);
                } else if (crs.getLong(4) == 1L) {
                    crs.updateBoolean(4, true);
                }
                if (crs.getString(6) == null || indexTypes.get(crs.getString(6)) == null) continue;
                logger.debug((Object)("crs.getString(6) is returning " + crs.getString(6)));
                logger.debug((Object)("Setting index type to " + (String)indexTypes.get(crs.getString(6))));
                logger.debug((Object)("JDBC Type?: " + crs.getShort(7)));
                if (((String)indexTypes.get(crs.getString(6))).toUpperCase().equals("FUNCTION-BASED NORMAL")) {
                    crs.updateString("SPG_INDEX_TYPE", "FUNCTION-BASED");
                    continue;
                }
                if (((String)indexTypes.get(crs.getString(6))).toUpperCase().equals("NORMAL")) {
                    crs.updateString("SPG_INDEX_TYPE", "BTREE");
                    continue;
                }
                crs.updateString("SPG_INDEX_TYPE", ((String)indexTypes.get(crs.getString(6))).toUpperCase());
            }
            crs.beforeFirst();
            return crs;
        }
        catch (SQLException e) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"Failed to close result set! Squishing this exception: ", (Throwable)ex);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"Failed to close statement! Squishing this exception: ", (Throwable)ex);
                }
            }
            if (e.getErrorCode() == 1031) {
                SQLException newE = new SQLException(ORACLE_1031_MESSAGE);
                newE.setNextException(e);
                throw newE;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ResultSet rs = null;
        CachedRowSet crs = new CachedRowSet();
        try {
            rs = super.getTables(catalog, schemaPattern, tableNamePattern, types);
            if (this.hidingRecycleBinTables || this.hidingSYSIOTOVERTables) {
                RowFilter noSpecialTablesFilter = null;
                noSpecialTablesFilter = new RowFilter(){

                    @Override
                    public boolean acceptsRow(Object[] row) {
                        Boolean noRecycleBinResult = true;
                        Boolean noSYSIOTOVERResult = true;
                        String tableName = (String)row[2];
                        if (OracleDatabaseMetaDataDecorator.this.hidingRecycleBinTables) {
                            noRecycleBinResult = !tableName.startsWith("BIN$");
                        }
                        if (OracleDatabaseMetaDataDecorator.this.hidingSYSIOTOVERTables) {
                            noSYSIOTOVERResult = !tableName.startsWith("SYS_IOT_OVER_");
                        }
                        return noRecycleBinResult != false && noSYSIOTOVERResult != false;
                    }
                };
                crs.populate(rs, noSpecialTablesFilter);
            } else {
                crs.populate(rs);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getIndexType(String tableName) throws SQLException {
        HashMap<String, String> indexTypes = new HashMap<String, String>();
        Statement stmt = null;
        ResultSet rs = null;
        String type = "";
        String name = "";
        try {
            stmt = this.getConnection().createStatement();
            String sql = "SELECT INDEX_NAME, INDEX_TYPE FROM user_indexes WHERE TABLE_NAME=" + SQL.quote(tableName);
            logger.debug((Object)("SQL statement was " + sql));
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                name = rs.getString("INDEX_NAME");
                type = rs.getString("INDEX_TYPE");
                indexTypes.put(name, type);
            }
            HashMap<String, String> hashMap = indexTypes;
            return hashMap;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    logger.warn((Object)"Failed to close result set. Squishing this exception: ", (Throwable)ex);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    logger.warn((Object)"Failed to close statement. Squishing this exception: ", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getImportedKeys(String catalog, final String schema, final String table) throws SQLException {
        CacheKey cacheKey = new CacheKey(this.getConnection().getMetaData(), catalog, schema);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getConnection().createStatement();
            StringBuilder sql = new StringBuilder();
            CachedRowSet cachedResult = this.getCachedResult(importedAndExportedKeysCache, cacheKey);
            if (cachedResult == null) {
                sql.append("SELECT NULL AS pktable_cat,\n");
                sql.append("       p.owner as pktable_schem,\n");
                sql.append("       p.table_name as pktable_name,\n");
                sql.append("       pc.column_name as pkcolumn_name,\n");
                sql.append("       NULL as fktable_cat,\n");
                sql.append("       f.owner as fktable_schem,\n");
                sql.append("       f.table_name as fktable_name,\n");
                sql.append("       fc.column_name as fkcolumn_name,\n");
                sql.append("       fc.position as key_seq,\n");
                sql.append("       NULL as update_rule,\n");
                sql.append("       decode (f.delete_rule, 'CASCADE', 0, 'SET NULL', 2, 1) as delete_rule,\n");
                sql.append("       f.constraint_name as fk_name,\n");
                sql.append("       p.constraint_name as pk_name,\n");
                sql.append("       decode(f.deferrable, 'DEFERRABLE', 5 ,'NOT DEFERRABLE', 7, 'DEFERRED', 6) deferrability\n");
                sql.append("FROM all_cons_columns pc, all_constraints p,\n");
                sql.append("     all_cons_columns fc, all_constraints f\n");
                sql.append("WHERE 1 = 1\n");
                if (cacheType.get() == null || ((DatabaseMetaDataDecorator.CacheType)((Object)cacheType.get())).equals((Object)DatabaseMetaDataDecorator.CacheType.NO_CACHE)) {
                    sql.append("\t  AND f.table_name = ").append(SQL.quote(table)).append("\n");
                    if (schema != null) {
                        sql.append("      AND f.owner = ").append(SQL.quote(schema)).append("\n");
                    }
                }
                sql.append("      AND f.constraint_type = 'R'\n");
                sql.append("      AND p.owner = f.r_owner\n");
                sql.append("      AND p.constraint_name = f.r_constraint_name\n");
                sql.append("      AND p.constraint_type in ('P', 'U')\n");
                sql.append("      AND pc.owner = p.owner\n");
                sql.append("      AND pc.constraint_name = p.constraint_name\n");
                sql.append("      AND pc.table_name = p.table_name\n");
                sql.append("      AND fc.owner = f.owner\n");
                sql.append("      AND fc.constraint_name = f.constraint_name\n");
                sql.append("      AND fc.table_name = f.table_name\n");
                sql.append("      AND fc.position = pc.position\n");
                sql.append("ORDER BY pktable_schem, pktable_name, key_seq");
                logger.debug((Object)("getImportedKeys() sql statement was: " + sql.toString()));
                rs = stmt.executeQuery(sql.toString());
                CachedRowSet result = new CachedRowSet();
                result.populate(rs);
                if (cacheType.get() == null || ((DatabaseMetaDataDecorator.CacheType)((Object)cacheType.get())).equals((Object)DatabaseMetaDataDecorator.CacheType.NO_CACHE)) {
                    CachedRowSet cachedRowSet = result;
                    return cachedRowSet;
                }
                this.putCachedResult(importedAndExportedKeysCache, cacheKey, result);
                cachedResult = result;
            }
            CachedRowSet crs = new CachedRowSet();
            RowFilter filter = new RowFilter(){

                @Override
                public boolean acceptsRow(Object[] row) {
                    boolean result = schema != null ? schema.equals(row[5]) && table.equals(row[6]) : table.equals(row[6]);
                    return result;
                }
            };
            CachedRowSet cachedRowSet = cachedResult;
            synchronized (cachedRowSet) {
                crs.populate(cachedResult, filter);
                cachedResult.beforeFirst();
            }
            cachedRowSet = crs;
            return cachedRowSet;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"Failed to close result set! Squishing this exception: ", (Throwable)ex);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"Failed to close statement! Squishing this exception: ", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getExportedKeys(String catalog, final String schema, final String table) throws SQLException {
        CacheKey cacheKey = new CacheKey(this.getConnection().getMetaData(), catalog, schema);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getConnection().createStatement();
            StringBuilder sql = new StringBuilder();
            CachedRowSet cachedResult = this.getCachedResult(importedAndExportedKeysCache, cacheKey);
            if (cachedResult == null) {
                sql.append("SELECT NULL AS pktable_cat,\n");
                sql.append("       p.owner as pktable_schem,\n");
                sql.append("       p.table_name as pktable_name,\n");
                sql.append("       pc.column_name as pkcolumn_name,\n");
                sql.append("       NULL as fktable_cat,\n");
                sql.append("       f.owner as fktable_schem,\n");
                sql.append("       f.table_name as fktable_name,\n");
                sql.append("       fc.column_name as fkcolumn_name,\n");
                sql.append("       fc.position as key_seq,\n");
                sql.append("       NULL as update_rule,\n");
                sql.append("       decode (f.delete_rule, 'CASCADE', 0, 'SET NULL', 2, 1) as delete_rule,\n");
                sql.append("       f.constraint_name as fk_name,\n");
                sql.append("       p.constraint_name as pk_name,\n");
                sql.append("       decode(f.deferrable, 'DEFERRABLE', 5 ,'NOT DEFERRABLE', 7, 'DEFERRED', 6) deferrability\n");
                sql.append("FROM all_cons_columns pc, all_constraints p,\n");
                sql.append("     all_cons_columns fc, all_constraints f\n");
                sql.append("WHERE 1 = 1\n");
                if (cacheType.get() == null || ((DatabaseMetaDataDecorator.CacheType)((Object)cacheType.get())).equals((Object)DatabaseMetaDataDecorator.CacheType.NO_CACHE)) {
                    sql.append("      AND p.table_name = ").append(SQL.quote(table)).append("\n");
                    if (schema != null) {
                        sql.append("      AND p.owner = ").append(SQL.quote(schema)).append("\n");
                    }
                }
                sql.append("      AND f.constraint_type = 'R'\n");
                sql.append("      AND p.owner = f.r_owner\n");
                sql.append("      AND p.constraint_name = f.r_constraint_name\n");
                sql.append("      AND p.constraint_type in ('P', 'U')\n");
                sql.append("      AND pc.owner = p.owner\n");
                sql.append("      AND pc.constraint_name = p.constraint_name\n");
                sql.append("      AND pc.table_name = p.table_name\n");
                sql.append("      AND fc.owner = f.owner\n");
                sql.append("      AND fc.constraint_name = f.constraint_name\n");
                sql.append("      AND fc.table_name = f.table_name\n");
                sql.append("      AND fc.position = pc.position\n");
                sql.append("ORDER BY fktable_cat, fktable_schem, fktable_name, key_seq");
                logger.debug((Object)("getExportedKeys() sql statement was: " + sql.toString()));
                rs = stmt.executeQuery(sql.toString());
                CachedRowSet result = new CachedRowSet();
                result.populate(rs);
                if (cacheType.get() == null || ((DatabaseMetaDataDecorator.CacheType)((Object)cacheType.get())).equals((Object)DatabaseMetaDataDecorator.CacheType.NO_CACHE)) {
                    CachedRowSet cachedRowSet = result;
                    return cachedRowSet;
                }
                this.putCachedResult(importedAndExportedKeysCache, cacheKey, result);
                cachedResult = result;
            }
            CachedRowSet crs = new CachedRowSet();
            RowFilter filter = new RowFilter(){

                @Override
                public boolean acceptsRow(Object[] row) {
                    boolean result = schema != null ? schema.equals(row[1]) && table.equals(row[2]) : table.equals(row[2]);
                    return result;
                }
            };
            CachedRowSet cachedRowSet = cachedResult;
            synchronized (cachedRowSet) {
                crs.populate(cachedResult, filter);
                cachedResult.beforeFirst();
            }
            cachedRowSet = crs;
            return cachedRowSet;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"Failed to close result set! Squishing this exception: ", (Throwable)ex);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"Failed to close statement! Squishing this exception: ", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        logger.debug((Object)("getColumns(" + catalog + ", " + schemaPattern + ", " + tableNamePattern + ", " + columnNamePattern + ") cache mode=" + cacheType.get()));
        CacheKey cacheKey = new CacheKey(this.getConnection().getMetaData(), catalog, schemaPattern);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            CachedRowSet filtered;
            Pattern cp;
            Pattern tp;
            IndexedCachedRowSet cachedResult = this.getCachedResult(columnsCache, cacheKey);
            if (cachedResult == null) {
                logger.debug((Object)"No cached data found. Querying data dictionary...");
                stmt = this.getConnection().createStatement();
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT ");
                sql.append("\tNULL AS table_cat,\n");
                sql.append("\tt.owner AS table_schem,\n");
                sql.append("\tt.table_name AS table_name,\n");
                sql.append("\tt.column_name AS column_name,\n");
                sql.append("\tDECODE (CASE  WHEN SUBSTR(t.data_type, 1, 9) = 'TIMESTAMP' THEN 'TIMESTAMP'  ELSE t.data_type END , 'CHAR', 1, 'VARCHAR2', 12, 'NUMBER', 3, 'LONG', -1, 'DATE', 91, 'RAW', -3, 'LONG RAW', -4, 'BLOB', 2004, 'CLOB', 2005, 'BFILE', -13, 'FLOAT', 6, 'TIMESTAMP', 93, 'TIMESTAMP WITH TIME ZONE', -101, 'TIMESTAMP WITH LOCAL TIME ZONE', -102, 'INTERVAL YEAR(2) TO MONTH', -103, 'INTERVAL DAY(2) TO SECOND(6)', -104, 'BINARY_FLOAT', 100, 'BINARY_DOUBLE', 101, 'NVARCHAR2', -9, 'NCHAR', -15, 'NCLOB', 2011, 1111)\n");
                sql.append("\tAS data_type,\n");
                sql.append("\tt.data_type AS type_name,\n");
                sql.append("\tDECODE (t.data_precision, null, t.data_length, t.data_precision) AS column_size,\n");
                sql.append("\t0 AS buffer_length,\n");
                sql.append("\tt.data_scale AS decimal_digits,\n");
                sql.append("\t10 AS num_prec_radix,\n");
                sql.append("\tDECODE (t.nullable, 'N', 0, 1) AS nullable,\n");
                sql.append("\tc.comments AS remarks,\n");
                sql.append("\tt.data_default AS column_def,\n");
                sql.append("\t0 AS sql_data_type,\n");
                sql.append("\t0 AS sql_datetime_sub,\n");
                sql.append("\tt.data_length AS char_octet_length,\n");
                sql.append("\tt.column_id AS ordinal_position,\n");
                sql.append("\tDECODE (t.nullable, 'N', 'NO', 'YES') AS is_nullable\n");
                sql.append("FROM\n");
                sql.append("\tall_tab_columns t,\n");
                sql.append("\tall_col_comments c\n");
                sql.append("WHERE\n");
                if (schemaPattern != null) {
                    sql.append("\tt.owner LIKE ").append(SQL.quote(schemaPattern)).append(" ESCAPE '/'\n");
                    sql.append("\tAND");
                }
                if (this.hidingRecycleBinTables) {
                    sql.append("\tt.table_name NOT LIKE 'BIN$%' ESCAPE '/'\n");
                    sql.append("\tAND");
                }
                if (cacheType.get() == null || ((DatabaseMetaDataDecorator.CacheType)((Object)cacheType.get())).equals((Object)DatabaseMetaDataDecorator.CacheType.NO_CACHE)) {
                    if (tableNamePattern != null) {
                        sql.append("\tt.table_name LIKE ").append(SQL.quote(tableNamePattern)).append(" ESCAPE '/'\n");
                        sql.append("    AND");
                    }
                    sql.append("\tt.column_name LIKE ").append(SQL.quote(columnNamePattern)).append(" ESCAPE '/'\n");
                    sql.append("\tAND");
                }
                sql.append("\tt.owner=c.owner (+)\n");
                sql.append("\tAND t.table_name=c.table_name (+)\n");
                sql.append("\tAND t.column_name = c.column_name (+)\n");
                sql.append("ORDER BY\n");
                sql.append("\ttable_schem, table_name, ordinal_position");
                logger.debug((Object)("getColumns() sql statement was: \n" + sql.toString()));
                stmt.setFetchSize(1000);
                rs = stmt.executeQuery(sql.toString());
                if (cacheType.get() == null || ((DatabaseMetaDataDecorator.CacheType)((Object)cacheType.get())).equals((Object)DatabaseMetaDataDecorator.CacheType.NO_CACHE)) {
                    CachedRowSet result = new CachedRowSet();
                    result.populate(rs);
                    CachedRowSet cachedRowSet = result;
                    return cachedRowSet;
                }
                IndexedCachedRowSet result = new IndexedCachedRowSet(rs, 3);
                this.putCachedResult(columnsCache, cacheKey, result);
                cachedResult = result;
            }
            if (tableNamePattern != null) {
                String tablePattern = tableNamePattern.replaceAll("%", ".*");
                tp = Pattern.compile(tablePattern);
            } else {
                tp = null;
            }
            if (columnNamePattern != null) {
                String columnPattern = columnNamePattern.replace("%", ".*");
                cp = Pattern.compile(columnPattern);
            } else {
                cp = null;
            }
            RowFilter filter = new RowFilter(){

                @Override
                public boolean acceptsRow(Object[] row) {
                    return !(tp != null && !tp.matcher(row[2].toString()).matches() || cp != null && !cp.matcher(row[3].toString()).matches());
                }
            };
            logger.debug((Object)"Filtering cache...");
            CachedRowSet cachedRowSet = cachedResult;
            synchronized (cachedRowSet) {
                if (tableNamePattern != null && !tableNamePattern.contains("%")) {
                    filtered = cachedResult.extractSingleTable(tableNamePattern);
                } else {
                    filtered = new CachedRowSet();
                    filtered.populate(cachedResult, filter);
                }
                cachedResult.beforeFirst();
            }
            cachedRowSet = filtered;
            return cachedRowSet;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"Failed to close result set! Squishing this exception: ", (Throwable)ex);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"Failed to close statement! Squishing this exception: ", (Throwable)ex);
                }
            }
        }
    }

    @Override
    protected OracleResultSetDecorator wrap(ResultSet rs) throws SQLException {
        return new OracleResultSetDecorator(this.wrap(rs.getStatement()), rs);
    }

    @Override
    protected OracleStatementDecorator wrap(Statement statement) {
        return new OracleStatementDecorator(this.connectionDecorator, statement);
    }
}

