/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject.undo;

import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.undo.NotifyingUndoManager;
import ca.sqlpower.sqlobject.undo.PropertyChangeEdit;
import ca.sqlpower.sqlobject.undo.SPObjectPropertyChangeUndoableEdit;
import ca.sqlpower.sqlobject.undo.SQLObjectChildEdit;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.apache.log4j.Logger;

public class SQLObjectUndoManager
extends UndoManager
implements NotifyingUndoManager {
    private static final Logger logger = Logger.getLogger(SQLObjectUndoManager.class);
    protected final SQLObjectUndoableEventAdapter eventAdapter = new SQLObjectUndoableEventAdapter();
    private boolean undoing;
    private boolean redoing;
    private boolean loading = false;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private final SQLObject sqlObjectRoot;

    public SQLObjectUndoManager(SQLObject sqlObjectRoot) {
        this.sqlObjectRoot = sqlObjectRoot;
        this.init(sqlObjectRoot);
    }

    private final void init(SQLObject sqlObjectRoot) {
        SQLPowerUtils.listenToHierarchy(sqlObjectRoot, this.eventAdapter);
        this.eventAdapter.attachToObject(sqlObjectRoot);
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit anEdit) {
        if (!this.isUndoing() && !this.isRedoing()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added new undoableEdit to undo manager " + anEdit));
            }
            boolean success = super.addEdit(anEdit);
            this.fireStateChanged();
            return success;
        }
        return true;
    }

    @Override
    public synchronized void undo() throws CannotUndoException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Undoing");
        }
        this.undoing = true;
        super.undo();
        this.fireStateChanged();
        this.undoing = false;
    }

    @Override
    public synchronized void redo() throws CannotRedoException {
        this.redoing = true;
        super.redo();
        this.fireStateChanged();
        this.redoing = false;
    }

    @Override
    public synchronized boolean canUndo() {
        return super.canUndo() && this.eventAdapter.canUndoOrRedo();
    }

    @Override
    public synchronized boolean canRedo() {
        return super.canRedo() && this.eventAdapter.canUndoOrRedo();
    }

    public int getUndoableEditCount() {
        if (this.editToBeUndone() == null) {
            return 0;
        }
        int count = this.edits.indexOf(this.editToBeUndone()) + 1;
        return count;
    }

    public int getRedoableEditCount() {
        if (this.editToBeRedone() == null) {
            return 0;
        }
        int count = this.edits.size() - this.edits.indexOf(this.editToBeRedone());
        return count;
    }

    public boolean isRedoing() {
        return this.redoing;
    }

    public boolean isUndoing() {
        return this.undoing;
    }

    public boolean isUndoOrRedoing() {
        return this.undoing || this.redoing;
    }

    public SQLObjectUndoableEventAdapter getEventAdapter() {
        return this.eventAdapter;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    public void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(event);
        }
    }

    public String printUndoVector() {
        StringBuffer sb = new StringBuffer();
        for (UndoableEdit o : this.edits) {
            sb.append(o).append("\n");
        }
        return sb.toString();
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public class SQLObjectUndoableEventAdapter
    implements SPListener,
    PropertyChangeListener {
        private final SPListener ancestorListener = new AbstractSPListener(){

            @Override
            public void transactionStarted(TransactionEvent e) {
                SQLObjectUndoableEventAdapter.this.compoundGroupStart(e.getMessage());
            }

            @Override
            public void transactionEnded(TransactionEvent e) {
                SQLObjectUndoableEventAdapter.this.compoundGroupEnd();
            }
        };
        private CompoundEdit ce = null;
        private int compoundEditStackCount = 0;
        protected boolean addListenerToChildren = true;

        public SQLObjectUndoableEventAdapter() {
        }

        public SQLObjectUndoableEventAdapter(boolean addListenerToChildren) {
            this();
            this.addListenerToChildren = addListenerToChildren;
        }

        public void attachToObject(SPObject root) {
            for (SPObject ancestor : SQLPowerUtils.getAncestorList(root)) {
                ancestor.addSPListener(this.ancestorListener);
            }
        }

        public boolean canUndoOrRedo() {
            return this.ce == null;
        }

        private void compoundGroupStart(String toolTip) {
            if (SQLObjectUndoManager.this.isUndoOrRedoing()) {
                return;
            }
            ++this.compoundEditStackCount;
            if (this.compoundEditStackCount == 1) {
                this.ce = new CompEdit(toolTip);
                SQLObjectUndoManager.this.fireStateChanged();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("compoundGroupStart: edit stack =" + this.compoundEditStackCount));
            }
        }

        private void compoundGroupEnd() {
            if (SQLObjectUndoManager.this.isUndoOrRedoing()) {
                return;
            }
            if (this.compoundEditStackCount <= 0) {
                throw new IllegalStateException("No compound edit in progress");
            }
            --this.compoundEditStackCount;
            if (this.compoundEditStackCount == 0) {
                this.returnToEditState();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("compoundGroupEnd: edit stack =" + this.compoundEditStackCount + " ce=" + this.ce));
            }
        }

        private void addEdit(UndoableEdit undoEdit) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding new edit: " + undoEdit));
            }
            if (this.compoundEditStackCount == 0) {
                if (!SQLObjectUndoManager.this.loading) {
                    SQLObjectUndoManager.this.addEdit(undoEdit);
                }
            } else {
                this.ce.addEdit(undoEdit);
            }
        }

        @Override
        public void childAdded(SPChildEvent e) {
            if (SQLObjectUndoManager.this.isUndoOrRedoing()) {
                return;
            }
            this.addEdit(new SQLObjectChildEdit(e));
            if (this.addListenerToChildren) {
                SQLPowerUtils.listenToHierarchy(e.getChild(), this);
            }
        }

        @Override
        public void childRemoved(SPChildEvent e) {
            if (SQLObjectUndoManager.this.isUndoOrRedoing()) {
                return;
            }
            this.addEdit(new SQLObjectChildEdit(e));
        }

        @Override
        public void propertyChanged(PropertyChangeEvent e) {
            if (SQLObjectUndoManager.this.isUndoOrRedoing()) {
                return;
            }
            if (!SQLObjectUndoManager.this.loading && e.getPropertyName().equals("UUID")) {
                throw new IllegalStateException("Cannot undo UUID changes. This event can only occur during loading. Event " + e);
            }
            if (!(e.getSource() instanceof SQLDatabase) || !e.getPropertyName().equals("shortDisplayName")) {
                SPObjectPropertyChangeUndoableEdit undoEvent = new SPObjectPropertyChangeUndoableEdit(e);
                this.addEdit(undoEvent);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (SQLObjectUndoManager.this.isUndoOrRedoing()) {
                return;
            }
            if (!SQLObjectUndoManager.this.loading && evt.getPropertyName().equals("UUID")) {
                throw new IllegalStateException("Cannot undo UUID changes. This event can only occur during loading. Event " + evt);
            }
            PropertyChangeEdit edit = new PropertyChangeEdit(evt);
            this.addEdit(edit);
        }

        private void returnToEditState() {
            if (this.compoundEditStackCount != 0) {
                throw new IllegalStateException("The compound edit stack (" + this.compoundEditStackCount + ") should be 0");
            }
            if (this.ce != null) {
                this.ce.end();
                if (this.ce.canUndo() && !SQLObjectUndoManager.this.loading) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Adding compound edit " + this.ce + " to undo manager"));
                    }
                    SQLObjectUndoManager.this.addEdit(this.ce);
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Compound edit " + this.ce + " is not undoable so we are not adding it"));
                }
                this.ce = null;
            }
            SQLObjectUndoManager.this.fireStateChanged();
            logger.debug((Object)"Returning to regular state");
        }

        @Override
        public void transactionStarted(TransactionEvent e) {
            this.compoundGroupStart(e.getMessage());
        }

        @Override
        public void transactionEnded(TransactionEvent e) {
            this.compoundGroupEnd();
        }

        @Override
        public void transactionRollback(TransactionEvent e) {
        }

        private final class CompEdit
        extends CompoundEdit {
            String toolTip;

            public CompEdit(String toolTip) {
                this.toolTip = toolTip;
            }

            @Override
            public String getPresentationName() {
                return this.toolTip;
            }

            @Override
            public String getUndoPresentationName() {
                return "Undo " + this.getPresentationName();
            }

            @Override
            public String getRedoPresentationName() {
                return "Redo " + this.getPresentationName();
            }

            @Override
            public boolean canUndo() {
                return super.canUndo() && this.edits.size() > 0;
            }

            @Override
            public boolean canRedo() {
                return super.canRedo() && this.edits.size() > 0;
            }

            @Override
            public String toString() {
                StringBuffer sb = new StringBuffer();
                for (UndoableEdit o : this.edits) {
                    sb.append(o).append("\n");
                }
                return sb.toString();
            }

            @Override
            public void undo() throws CannotUndoException {
                List<SPObject> ancestorList = SQLPowerUtils.getAncestorList(SQLObjectUndoManager.this.sqlObjectRoot);
                SPObject absoluteRoot = ancestorList.isEmpty() ? SQLObjectUndoManager.this.sqlObjectRoot : ancestorList.get(0);
                try {
                    absoluteRoot.begin("Undoing compound edit " + this.getUndoPresentationName());
                    super.undo();
                    absoluteRoot.commit();
                }
                catch (RuntimeException e) {
                    absoluteRoot.rollback(e.getMessage());
                    throw e;
                }
            }

            @Override
            public void redo() throws CannotRedoException {
                List<SPObject> ancestorList = SQLPowerUtils.getAncestorList(SQLObjectUndoManager.this.sqlObjectRoot);
                SPObject absoluteRoot = ancestorList.isEmpty() ? SQLObjectUndoManager.this.sqlObjectRoot : ancestorList.get(0);
                try {
                    absoluteRoot.begin("Redoing compound edit " + this.getRedoPresentationName());
                    super.redo();
                    absoluteRoot.commit();
                }
                catch (RuntimeException e) {
                    absoluteRoot.rollback(e.getMessage());
                    throw e;
                }
            }
        }
    }
}

