/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.swingui.Messages;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class PlatformSpecificConnectionOptionPanel {
    private static Logger logger = Logger.getLogger(PlatformSpecificConnectionOptionPanel.class);
    private JDBCURLUpdater urlUpdater = new JDBCURLUpdater();
    private boolean updatingUrlFromFields = false;
    private boolean updatingFieldsFromUrl = false;
    private JTextField dbUrlField;
    private JPanel platformSpecificOptionPanel = new JPanel();
    private JDBCDataSourceType template;

    public PlatformSpecificConnectionOptionPanel(JTextField dbUrlField) {
        this.platformSpecificOptionPanel.setLayout(new PlatformOptionsLayout());
        this.platformSpecificOptionPanel.setBorder(BorderFactory.createEmptyBorder());
        this.platformSpecificOptionPanel.add(new JLabel(Messages.getString("PlatformSpecificConnectionOptionPanel.noOptionsForDriver")));
        this.dbUrlField = dbUrlField;
        dbUrlField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PlatformSpecificConnectionOptionPanel.this.updateFieldsFromUrl();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PlatformSpecificConnectionOptionPanel.this.updateFieldsFromUrl();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PlatformSpecificConnectionOptionPanel.this.updateFieldsFromUrl();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUrlFromFields() {
        if (this.updatingFieldsFromUrl) {
            return;
        }
        if (this.template == null || this.template.getJdbcUrl() == null) {
            return;
        }
        try {
            this.updatingUrlFromFields = true;
            StringBuffer newUrl = new StringBuffer();
            Pattern p = Pattern.compile("<(.*?)>");
            Matcher m = p.matcher(this.template.getJdbcUrl());
            while (m.find()) {
                String varName = m.group(1);
                if (varName.indexOf(58) != -1) {
                    varName = varName.substring(0, varName.indexOf(58));
                }
                String varValue = this.getPlatformSpecificFieldValue(varName);
                varValue = this.escapeDollarBackslash(varValue);
                m.appendReplacement(newUrl, varValue);
            }
            m.appendTail(newUrl);
            this.dbUrlField.setText(newUrl.toString());
        }
        finally {
            this.updatingUrlFromFields = false;
        }
    }

    private String escapeDollarBackslash(String varValue) {
        if (varValue == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < varValue.length(); ++i) {
            char ch = varValue.charAt(i);
            if (ch == '\\' || ch == '$') {
                sb.append('\\');
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private String getPlatformSpecificFieldValue(String varName) {
        for (int i = 0; i < this.platformSpecificOptionPanel.getComponentCount(); ++i) {
            if (!(this.platformSpecificOptionPanel.getComponent(i) instanceof JLabel) || !((JLabel)this.platformSpecificOptionPanel.getComponent(i)).getText().equals(varName) || this.platformSpecificOptionPanel.getComponentCount() < i + 1) continue;
            return ((JTextField)this.platformSpecificOptionPanel.getComponent(i + 1)).getText();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFieldsFromUrl() {
        if (this.updatingUrlFromFields) {
            return;
        }
        if (this.template == null || this.template.getJdbcUrl() == null) {
            return;
        }
        try {
            this.updatingFieldsFromUrl = true;
            for (int i = 0; i < this.platformSpecificOptionPanel.getComponentCount(); ++i) {
                this.platformSpecificOptionPanel.getComponent(i).setEnabled(true);
            }
            logger.debug((Object)("template is " + this.template));
            logger.debug((Object)("dbUrlField is " + this.dbUrlField));
            Map<String, String> map = this.template.retrieveURLParsing(this.dbUrlField.getText());
            if (!map.isEmpty()) {
                this.platformSpecificOptionPanel.setEnabled(true);
                for (int g = 0; g < map.size(); ++g) {
                    ((JTextField)this.platformSpecificOptionPanel.getComponent(2 * g + 1)).setText((String)map.values().toArray()[g]);
                }
            } else {
                for (int i = 0; i < this.platformSpecificOptionPanel.getComponentCount(); ++i) {
                    this.platformSpecificOptionPanel.getComponent(i).setEnabled(false);
                }
            }
        }
        finally {
            this.updatingFieldsFromUrl = false;
        }
    }

    private void createFieldsFromTemplate() {
        for (int i = 0; i < this.platformSpecificOptionPanel.getComponentCount(); ++i) {
            Component c = this.platformSpecificOptionPanel.getComponent(i);
            if (!(c instanceof JTextField)) continue;
            ((JTextField)c).getDocument().removeDocumentListener(this.urlUpdater);
        }
        this.platformSpecificOptionPanel.removeAll();
        if (this.template != null) {
            Map<String, String> map = this.template.retrieveURLParsing(this.dbUrlField.getText());
            if (map.size() == 0) {
                map = this.template.retrieveURLDefaults();
            }
            Iterator<String> i$ = map.keySet().iterator();
            while (i$.hasNext()) {
                String key;
                String var = key = i$.next();
                String def = map.get(key);
                this.platformSpecificOptionPanel.add(new JLabel(var));
                JTextField field = new JTextField(def);
                this.platformSpecificOptionPanel.add(field);
                field.getDocument().addDocumentListener(this.urlUpdater);
                logger.debug((Object)("The default value for key " + key + " is: " + def));
            }
        } else {
            this.platformSpecificOptionPanel.add(new JLabel(Messages.getString("PlatformSpecificConnectionOptionPanel.unknownDriverClass")));
        }
        this.platformSpecificOptionPanel.revalidate();
        this.platformSpecificOptionPanel.repaint();
    }

    public JPanel getPanel() {
        return this.platformSpecificOptionPanel;
    }

    public JDBCDataSourceType getTemplate() {
        return this.template;
    }

    public void setTemplate(JDBCDataSourceType template) {
        this.template = template;
        this.createFieldsFromTemplate();
        this.updateUrlFromFields();
    }

    private static class PlatformOptionsLayout
    implements LayoutManager {
        int preLabelGap = 10;
        int gap = 5;

        private PlatformOptionsLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int height = 0;
            int width = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component c = parent.getComponent(i);
                height = Math.max(height, c.getPreferredSize().height);
                width = (int)((double)width + c.getPreferredSize().getWidth());
            }
            return new Dimension(width, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            int height = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component c = parent.getComponent(i);
                height = Math.max(height, c.getMinimumSize().height);
            }
            return new Dimension(0, height);
        }

        @Override
        public void layoutContainer(Container parent) {
            int labelSize = 0;
            int labelCount = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component c = parent.getComponent(i);
                if (!(c instanceof JLabel)) continue;
                if (i > 0) {
                    labelSize += this.preLabelGap;
                }
                labelSize += c.getPreferredSize().width;
                ++labelCount;
            }
            int gapSize = this.gap * (parent.getComponentCount() - 1);
            int nonLabelWidth = 0;
            if (parent.getComponentCount() != labelCount) {
                nonLabelWidth = (parent.getWidth() - labelSize - gapSize) / (parent.getComponentCount() - labelCount);
            }
            if (nonLabelWidth < 20) {
                nonLabelWidth = 20;
            }
            int x = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component c = parent.getComponent(i);
                if (i > 0) {
                    x += this.gap;
                }
                if (c instanceof JLabel) {
                    if (i > 0) {
                        x += this.preLabelGap;
                    }
                    c.setBounds(x, 0, c.getPreferredSize().width, parent.getHeight());
                    x += c.getPreferredSize().width;
                    continue;
                }
                c.setBounds(x, 0, nonLabelWidth, parent.getHeight());
                x += nonLabelWidth;
            }
        }
    }

    private class JDBCURLUpdater
    implements DocumentListener {
        private JDBCURLUpdater() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PlatformSpecificConnectionOptionPanel.this.updateUrlFromFields();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PlatformSpecificConnectionOptionPanel.this.updateUrlFromFields();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PlatformSpecificConnectionOptionPanel.this.updateUrlFromFields();
        }
    }
}

