/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.enterprise.client;

import ca.sqlpower.enterprise.ClientSideSessionUtils;
import ca.sqlpower.enterprise.client.ProjectLocation;
import ca.sqlpower.enterprise.client.SPServerInfo;
import ca.sqlpower.enterprise.client.SPServerInfoManager;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.util.UserPrompter;
import ca.sqlpower.util.UserPrompterFactory;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.http.client.CookieStore;
import org.json.JSONException;

public abstract class ServerProjectsManagerPanel {
    private final Component dialogOwner;
    private final UserPrompterFactory upf;
    private final File defaultFileDirectory;
    private final JPanel panel;
    private final Action closeAction;
    private final JList projects;
    private final JList servers;
    private final Action refreshAction = new AbstractAction("Refresh"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ServerProjectsManagerPanel.this.refreshInfoList();
        }
    };
    private final Action newAction = new AbstractAction("New..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            String name;
            if (ServerProjectsManagerPanel.this.getSelectedServerInfo() != null && (name = JOptionPane.showInputDialog(ServerProjectsManagerPanel.this.dialogOwner, "Please specify the name of your project", "", 3)) != null) {
                DefaultListModel model = (DefaultListModel)ServerProjectsManagerPanel.this.projects.getModel();
                for (int i = 0; i < model.size(); ++i) {
                    if (!((ProjectLocation)model.getElementAt(i)).getName().trim().equalsIgnoreCase(name.trim())) continue;
                    JOptionPane.showMessageDialog(ServerProjectsManagerPanel.this.dialogOwner, "A project called \"" + name + "\" already exists. Please use a different name.", "Duplicate project name", 0);
                    return;
                }
                try {
                    Window frame = SwingUtilities.getWindowAncestor(ServerProjectsManagerPanel.this.dialogOwner);
                    JLabel messageLabel = new JLabel("Creating New Project");
                    JProgressBar progressBar = new JProgressBar();
                    progressBar.setIndeterminate(true);
                    JDialog dialog = new JDialog(frame, "Creating New Project");
                    DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref:grow, 5dlu, pref"));
                    builder.setDefaultDialogBorder();
                    builder.append((Component)messageLabel, 3);
                    builder.nextLine();
                    builder.append((Component)progressBar, 3);
                    dialog.add(builder.getPanel());
                    dialog.setSize(new Dimension(300, 90));
                    dialog.setLocationRelativeTo(frame);
                    dialog.setAlwaysOnTop(true);
                    dialog.setVisible(true);
                    ClientSideSessionUtils.createNewServerSession(ServerProjectsManagerPanel.this.getSelectedServerInfo(), name, ServerProjectsManagerPanel.this.cookieStore, ServerProjectsManagerPanel.this.upf);
                    dialog.dispose();
                }
                catch (Exception ex) {
                    throw new RuntimeException("Unable to create new project", ex);
                }
                ServerProjectsManagerPanel.this.refreshInfoList();
            }
        }
    };
    private final Action uploadAction = new AbstractAction("Upload"){

        @Override
        public void actionPerformed(ActionEvent e) {
            final JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor(ServerProjectsManagerPanel.this.dialogOwner), "Upload Project", Dialog.ModalityType.DOCUMENT_MODAL);
            JPanel panel = new JPanel();
            FormLayout layout = new FormLayout("4dlu, pref, 4dlu, max(150dlu;pref), 4dlu, pref, 4dlu", "pref, pref, pref");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout, panel);
            CellConstraints cc = new CellConstraints();
            final JTextField nameField = new JTextField();
            builder.add((Component)new JLabel("Name"), cc.xy(2, 1));
            builder.add((Component)nameField, cc.xyw(4, 1, 3));
            final JTextField fileField = new JTextField();
            JButton fileButton = new JButton("...");
            fileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser(ServerProjectsManagerPanel.this.defaultFileDirectory);
                    chooser.addChoosableFileFilter(SPSUtils.ARCHITECT_FILE_FILTER);
                    chooser.setDialogTitle("Choose Project to Upload");
                    int response = chooser.showOpenDialog(dialog);
                    if (response != 0) {
                        return;
                    }
                    fileField.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            });
            builder.add((Component)new JLabel("File"), cc.xy(2, 2));
            builder.add((Component)fileField, cc.xy(4, 2));
            builder.add((Component)fileButton, cc.xy(6, 2));
            final JButton okButton = new JButton("Upload");
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File f = new File(fileField.getText());
                    if (!f.canRead()) {
                        JOptionPane.showMessageDialog(ServerProjectsManagerPanel.this.dialogOwner, "File cannot be read", "Invalid File", 0);
                        return;
                    }
                    try {
                        ClientSideSessionUtils.uploadProject(ServerProjectsManagerPanel.this.getSelectedServerInfo(), nameField.getText(), f, ServerProjectsManagerPanel.this.upf, ServerProjectsManagerPanel.this.cookieStore);
                        dialog.dispose();
                        ServerProjectsManagerPanel.this.refreshInfoList();
                    }
                    catch (Exception ex) {
                        SPSUtils.showExceptionDialogNoReport(dialog, "Unable to upload project", ex);
                    }
                }
            });
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.dispose();
                }
            });
            okButton.setEnabled(false);
            DocumentListener documentListener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.textChanged(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.textChanged(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.textChanged(e);
                }

                private void textChanged(DocumentEvent e) {
                    okButton.setEnabled(!fileField.getText().isEmpty() && !nameField.getText().isEmpty());
                }
            };
            fileField.getDocument().addDocumentListener(documentListener);
            nameField.getDocument().addDocumentListener(documentListener);
            JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)okButton, (JButton)cancelButton);
            builder.add((Component)buttonBar, cc.xyw(2, 3, 5));
            dialog.add(panel);
            SPSUtils.makeJDialogCancellable(dialog, null);
            dialog.pack();
            dialog.setLocationRelativeTo(ServerProjectsManagerPanel.this.dialogOwner);
            dialog.setVisible(true);
        }
    };
    private final Action deleteAction = new AbstractAction("Delete"){

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] indices;
            if (ServerProjectsManagerPanel.this.getSelectedServerInfo() != null && (indices = ServerProjectsManagerPanel.this.projects.getSelectedIndices()).length >= 1) {
                Object[] objs = new Object[indices.length];
                for (int i = 0; i < indices.length; ++i) {
                    objs[i] = ServerProjectsManagerPanel.this.projects.getModel().getElementAt(indices[i]);
                }
                String promptMessage = indices.length == 1 ? "Are you sure you want to delete the selected project?\nThis action cannot be undone." : "Are you sure you want to delete these " + indices.length + " selected projects?" + "\nThis action cannot be undone.";
                if (JOptionPane.showConfirmDialog(ServerProjectsManagerPanel.this.dialogOwner, promptMessage, "Confirm Delete Projects", 0, 2) == 0) {
                    for (Object obj : objs) {
                        if (!(obj instanceof ProjectLocation)) continue;
                        ProjectLocation location = (ProjectLocation)obj;
                        try {
                            ClientSideSessionUtils.deleteServerWorkspace(location, ServerProjectsManagerPanel.this.cookieStore, ServerProjectsManagerPanel.this.upf);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException("Unable to delete project", ex);
                        }
                    }
                    ServerProjectsManagerPanel.this.refreshInfoList();
                }
            }
        }
    };
    private boolean connected = false;
    private SPServerInfo serverInfo = null;
    private final CookieStore cookieStore;
    private final JButton securityButton = new JButton();
    private final JButton openButton = new JButton();

    public ServerProjectsManagerPanel(SPServerInfo serverInfo, Component dialogOwner, UserPrompterFactory upf, Action closeAction, File defaultFileDirectory, CookieStore cookieStore) {
        this.serverInfo = serverInfo;
        this.dialogOwner = dialogOwner;
        this.upf = upf;
        this.closeAction = closeAction;
        this.defaultFileDirectory = defaultFileDirectory;
        this.cookieStore = cookieStore;
        cookieStore.clear();
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref:grow, 5dlu, pref", "pref, pref, pref"));
        this.servers = null;
        this.projects = new JList(new DefaultListModel());
        this.projects.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ServerProjectsManagerPanel.this.refreshPanel();
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    ServerProjectsManagerPanel.this.getOpenAction().actionPerformed(null);
                }
            }
        });
        JScrollPane projectsPane = new JScrollPane(this.projects);
        projectsPane.setPreferredSize(new Dimension(250, 300));
        CellConstraints cc = new CellConstraints();
        builder.add((Component)new JLabel(serverInfo.getName() + "'s projects:"), cc.xyw(1, 1, 2));
        builder.nextLine();
        builder.add((Component)projectsPane, cc.xywh(1, 2, 1, 2));
        DefaultFormBuilder buttonBarBuilder = new DefaultFormBuilder(new FormLayout("pref"));
        buttonBarBuilder.append((Component)new JButton(this.refreshAction));
        buttonBarBuilder.append((Component)this.securityButton);
        buttonBarBuilder.append((Component)new JButton(this.newAction));
        buttonBarBuilder.append((Component)this.openButton);
        buttonBarBuilder.append((Component)new JButton(this.deleteAction));
        buttonBarBuilder.append((Component)new JButton(closeAction));
        builder.add((Component)buttonBarBuilder.getPanel(), cc.xy(3, 2));
        builder.setDefaultDialogBorder();
        this.panel = builder.getPanel();
    }

    public ServerProjectsManagerPanel(SPServerInfoManager serverManager, Component dialogOwner, UserPrompterFactory upf, Action closeAction, File defaultFileDirectory, CookieStore cookieStore) {
        this.dialogOwner = dialogOwner;
        this.upf = upf;
        this.closeAction = closeAction;
        this.defaultFileDirectory = defaultFileDirectory;
        this.cookieStore = cookieStore;
        cookieStore.clear();
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref:grow, 5dlu, pref:grow, 5dlu, pref", "pref, pref, pref"));
        this.servers = new JList(new DefaultListModel());
        this.servers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    ServerProjectsManagerPanel.this.refreshInfoList();
                }
            }
        });
        DefaultListModel serversModel = (DefaultListModel)this.servers.getModel();
        serversModel.removeAllElements();
        if (serverManager.getServers(false).size() > 0) {
            for (SPServerInfo serverInfo : serverManager.getServers(false)) {
                serversModel.addElement(serverInfo);
            }
        } else {
            serversModel.addElement("No Servers");
            this.servers.setEnabled(false);
        }
        this.projects = new JList(new DefaultListModel());
        this.projects.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ServerProjectsManagerPanel.this.refreshPanel();
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    ServerProjectsManagerPanel.this.getOpenAction().actionPerformed(null);
                }
            }
        });
        JScrollPane projectsPane = new JScrollPane(this.projects);
        projectsPane.setPreferredSize(new Dimension(250, 300));
        JScrollPane serverPane = new JScrollPane(this.servers);
        serverPane.setPreferredSize(new Dimension(250, 300));
        CellConstraints cc = new CellConstraints();
        builder.add((Component)new JLabel("Servers:"), cc.xyw(1, 1, 2));
        builder.add((Component)new JLabel("Projects:"), cc.xyw(3, 1, 2));
        builder.nextLine();
        builder.add((Component)serverPane, cc.xywh(1, 2, 1, 2));
        builder.add((Component)projectsPane, cc.xywh(3, 2, 1, 2));
        DefaultFormBuilder buttonBarBuilder = new DefaultFormBuilder(new FormLayout("pref"));
        buttonBarBuilder.append((Component)new JButton(this.refreshAction));
        buttonBarBuilder.append((Component)this.securityButton);
        buttonBarBuilder.append((Component)new JButton(this.newAction));
        buttonBarBuilder.append((Component)this.openButton);
        buttonBarBuilder.append((Component)new JButton(this.uploadAction));
        buttonBarBuilder.append((Component)new JButton(this.deleteAction));
        buttonBarBuilder.append((Component)new JButton(closeAction));
        builder.add((Component)buttonBarBuilder.getPanel(), cc.xy(5, 2));
        builder.setDefaultDialogBorder();
        this.panel = builder.getPanel();
    }

    public boolean isConnected() {
        this.refreshInfoList();
        return this.connected;
    }

    public JPanel getPanel() {
        this.openButton.setAction(this.getOpenAction());
        this.securityButton.setAction(this.getSecurityAction());
        this.refreshInfoList();
        return this.panel;
    }

    private void refreshPanel() {
        if (this.connected) {
            this.securityButton.setEnabled(true);
            this.newAction.setEnabled(true);
            this.uploadAction.setEnabled(true);
            if (this.projects.isSelectionEmpty()) {
                this.openButton.setEnabled(false);
                this.deleteAction.setEnabled(false);
            } else {
                this.openButton.setEnabled(true);
                this.deleteAction.setEnabled(true);
            }
            this.projects.setEnabled(true);
        } else {
            this.securityButton.setEnabled(false);
            this.newAction.setEnabled(false);
            this.openButton.setEnabled(false);
            this.uploadAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
            this.projects.setEnabled(false);
        }
    }

    protected void refreshInfoList() {
        DefaultListModel model = (DefaultListModel)this.projects.getModel();
        model.removeAllElements();
        SPServerInfo serviceInfo = this.getSelectedServerInfo();
        if (serviceInfo != null) {
            try {
                List<ProjectLocation> projectLocations = this.getProjectLocations();
                Collections.sort(projectLocations, new Comparator<ProjectLocation>(){

                    @Override
                    public int compare(ProjectLocation proj1, ProjectLocation proj2) {
                        return proj1.getName().compareToIgnoreCase(proj2.getName());
                    }
                });
                model.clear();
                for (ProjectLocation pl : projectLocations) {
                    model.addElement(pl);
                }
                this.connected = true;
            }
            catch (Exception ex) {
                model.removeAllElements();
                model.addElement("Unable to get projects from server");
                this.connected = false;
                this.upf.createUserPrompter("Server Unavailable", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, "OK", "OK").promptUser("");
            }
            this.refreshPanel();
        } else {
            model.addElement("No Server Selected");
            this.connected = false;
            this.refreshPanel();
        }
    }

    protected abstract List<ProjectLocation> getProjectLocations() throws IOException, URISyntaxException, JSONException;

    protected SPServerInfo getSelectedServerInfo() {
        Object obj;
        if (this.serverInfo != null) {
            return this.serverInfo;
        }
        int index = this.servers.getSelectedIndex();
        if (index >= 0 && (obj = this.servers.getModel().getElementAt(index)) instanceof SPServerInfo) {
            return (SPServerInfo)obj;
        }
        return null;
    }

    protected Component getDialogOwner() {
        return this.dialogOwner;
    }

    protected Action getCloseAction() {
        return this.closeAction;
    }

    protected List<ProjectLocation> getSelectedProjects() {
        int[] indices;
        ArrayList<ProjectLocation> projectLocations = new ArrayList<ProjectLocation>();
        if (this.getSelectedServerInfo() != null && (indices = this.projects.getSelectedIndices()).length >= 1) {
            for (int i = 0; i < indices.length; ++i) {
                projectLocations.add((ProjectLocation)this.projects.getModel().getElementAt(indices[i]));
            }
        }
        return projectLocations;
    }

    protected abstract Action getOpenAction();

    protected abstract Action getSecurityAction();
}

