/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Appender;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransListener;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;

public class AddTransServlet
extends HttpServlet {
    private static final long serialVersionUID = -6850701762586992604L;
    private static LogWriter log = LogWriter.getInstance();
    public static final String CONTEXT_PATH = "/kettle/addTrans";
    private TransformationMap transformationMap;
    private SocketRepository socketRepository;

    public AddTransServlet(TransformationMap transformationMap, SocketRepository socketRepository) {
        this.transformationMap = transformationMap;
        this.socketRepository = socketRepository;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.getRequestURI().equals("/kettle/addTrans/")) {
            return;
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), "Addition of transformation requested", new Object[0]);
        }
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        PrintWriter out = response.getWriter();
        BufferedReader in = request.getReader();
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), "Encoding: " + request.getCharacterEncoding(), new Object[0]);
        }
        if (useXML) {
            response.setContentType("text/xml");
            out.print(XMLHandler.getXMLHeader());
        } else {
            response.setContentType("text/html");
            out.println("<HTML>");
            out.println("<HEAD><TITLE>Add transformation</TITLE></HEAD>");
            out.println("<BODY>");
        }
        response.setStatus(200);
        try {
            int c;
            StringBuilder xml = new StringBuilder(request.getContentLength());
            while ((c = in.read()) != -1) {
                xml.append((char)c);
            }
            TransConfiguration transConfiguration = TransConfiguration.fromXML(xml.toString());
            TransMeta transMeta = transConfiguration.getTransMeta();
            TransExecutionConfiguration transExecutionConfiguration = transConfiguration.getTransExecutionConfiguration();
            log.setLogLevel(transExecutionConfiguration.getLogLevel());
            if (log.getLogLevel() >= 4) {
                log.logDetailed(this.toString(), "Logging level set to " + log.getLogLevelDesc(), new Object[0]);
            }
            transMeta.injectVariables(transExecutionConfiguration.getVariables());
            Map<String, String> params = transExecutionConfiguration.getParams();
            for (String param : params.keySet()) {
                String value = params.get(param);
                transMeta.setParameterValue(param, value);
            }
            final Repository repository = transConfiguration.getTransExecutionConfiguration().getRepository();
            Trans trans = new Trans(transMeta);
            trans.setRepository(repository);
            trans.setSocketRepository(this.socketRepository);
            Trans oldOne = this.transformationMap.getTransformation(trans.getName());
            if (oldOne != null && !oldOne.isStopped() && !oldOne.isFinished() && (oldOne.isRunning() || oldOne.isPreparing() || oldOne.isInitializing())) {
                throw new Exception("A transformation with the same name exists and is not idle." + Const.CR + "Please stop the transformation first.");
            }
            Appender appender = this.transformationMap.getAppender(trans.getName());
            if (appender != null) {
                log.removeAppender(appender);
                appender.close();
            }
            this.transformationMap.addTransformation(transMeta.getName(), trans, transConfiguration);
            if (repository != null) {
                trans.addTransListener(new TransListener(){

                    public void transFinished(Trans trans) {
                        repository.disconnect();
                    }
                });
            }
            trans.addTransListener(new TransListener(){

                public void transFinished(Trans trans) {
                    try {
                        trans.endProcessing("end");
                    }
                    catch (Exception e) {
                        log.logError(this.toString(), "There was an error while logging the transformation result to the logging table", (Throwable)e);
                    }
                }
            });
            String message = oldOne != null ? "Transformation '" + trans.getName() + "' was replaced in the list." : "Transformation '" + trans.getName() + "' was added to the list.";
            if (useXML) {
                out.println(new WebResult("OK", message));
            } else {
                out.println("<H1>" + message + "</H1>");
                out.println("<p><a href=\"/kettle/transStatus?name=" + trans.getName() + "\">Go to the transformation status page</a><p>");
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)));
            }
            out.println("<p>");
            out.println("<pre>");
            ex.printStackTrace(out);
            out.println("</pre>");
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Add Transformation";
    }
}

