/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Appender;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.Log4jStringAppender;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.www.Messages;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;

public class PrepareExecutionTransServlet
extends HttpServlet {
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/prepareExec";
    private static LogWriter log = LogWriter.getInstance();
    private TransformationMap transformationMap;

    public PrepareExecutionTransServlet(TransformationMap transformationMap) {
        this.transformationMap = transformationMap;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out;
        boolean useXML;
        block15: {
            if (!request.getContextPath().equals(CONTEXT_PATH)) {
                return;
            }
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("PrepareExecutionTransServlet.TransPrepareExecutionRequested"), new Object[0]);
            }
            String transName = request.getParameter("name");
            useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
            response.setStatus(200);
            out = response.getWriter();
            if (useXML) {
                response.setContentType("text/xml");
                out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
            } else {
                response.setContentType("text/html");
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<TITLE>" + Messages.getString("PrepareExecutionTransServlet.TransPrepareExecution") + "</TITLE>");
                out.println("<META http-equiv=\"Refresh\" content=\"2;url=/kettle/transStatus?name=" + URLEncoder.encode(transName, "UTF-8") + "\">");
                out.println("</HEAD>");
                out.println("<BODY>");
            }
            try {
                Trans trans = this.transformationMap.getTransformation(transName);
                TransConfiguration transConfiguration = this.transformationMap.getConfiguration(transName);
                if (trans != null && transConfiguration != null) {
                    TransExecutionConfiguration executionConfiguration = transConfiguration.getTransExecutionConfiguration();
                    log.setLogLevel(executionConfiguration.getLogLevel());
                    trans.getTransMeta().setArguments(executionConfiguration.getArgumentStrings());
                    trans.setReplayDate(executionConfiguration.getReplayDate());
                    trans.setSafeModeEnabled(executionConfiguration.isSafeModeEnabled());
                    trans.injectVariables(executionConfiguration.getVariables());
                    Log4jStringAppender appender = LogWriter.createStringAppender();
                    log.addAppender((Appender)appender);
                    this.transformationMap.addAppender(transName, (Appender)appender);
                    try {
                        trans.prepareExecution(null);
                        if (useXML) {
                            out.println(WebResult.OK.getXML());
                            break block15;
                        }
                        out.println("<H1>" + Messages.getString("PrepareExecutionTransServlet.TransPrepared", transName) + "</H1>");
                        out.println("<a href=\"/kettle/transStatus?name=" + URLEncoder.encode(transName, "UTF-8") + "\">" + Messages.getString("TransStatusServlet.BackToTransStatusPage") + "</a><p>");
                    }
                    catch (Exception e) {
                        if (useXML) {
                            out.println(new WebResult("ERROR", Messages.getString("PrepareExecutionTransServlet.Error.TransInitFailed", Const.CR + appender.getBuffer().toString() + Const.CR + e.getLocalizedMessage())));
                            break block15;
                        }
                        out.println("<H1>" + Messages.getString("PrepareExecutionTransServlet.Log.TransNotInit", transName) + "</H1>");
                        out.println("<pre>");
                        out.println(appender.getBuffer().toString());
                        out.println(e.getLocalizedMessage());
                        out.println("</pre>");
                        out.println("<a href=\"/kettle/transStatus?name=" + URLEncoder.encode(transName, "UTF-8") + "\">" + Messages.getString("TransStatusServlet.BackToTransStatusPage") + "</a><p>");
                    }
                    break block15;
                }
                if (useXML) {
                    out.println(new WebResult("ERROR", Messages.getString("TransStatusServlet.Log.CoundNotFindSpecTrans", transName)));
                } else {
                    out.println("<H1>" + Messages.getString("TransStatusServlet.Log.CoundNotFindTrans", transName) + "</H1>");
                    out.println("<a href=\"/kettle/status\">" + Messages.getString("TransStatusServlet.BackToStatusPage") + "</a><p>");
                }
            }
            catch (Exception ex) {
                if (useXML) {
                    out.println(new WebResult("ERROR", Messages.getString("PrepareExecutionTransServlet.Error.UnexpectedError", Const.CR + Const.getStackTracker((Throwable)ex))));
                }
                out.println("<p>");
                out.println("<pre>");
                ex.printStackTrace(out);
                out.println("</pre>");
            }
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Start transformation";
    }
}

