/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectStringParser {
    private final String s;
    private final int n;
    private int i;
    private final StringBuilder nameBuf;
    private final StringBuilder valueBuf;

    public static Map<String, String> parseConnectString(String s) {
        return new ConnectStringParser(s).parse();
    }

    private ConnectStringParser(String s) {
        this.s = s;
        this.i = 0;
        this.n = s.length();
        this.nameBuf = new StringBuilder(64);
        this.valueBuf = new StringBuilder(64);
    }

    private PropertyMap parse() {
        PropertyMap map = new PropertyMap();
        while (this.i < this.n) {
            this.parsePair(map);
        }
        return map;
    }

    private void parsePair(PropertyMap map) {
        String value;
        String name = this.parseName();
        if (name == null) {
            return;
        }
        if (this.i >= this.n) {
            value = "";
        } else if (this.s.charAt(this.i) == ';') {
            ++this.i;
            value = "";
        } else {
            value = this.parseValue();
        }
        map.put(name, value);
    }

    private String parseName() {
        this.nameBuf.setLength(0);
        block4: while (true) {
            char c = this.s.charAt(this.i);
            switch (c) {
                case '=': {
                    ++this.i;
                    if (this.i < this.n && (c = this.s.charAt(this.i)) == '=') {
                        ++this.i;
                        this.nameBuf.append(c);
                        continue block4;
                    }
                    String name = this.nameBuf.toString();
                    name = name.trim();
                    return name;
                }
                case ' ': {
                    if (this.nameBuf.length() != 0) break;
                    ++this.i;
                    if (this.i < this.n) continue block4;
                    return null;
                }
            }
            this.nameBuf.append(c);
            ++this.i;
            if (this.i >= this.n) break;
        }
        return this.nameBuf.toString().trim();
    }

    private String parseValue() {
        String value;
        char c;
        while ((c = this.s.charAt(this.i)) == ' ') {
            ++this.i;
            if (this.i < this.n) continue;
            return "";
        }
        if (c == '\"' || c == '\'') {
            String value2 = this.parseQuoted(c);
            while (this.i < this.n && (c = this.s.charAt(this.i)) == ' ') {
                ++this.i;
            }
            if (this.i >= this.n) {
                return value2;
            }
            if (c == ';') {
                ++this.i;
                return value2;
            }
            throw new RuntimeException("quoted value ended too soon, at position " + this.i + " in '" + this.s + "'");
        }
        int semi = this.s.indexOf(59, this.i);
        if (semi >= 0) {
            value = this.s.substring(this.i, semi);
            this.i = semi + 1;
        } else {
            value = this.s.substring(this.i);
            this.i = this.n;
        }
        return value.trim();
    }

    private String parseQuoted(char q) {
        char c = this.s.charAt(this.i++);
        assert (c == q);
        this.valueBuf.setLength(0);
        while (this.i < this.n) {
            c = this.s.charAt(this.i);
            if (c == q) {
                ++this.i;
                if (this.i < this.n && (c = this.s.charAt(this.i)) == q) {
                    this.valueBuf.append(c);
                    ++this.i;
                    continue;
                }
                return this.valueBuf.toString();
            }
            this.valueBuf.append(c);
            ++this.i;
        }
        throw new RuntimeException("Connect string '" + this.s + "' contains unterminated quoted value '" + this.valueBuf.toString() + "'");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyMap
    extends LinkedHashMap<String, String> {
        private final Map<String, String> originalKeys = new HashMap<String, String>();
        private static final String PROVIDER = PropertyMap.normalize("Provider");

        private PropertyMap() {
        }

        @Override
        public String get(Object key) {
            return (String)super.get(PropertyMap.normalize((String)key));
        }

        @Override
        public String remove(Object key) {
            return (String)super.remove(PropertyMap.normalize((String)key));
        }

        @Override
        public String put(String key, String value) {
            String normalizedKey = PropertyMap.normalize(key);
            if (normalizedKey.equals(PROVIDER) && this.containsKey(normalizedKey)) {
                return null;
            }
            this.originalKeys.put(normalizedKey, key);
            return super.put(normalizedKey, value);
        }

        @Override
        public boolean containsKey(Object key) {
            return super.containsKey(PropertyMap.normalize((String)key));
        }

        private static String normalize(String key) {
            return key.toUpperCase();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            int i = 0;
            for (Map.Entry entry : this.entrySet()) {
                if (i++ > 0) {
                    sb.append("; ");
                }
                String key = (String)entry.getKey();
                String originalKey = this.originalKeys.get(key);
                sb.append(originalKey);
                sb.append('=');
                String value = (String)entry.getValue();
                if (value == null) {
                    sb.append("'null'");
                    continue;
                }
                if (value.indexOf(59) >= 0 && value.charAt(0) != '\'') {
                    sb.append("'");
                }
                sb.append(value);
                if (value.indexOf(59) < 0 || value.charAt(value.length() - 1) == '\'') continue;
                sb.append("'");
            }
            return sb.toString();
        }
    }
}

