/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.Mixer;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.sound.SoundPlayer;

public class SoundController {
    private static final Logger logger = Logger.getLogger(SoundController.class.getName());
    private SoundPlayer soundPlayer;

    public SoundController(FreeColClient freeColClient, boolean sound) {
        ClientOptions opts = freeColClient.getClientOptions();
        if (sound) {
            this.soundPlayer = null;
            Option amo = opts.getOption("model.option.audioMixer");
            Option vo = opts.getOption("model.option.audioVolume");
            if (!(amo instanceof AudioMixerOption)) {
                logger.warning("model.option.audioMixer is not an AudioMixerOption");
            } else if (!(vo instanceof PercentageOption)) {
                logger.warning("model.option.audioVolume is not a PercentageOption");
            } else {
                try {
                    logger.log(Level.INFO, "Create sound controller with " + amo + "/" + vo);
                    this.soundPlayer = new SoundPlayer((AudioMixerOption)amo, (PercentageOption)vo);
                }
                catch (Exception e) {
                    this.soundPlayer = null;
                    logger.log(Level.WARNING, "Sound disabled", e);
                }
            }
        }
    }

    public boolean canPlaySound() {
        return this.soundPlayer != null;
    }

    public void playSound(String sound) {
        if (!this.canPlaySound()) {
            return;
        }
        if (sound == null) {
            this.soundPlayer.stop();
        } else {
            File file = ResourceManager.getAudio(sound);
            if (file != null) {
                this.soundPlayer.playOnce(file);
            }
            logger.finest((file == null ? "Could not load" : "Playing") + " sound: " + sound);
        }
    }

    public String getSoundMixerLabelText() {
        Mixer mixer;
        String text = this.soundPlayer == null ? Messages.message("nothing") : ((mixer = this.soundPlayer.getMixer()) == null ? Messages.message("none") : mixer.getMixerInfo().getName());
        return Messages.message("current") + ":  " + text;
    }
}

