/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.jnlp.JNLPFile;

public class LaunchException
extends Exception {
    private static final List<LaunchExceptionWithStamp> launchExceptionChain = Collections.synchronizedList(new LinkedList());
    private static final long serialVersionUID = 7283827853612357423L;
    private final JNLPFile file;
    private final String category;
    private final String summary;
    private final String description;
    private final String severity;

    public LaunchException(JNLPFile file, Exception cause, String severity, String category, String summary, String description) {
        super(severity + ": " + category + ": " + summary + " " + (description == null ? "" : description), cause);
        this.file = file;
        this.category = category;
        this.summary = summary;
        this.description = description;
        this.severity = severity;
        this.saveLaunchException(this);
    }

    public LaunchException(Throwable cause) {
        super(cause);
        this.file = null;
        this.category = null;
        this.summary = null;
        this.description = null;
        this.severity = null;
        this.saveLaunchException(this);
    }

    public LaunchException(String message, Throwable cause) {
        super(message, cause);
        this.file = null;
        this.category = null;
        this.summary = null;
        this.description = null;
        this.severity = null;
        this.saveLaunchException(this);
    }

    public LaunchException(String message) {
        super(message);
        this.file = null;
        this.category = null;
        this.summary = null;
        this.description = null;
        this.severity = null;
        this.saveLaunchException(this);
    }

    public JNLPFile getFile() {
        return this.file;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSeverity() {
        return this.severity;
    }

    private synchronized void saveLaunchException(LaunchException ex) {
        launchExceptionChain.add(new LaunchExceptionWithStamp(ex));
    }

    public static synchronized List<LaunchExceptionWithStamp> getLaunchExceptionChain() {
        return launchExceptionChain;
    }

    public static class LaunchExceptionWithStamp {
        private final LaunchException ex;
        private final Date stamp;

        private LaunchExceptionWithStamp(LaunchException ex) {
            this.ex = ex;
            this.stamp = new Date();
        }

        public LaunchException getEx() {
            return this.ex;
        }

        public Date getStamp() {
            return this.stamp;
        }
    }
}

