/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs.apptrustwarningpanel;

import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.dialogs.SecurityDialogPanel;
import net.sourceforge.jnlp.security.dialogs.apptrustwarningpanel.AppTrustWarningPanel;
import net.sourceforge.jnlp.security.dialogs.apptrustwarningpanel.MatchingALACAttributePanel;
import net.sourceforge.jnlp.security.dialogs.apptrustwarningpanel.PartiallySignedAppTrustWarningPanel;
import net.sourceforge.jnlp.security.dialogs.apptrustwarningpanel.UnsignedAppletTrustWarningPanel;

public class AppTrustWarningDialog
extends SecurityDialogPanel {
    private AppTrustWarningPanel.ActionChoiceListener listener;

    private AppTrustWarningDialog(SecurityDialog dialog) {
        super(dialog);
    }

    public static AppTrustWarningDialog unsigned(SecurityDialog dialog, JNLPFile file) {
        AppTrustWarningDialog warningDialog = new AppTrustWarningDialog(dialog);
        warningDialog.add(new UnsignedAppletTrustWarningPanel(dialog, file, warningDialog.getActionChoiceListener()));
        return warningDialog;
    }

    public static AppTrustWarningDialog partiallySigned(SecurityDialog dialog, JNLPFile file, JNLPClassLoader.SecurityDelegate securityDelegate) {
        AppTrustWarningDialog warningDialog = new AppTrustWarningDialog(dialog);
        warningDialog.add(new PartiallySignedAppTrustWarningPanel(file, warningDialog.getActionChoiceListener(), dialog, securityDelegate));
        return warningDialog;
    }

    public static AppTrustWarningDialog matchingAlaca(SecurityDialog x, JNLPFile file, String codebase, String remoteUrls) {
        AppTrustWarningDialog warningDialog = new AppTrustWarningDialog(x);
        warningDialog.add(new MatchingALACAttributePanel(x, file, codebase, remoteUrls, warningDialog.getActionChoiceListener()));
        return warningDialog;
    }

    private AppTrustWarningPanel.ActionChoiceListener getActionChoiceListener() {
        if (this.listener == null) {
            this.listener = this.createActionChoiceListener();
        }
        return this.listener;
    }

    private AppTrustWarningPanel.ActionChoiceListener createActionChoiceListener() {
        return new AppTrustWarningPanel.ActionChoiceListener(){

            @Override
            public void actionChosen(AppTrustWarningPanel.AppSigningWarningAction action) {
                AppTrustWarningDialog.this.parent.setValue(action);
                AppTrustWarningDialog.this.parent.dispose();
            }
        };
    }
}

