/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.search;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBSingleSelectionModel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.MainMenu;
import com.ca.directory.jxplorer.search.SearchModel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class DeleteFilterGUI
extends CBDialog {
    SearchModel searchModel = new SearchModel();
    JList list;
    MainMenu mainMenu;
    ArrayList filterNames;
    JXplorer jxplorer = null;
    private static Logger log = Logger.getLogger(DeleteFilterGUI.class.getName());

    public DeleteFilterGUI(JXplorer jxplorer) {
        super((Frame)jxplorer, CBIntText.get("Delete Search Filter"), "search.delete.filter");
        this.jxplorer = jxplorer;
        this.mainMenu = jxplorer.getMainMenu();
        this.filterNames = this.searchModel.getFilterNames(2);
        this.display.addln(new JLabel(CBIntText.get("Select a Search Filter to Delete:")));
        this.display.makeWide();
        this.display.add(this.getScrollList(this.filterNames.toArray(), this.filterNames.toArray()));
        CBButton btnDelete = new CBButton(CBIntText.get("Delete"), CBIntText.get("Delete the selected filters."));
        btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeleteFilterGUI.this.delete();
            }
        });
        this.buttonPanel.removeAll();
        this.buttonPanel.add(btnDelete);
        this.buttonPanel.add(this.Cancel);
        this.buttonPanel.add(this.Help);
        btnDelete.setToolTipText(CBIntText.get("Click here to delete the selected filter."));
        this.Cancel.setToolTipText(CBIntText.get("Click here to exit."));
        this.Help.setToolTipText(CBIntText.get("Click here for Help."));
        this.setSize(300, 200);
        CBUtility.center(this, jxplorer);
    }

    protected JScrollPane getScrollList(Object[] items, Object[] toolTips) {
        Object[] names = items;
        final Object[] toolTps = toolTips;
        this.list = new JList(names){

            public String getToolTipText(MouseEvent e) {
                int index = this.locationToIndex(e.getPoint());
                if (-1 < index) {
                    return toolTps[index].toString();
                }
                return null;
            }
        };
        this.list.setSelectionMode(0);
        this.list.setSelectionModel(new CBSingleSelectionModel(this.list));
        this.list.setToolTipText("");
        JScrollPane sp = new JScrollPane(this.list);
        sp.setPreferredSize(new Dimension(250, 100));
        sp.setMinimumSize(new Dimension(250, 100));
        sp.setAlignmentX(0.0f);
        return sp;
    }

    public void delete() {
        if (this.filterNames.size() <= 0) {
            return;
        }
        if (this.list.getSelectedIndex() == -1) {
            int response = JOptionPane.showConfirmDialog(this, CBIntText.get("No filter selected.  Try again?"), CBIntText.get("No Filter Selected"), 0);
            if (response == 1) {
                this.setVisible(false);
                this.dispose();
                return;
            }
            return;
        }
        Object value = this.list.getSelectedValue();
        boolean text = false;
        if (this.searchModel.isTextFilter(value.toString())) {
            text = true;
        }
        if (!text) {
            int i;
            ArrayList dependantFilters = this.searchModel.getDependants(value);
            String[] names = dependantFilters.toArray(new String[dependantFilters.size()]);
            StringBuffer buffy = new StringBuffer();
            for (i = 1; i < names.length; ++i) {
                buffy.append(names[i].substring(names[i].indexOf(".") + 1));
                buffy.append("\n");
            }
            int response = names.length == 1 ? JOptionPane.showConfirmDialog(this, CBIntText.get("Are you sure you want to delete: ''{0}'' ?", new String[]{value.toString()}), CBIntText.get("Delete Information"), 0) : JOptionPane.showConfirmDialog(this, CBIntText.get("Deleting ''{0}'' will also delete these dependant filters: ''{1}''\nDo you want to continue?\n\n", new String[]{value.toString(), buffy.toString()}), CBIntText.get("Delete Information"), 0);
            if (response == 0) {
                this.searchModel.removeFilters(names);
                this.mainMenu.updateSearchMenu();
                try {
                    for (i = 0; i < names.length; ++i) {
                        this.filterNames.remove(names[i].substring(names[i].indexOf(".") + 1));
                        log.info("Deleted search filter: " + names[i].substring(names[i].indexOf(".") + 1));
                    }
                    this.list.setListData(this.filterNames.toArray());
                }
                catch (Exception e) {
                    log.warning("No selection to remove.");
                }
            }
        } else {
            int response = JOptionPane.showConfirmDialog(this, CBIntText.get("Are you sure you want to delete: ''{0}'' ?", new String[]{value.toString()}), CBIntText.get("Delete Information"), 0);
            if (response == 0) {
                this.searchModel.removeFilter("JXTextFilter." + value.toString());
                this.mainMenu.updateSearchMenu();
                try {
                    this.filterNames.remove(value.toString().substring(value.toString().indexOf(".") + 1));
                    log.info("Deleted search filter: " + value.toString().substring(value.toString().indexOf(".") + 1));
                    this.list.setListData(this.filterNames.toArray());
                }
                catch (Exception e) {
                    log.warning("No selection to remove.");
                }
            }
        }
        this.jxplorer.getTree().setSearchGUI(null);
        this.jxplorer.getSearchTree().setSearchGUI(null);
        this.jxplorer.getSchemaTree().setSearchGUI(null);
    }
}

