/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.base.Preconditions;
import org.apache.solr.cloud.DistributedCollectionLockFactory;
import org.apache.solr.cloud.DistributedLock;
import org.apache.solr.cloud.ZkDistributedLockFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.params.CollectionParams;

public class ZkDistributedCollectionLockFactory
extends ZkDistributedLockFactory
implements DistributedCollectionLockFactory {
    public ZkDistributedCollectionLockFactory(SolrZkClient zkClient, String rootPath) {
        super(zkClient, rootPath);
    }

    @Override
    public DistributedLock createLock(boolean isWriteLock, CollectionParams.LockLevel level, String collName, String shardId, String replicaName) {
        Preconditions.checkArgument((collName != null ? 1 : 0) != 0, (Object)"collName can't be null");
        Preconditions.checkArgument((level == CollectionParams.LockLevel.COLLECTION || shardId != null ? 1 : 0) != 0, (Object)"shardId can't be null when getting lock for shard or replica");
        Preconditions.checkArgument((level != CollectionParams.LockLevel.REPLICA || replicaName != null ? 1 : 0) != 0, (Object)"replicaName can't be null when getting lock for replica");
        String lockPath = this.getLockPath(level, collName, shardId, replicaName);
        return this.doCreateLock(isWriteLock, lockPath);
    }

    private String getLockPath(CollectionParams.LockLevel level, String collName, String shardId, String replicaName) {
        StringBuilder path = this.getPathPrefix();
        path.append(collName).append("/");
        String LOCK_NODENAME = "Locks";
        String SUBNODE_PREFIX = "_";
        if (level == CollectionParams.LockLevel.COLLECTION) {
            return path.append("Locks").toString();
        }
        if (level == CollectionParams.LockLevel.SHARD) {
            return path.append("_").append(shardId).append("/").append("Locks").toString();
        }
        if (level == CollectionParams.LockLevel.REPLICA) {
            return path.append("_").append(shardId).append("/").append("_").append(replicaName).toString();
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported lock level " + level);
    }
}

