/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema.analysis;

import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.synonym.SynonymFilterFactory;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.ManagedResource;
import org.apache.solr.rest.ManagedResourceStorage;
import org.apache.solr.rest.schema.analysis.BaseManagedTokenFilterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ManagedSynonymFilterFactory
extends BaseManagedTokenFilterFactory {
    public static final String NAME = "managedSynonym";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SYNONYM_MAPPINGS = "synonymMappings";
    public static final String IGNORE_CASE_INIT_ARG = "ignoreCase";
    protected SynonymFilterFactory delegate;

    public ManagedSynonymFilterFactory(Map<String, String> args) {
        super(args);
    }

    public ManagedSynonymFilterFactory() {
        throw ManagedSynonymFilterFactory.defaultCtorException();
    }

    @Override
    public String getResourceId() {
        return "/schema/analysis/synonyms/" + this.handle;
    }

    @Override
    protected Class<? extends ManagedResource> getManagedResourceImplClass() {
        return SynonymManager.class;
    }

    @Override
    public void onManagedResourceInitialized(NamedList<?> initArgs, final ManagedResource res) throws SolrException {
        NamedList<?> args = initArgs;
        args.add("synonyms", (Object)this.getResourceId());
        args.add("expand", (Object)"false");
        args.add("format", (Object)"solr");
        HashMap<String, String> filtArgs = new HashMap<String, String>();
        for (Map.Entry entry : args) {
            filtArgs.put((String)entry.getKey(), entry.getValue().toString());
        }
        this.delegate = new SynonymFilterFactory(filtArgs){

            protected SynonymMap loadSynonyms(ResourceLoader loader, String cname, boolean dedup, Analyzer analyzer) throws IOException, ParseException {
                ManagedSynonymParser parser = new ManagedSynonymParser((SynonymManager)res, dedup, analyzer);
                parser.parse(null);
                return parser.build();
            }
        };
        try {
            this.delegate.inform((ResourceLoader)res.getResourceLoader());
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public TokenStream create(TokenStream input) {
        if (this.delegate == null) {
            throw new IllegalStateException(this.getClass().getName() + " not initialized correctly! The SynonymFilterFactory delegate was not initialized.");
        }
        return this.delegate.create(input);
    }

    private class ManagedSynonymParser
    extends SynonymMap.Parser {
        SynonymManager synonymManager;

        public ManagedSynonymParser(SynonymManager synonymManager, boolean dedup, Analyzer analyzer) {
            super(dedup, analyzer);
            this.synonymManager = synonymManager;
        }

        public void parse(Reader in) throws IOException, ParseException {
            boolean ignoreCase = this.synonymManager.getIgnoreCase();
            for (CasePreservedSynonymMappings cpsm : this.synonymManager.synonymMappings.values()) {
                for (Map.Entry<String, Set<String>> entry : cpsm.mappings.entrySet()) {
                    for (String mapping : entry.getValue()) {
                        CharsRef casedTerm = this.analyze(this.synonymManager.applyCaseSetting(ignoreCase, entry.getKey()), new CharsRefBuilder());
                        CharsRef casedMapping = this.analyze(this.synonymManager.applyCaseSetting(ignoreCase, mapping), new CharsRefBuilder());
                        this.add(casedTerm, casedMapping, false);
                    }
                }
            }
        }
    }

    public static class SynonymManager
    extends ManagedResource
    implements ManagedResource.ChildResourceSupport {
        protected Map<String, CasePreservedSynonymMappings> synonymMappings;

        public SynonymManager(String resourceId, SolrResourceLoader loader, ManagedResourceStorage.StorageIO storageIO) throws SolrException {
            super(resourceId, loader, storageIO);
        }

        @Override
        protected void onManagedDataLoadedFromStorage(NamedList<?> managedInitArgs, Object managedData) throws SolrException {
            NamedList<?> initArgs = managedInitArgs;
            String format = (String)initArgs.get("format");
            if (format != null && !"solr".equals(format)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid format " + format + "! Only 'solr' is supported.");
            }
            if (initArgs.get(ManagedSynonymFilterFactory.IGNORE_CASE_INIT_ARG) == null) {
                initArgs.add(ManagedSynonymFilterFactory.IGNORE_CASE_INIT_ARG, (Object)Boolean.FALSE);
            }
            boolean ignoreCase = this.getIgnoreCase(managedInitArgs);
            this.synonymMappings = new TreeMap<String, CasePreservedSynonymMappings>();
            if (managedData != null) {
                Map storedSyns = (Map)managedData;
                for (Map.Entry entry : storedSyns.entrySet()) {
                    Object mapping;
                    String key = (String)entry.getKey();
                    String caseKey = this.applyCaseSetting(ignoreCase, key);
                    CasePreservedSynonymMappings cpsm = this.synonymMappings.get(caseKey);
                    if (cpsm == null) {
                        cpsm = new CasePreservedSynonymMappings();
                        this.synonymMappings.put(caseKey, cpsm);
                    }
                    if (!((mapping = entry.getValue()) instanceof List)) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid synonym file format! Expected a list of synonyms for " + key + " but got " + mapping.getClass().getName());
                    }
                    TreeSet sortedVals = new TreeSet((List)entry.getValue());
                    cpsm.mappings.put(key, sortedVals);
                }
            }
            if (log.isInfoEnabled()) {
                log.info("Loaded {} synonym mappings for {}", (Object)this.synonymMappings.size(), (Object)this.getResourceId());
            }
        }

        @Override
        protected Object applyUpdatesToManagedData(Object updates) {
            boolean ignoreCase = this.getIgnoreCase();
            boolean madeChanges = false;
            if (updates instanceof List) {
                madeChanges = this.applyListUpdates((List)updates, ignoreCase);
            } else if (updates instanceof Map) {
                madeChanges = this.applyMapUpdates((Map)updates, ignoreCase);
            } else {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported data format (" + updates.getClass().getName() + "); expected a JSON object (Map or List)!");
            }
            return madeChanges ? this.getStoredView() : null;
        }

        protected boolean applyListUpdates(List<String> jsonList, boolean ignoreCase) {
            boolean madeChanges = false;
            Iterator<String> iterator = jsonList.iterator();
            while (iterator.hasNext()) {
                String term;
                String origTerm = term = iterator.next();
                CasePreservedSynonymMappings cpsm = this.synonymMappings.get(term = this.applyCaseSetting(ignoreCase, term));
                if (cpsm == null) {
                    cpsm = new CasePreservedSynonymMappings();
                }
                TreeSet<String> treeTerms = new TreeSet<String>(jsonList);
                cpsm.mappings.put(origTerm, treeTerms);
                madeChanges = true;
                if (this.synonymMappings.containsKey(term) || cpsm.mappings.get(origTerm) == null) continue;
                this.synonymMappings.put(term, cpsm);
            }
            return madeChanges;
        }

        protected boolean applyMapUpdates(Map<String, Object> jsonMap, boolean ignoreCase) {
            boolean madeChanges = false;
            Iterator<String> iterator = jsonMap.keySet().iterator();
            while (iterator.hasNext()) {
                String term;
                String origTerm = term = iterator.next();
                CasePreservedSynonymMappings cpsm = this.synonymMappings.get(term = this.applyCaseSetting(ignoreCase, term));
                if (cpsm == null) {
                    cpsm = new CasePreservedSynonymMappings();
                }
                Set<String> output = cpsm.mappings.get(origTerm);
                Object val = jsonMap.get(origTerm);
                if (val instanceof String) {
                    String strVal = (String)val;
                    if (output == null) {
                        output = new TreeSet<String>();
                        cpsm.mappings.put(origTerm, output);
                    }
                    if (output.add(strVal)) {
                        madeChanges = true;
                    }
                } else if (val instanceof List) {
                    List vals = (List)val;
                    if (output == null) {
                        output = new TreeSet<String>();
                        cpsm.mappings.put(origTerm, output);
                    }
                    for (String nextVal : vals) {
                        if (!output.add(nextVal)) continue;
                        madeChanges = true;
                    }
                } else {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported value " + val + " for " + term + "; expected single value or a JSON array!");
                }
                if (this.synonymMappings.containsKey(term) || cpsm.mappings.get(origTerm) == null) continue;
                this.synonymMappings.put(term, cpsm);
            }
            return madeChanges;
        }

        protected Map<String, Set<String>> getStoredView() {
            TreeMap<String, Set<String>> storedView = new TreeMap<String, Set<String>>();
            for (CasePreservedSynonymMappings cpsm : this.synonymMappings.values()) {
                for (Map.Entry<String, Set<String>> entry : cpsm.mappings.entrySet()) {
                    storedView.put(entry.getKey(), entry.getValue());
                }
            }
            return storedView;
        }

        protected String applyCaseSetting(boolean ignoreCase, String str) {
            return ignoreCase && str != null ? str.toLowerCase(Locale.ROOT) : str;
        }

        public boolean getIgnoreCase() {
            return this.getIgnoreCase(this.managedInitArgs);
        }

        public boolean getIgnoreCase(NamedList<?> initArgs) {
            Boolean ignoreCase = initArgs.getBooleanArg(ManagedSynonymFilterFactory.IGNORE_CASE_INIT_ARG);
            return null == ignoreCase ? false : ignoreCase;
        }

        @Override
        public void doGet(BaseSolrResource endpoint, String childId) {
            SolrQueryResponse response = endpoint.getSolrResponse();
            if (childId != null) {
                Set<String> mappings;
                boolean ignoreCase = this.getIgnoreCase();
                String key = this.applyCaseSetting(ignoreCase, childId);
                CasePreservedSynonymMappings cpsm = this.synonymMappings.get(key);
                Set<String> set = mappings = cpsm != null ? cpsm.getMappings(ignoreCase, childId) : null;
                if (mappings == null) {
                    throw new SolrException(SolrException.ErrorCode.NOT_FOUND, String.format(Locale.ROOT, "%s not found in %s", childId, this.getResourceId()));
                }
                response.add(childId, mappings);
            } else {
                response.add(ManagedSynonymFilterFactory.SYNONYM_MAPPINGS, this.buildMapToStore(this.getStoredView()));
            }
        }

        @Override
        public synchronized void doDeleteChild(BaseSolrResource endpoint, String childId) {
            boolean ignoreCase = this.getIgnoreCase();
            String key = this.applyCaseSetting(ignoreCase, childId);
            CasePreservedSynonymMappings cpsm = this.synonymMappings.get(key);
            if (cpsm == null) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, String.format(Locale.ROOT, "%s not found in %s", childId, this.getResourceId()));
            }
            if (ignoreCase) {
                this.synonymMappings.remove(key);
            } else if (cpsm.mappings.containsKey(childId)) {
                cpsm.mappings.remove(childId);
                if (cpsm.mappings.isEmpty()) {
                    this.synonymMappings.remove(key);
                }
            } else {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, String.format(Locale.ROOT, "%s not found in %s", childId, this.getResourceId()));
            }
            this.storeManagedData(this.getStoredView());
            log.info("Removed synonym mappings for: {}", (Object)childId);
        }
    }

    private static class CasePreservedSynonymMappings {
        Map<String, Set<String>> mappings = new TreeMap<String, Set<String>>();

        private CasePreservedSynonymMappings() {
        }

        Set<String> getMappings(boolean ignoreCase, String key) {
            Set<String> synMappings = null;
            if (ignoreCase) {
                if (this.mappings.size() == 1) {
                    return this.mappings.values().iterator().next();
                }
                synMappings = new TreeSet<String>();
                for (Set<String> next : this.mappings.values()) {
                    synMappings.addAll(next);
                }
            } else {
                synMappings = this.mappings.get(key);
            }
            return synMappings;
        }

        public String toString() {
            return this.mappings.toString();
        }
    }
}

