/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function.distance;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.distance.GeodesicSphereDistCalc;
import org.locationtech.spatial4j.io.GeohashUtils;
import org.locationtech.spatial4j.shape.Point;

@Deprecated
public class GeohashHaversineFunction
extends ValueSource {
    private final ValueSource geoHash1;
    private final ValueSource geoHash2;
    private final SpatialContext ctx;
    private final double degreesToDist;

    public GeohashHaversineFunction(ValueSource geoHash1, ValueSource geoHash2, double radius) {
        this.geoHash1 = geoHash1;
        this.geoHash2 = geoHash2;
        this.degreesToDist = DistanceUtils.degrees2Dist((double)1.0, (double)radius);
        this.ctx = SpatialContext.GEO;
        assert (this.ctx.getDistCalc() instanceof GeodesicSphereDistCalc.Haversine);
    }

    protected String name() {
        return "ghhsin";
    }

    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues gh1DV = this.geoHash1.getValues(context, readerContext);
        final FunctionValues gh2DV = this.geoHash2.getValues(context, readerContext);
        return new DoubleDocValues(this){

            public double doubleVal(int doc) throws IOException {
                return GeohashHaversineFunction.this.distance(doc, gh1DV, gh2DV);
            }

            public String toString(int doc) throws IOException {
                StringBuilder sb = new StringBuilder();
                sb.append(GeohashHaversineFunction.this.name()).append('(');
                sb.append(gh1DV.toString(doc)).append(',').append(gh2DV.toString(doc));
                sb.append(')');
                return sb.toString();
            }
        };
    }

    protected double distance(int doc, FunctionValues gh1DV, FunctionValues gh2DV) throws IOException {
        double result = 0.0;
        String h1 = gh1DV.strVal(doc);
        String h2 = gh2DV.strVal(doc);
        if (h1 != null && h2 != null && !h1.equals(h2)) {
            Point p1 = GeohashUtils.decode((String)h1, (SpatialContext)this.ctx);
            Point p2 = GeohashUtils.decode((String)h2, (SpatialContext)this.ctx);
            result = this.ctx.getDistCalc().distance(p1, p2) * this.degreesToDist;
        } else if (h1 == null || h2 == null) {
            result = Double.MAX_VALUE;
        }
        return result;
    }

    public void createWeight(Map<Object, Object> context, IndexSearcher searcher) throws IOException {
        this.geoHash1.createWeight(context, searcher);
        this.geoHash2.createWeight(context, searcher);
    }

    public boolean equals(Object o) {
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GeohashHaversineFunction other = (GeohashHaversineFunction)((Object)o);
        return this.name().equals(other.name()) && this.geoHash1.equals((Object)other.geoHash1) && this.geoHash2.equals((Object)other.geoHash2) && this.degreesToDist == other.degreesToDist;
    }

    public int hashCode() {
        int result = this.geoHash1.hashCode();
        result = 31 * result + this.geoHash2.hashCode();
        result = 31 * result + this.name().hashCode();
        long temp = Double.doubleToRawLongBits(this.degreesToDist);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name()).append('(');
        sb.append(this.geoHash1).append(',').append(this.geoHash2);
        sb.append(')');
        return sb.toString();
    }
}

